/*
 * Decompiled with CFR 0.152.
 */
package ru.liko.wrbdrones.network;

import com.atsuishio.superbwarfare.entity.vehicle.DroneEntity;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import ru.liko.wrbdrones.entity.AddonDroneEntity;

public final class ExitDroneControlPacket {
    public static void encode(ExitDroneControlPacket packet, FriendlyByteBuf buf) {
    }

    public static ExitDroneControlPacket decode(FriendlyByteBuf buf) {
        return new ExitDroneControlPacket();
    }

    public static void handle(ExitDroneControlPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> ExitDroneControlPacket.handlePacket(packet, context));
        context.setPacketHandled(true);
    }

    private static void handlePacket(ExitDroneControlPacket packet, NetworkEvent.Context context) {
        ServerPlayer sender = context.getSender();
        if (sender == null) {
            return;
        }
        ItemStack stack = sender.m_21205_();
        if (!stack.m_150930_((Item)ModItems.MONITOR.get())) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128471_("Linked") || !tag.m_128471_("Using")) {
            return;
        }
        String droneId = tag.m_128461_("LinkedDrone");
        if (droneId == null || droneId.isEmpty() || droneId.equals("none")) {
            return;
        }
        DroneEntity drone = EntityFindUtil.findDrone((Level)sender.m_9236_(), (String)droneId);
        if (!(drone instanceof AddonDroneEntity)) {
            return;
        }
        AddonDroneEntity addonDrone = (AddonDroneEntity)drone;
        String controllerId = (String)addonDrone.m_20088_().m_135370_(DroneEntity.CONTROLLER);
        if (controllerId == null || controllerId.isEmpty() || controllerId.equals("undefined")) {
            return;
        }
        if (!Objects.equals(sender.m_20149_(), controllerId)) {
            return;
        }
        if (sender.m_20202_() != addonDrone) {
            return;
        }
        addonDrone.endRemoteControl(sender);
        tag.m_128379_("Using", false);
    }
}

