/*
 * Decompiled with CFR 0.152.
 */
package ru.liko.wrbdrones.network;

import com.atsuishio.superbwarfare.entity.vehicle.DroneEntity;
import com.atsuishio.superbwarfare.init.ModItems;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import ru.liko.wrbdrones.entity.AddonDroneEntity;

public final class DroneSignalLostPacket {
    private final UUID droneId;

    public DroneSignalLostPacket(@NotNull UUID droneId) {
        this.droneId = Objects.requireNonNull(droneId, "droneId");
    }

    @NotNull
    public UUID getDroneId() {
        return this.droneId;
    }

    public static void encode(@NotNull DroneSignalLostPacket packet, FriendlyByteBuf buf) {
        buf.m_130077_(packet.getDroneId());
    }

    @NotNull
    public static DroneSignalLostPacket decode(FriendlyByteBuf buf) {
        UUID id = Objects.requireNonNull(buf.m_130259_(), "droneId");
        return new DroneSignalLostPacket(id);
    }

    public static void handle(DroneSignalLostPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> DroneSignalLostPacket.handlePacket(packet, context));
        context.setPacketHandled(true);
    }

    private static void handlePacket(DroneSignalLostPacket packet, NetworkEvent.Context context) {
        AddonDroneEntity drone;
        UUID droneId;
        ServerPlayer sender = context.getSender();
        if (sender == null) {
            return;
        }
        ServerLevel level = sender.m_284548_();
        Entity entity = level.m_8791_(droneId = packet.getDroneId());
        if (!(entity instanceof AddonDroneEntity) || (drone = (AddonDroneEntity)entity).m_213877_()) {
            return;
        }
        if (!DroneSignalLostPacket.isAuthorized(sender, drone)) {
            return;
        }
        drone.handleSignalLoss(sender);
    }

    private static boolean isAuthorized(ServerPlayer player, AddonDroneEntity drone) {
        Item monitorItem;
        String controllerId = (String)drone.m_20088_().m_135370_(DroneEntity.CONTROLLER);
        if (controllerId != null) {
            controllerId = controllerId.trim();
        }
        if (controllerId != null && !controllerId.isEmpty() && !controllerId.equalsIgnoreCase("undefined") && !controllerId.equalsIgnoreCase("none") && Objects.equals(player.m_20149_(), controllerId)) {
            return true;
        }
        ItemStack heldStack = player.m_21205_();
        if (!heldStack.m_150930_(monitorItem = Objects.requireNonNull((Item)ModItems.MONITOR.get(), "monitor"))) {
            return false;
        }
        CompoundTag tag = heldStack.m_41784_();
        if (!tag.m_128471_("Linked") || !tag.m_128471_("Using")) {
            return false;
        }
        return drone.m_20149_().equals(tag.m_128461_("LinkedDrone"));
    }
}

