/*
 * Decompiled with CFR 0.152.
 */
package ru.liko.wrbdrones.item;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import ru.liko.wrbdrones.entity.AddonDroneEntity;

public class AddonDroneItem
extends Item {
    private final Supplier<? extends EntityTypeAccessor> entityTypeSupplier;
    private final Consumer<AddonDroneEntity> loadout;

    public AddonDroneItem(Item.Properties properties, Supplier<? extends EntityTypeAccessor> entityTypeSupplier, Consumer<AddonDroneEntity> loadout) {
        super(properties);
        this.entityTypeSupplier = entityTypeSupplier;
        this.loadout = loadout;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ItemStack stack = context.m_43722_();
        BlockPos clickedPos = context.m_8083_();
        Direction face = context.m_43719_();
        BlockState state = level.m_8055_(clickedPos);
        BlockPos placePos = state.m_60812_((BlockGetter)level, clickedPos).m_83281_() ? clickedPos : clickedPos.m_121945_(face);
        Entity entity = this.entityTypeSupplier.get().spawn(serverLevel, stack, context.m_43723_(), placePos, MobSpawnType.SPAWN_EGG, true, !Objects.equals(clickedPos, placePos) && face == Direction.UP);
        if (entity != null) {
            stack.m_41774_(1);
            level.m_142346_((Entity)context.m_43723_(), GameEvent.f_157810_, clickedPos);
            this.applyLoadout(entity);
        }
        return InteractionResult.CONSUME;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        BlockHitResult hitResult = AddonDroneItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (hitResult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (!(level instanceof ServerLevel)) {
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockPos pos = hitResult.m_82425_();
        if (!(level.m_8055_(pos).m_60734_() instanceof LiquidBlock)) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (!level.m_7966_(player, pos) || !player.m_36204_(pos, hitResult.m_82434_(), stack)) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        Entity entity = this.entityTypeSupplier.get().spawn(serverLevel, stack, player, pos, MobSpawnType.SPAWN_EGG, false, false);
        if (entity == null) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        this.applyLoadout(entity);
        if (!player.m_150110_().f_35937_) {
            stack.m_41774_(1);
        }
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        level.m_220400_((Entity)player, GameEvent.f_157810_, entity.m_20182_());
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    private void applyLoadout(Entity entity) {
        if (entity instanceof AddonDroneEntity) {
            AddonDroneEntity addon = (AddonDroneEntity)entity;
            if (this.loadout != null) {
                this.loadout.accept(addon);
            } else {
                addon.applySpawnLoadout();
            }
        }
    }

    public static EntityTypeAccessor fromType(Supplier<? extends EntityType<? extends AddonDroneEntity>> typeSupplier) {
        return (level, stack, player, pos, spawnType, alignPosition, waterPlace) -> ((EntityType)typeSupplier.get()).m_20592_(level, stack, player, pos, spawnType, alignPosition, waterPlace);
    }

    @FunctionalInterface
    public static interface EntityTypeAccessor {
        public Entity spawn(ServerLevel var1, ItemStack var2, Player var3, BlockPos var4, MobSpawnType var5, boolean var6, boolean var7);
    }
}

