/*
 * Decompiled with CFR 0.152.
 */
package ru.liko.wrbdrones.entity;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import ru.liko.wrbdrones.registry.ModItems;
import ru.liko.wrbdrones.registry.ModSounds;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class RebEntity
extends Entity
implements GeoEntity {
    private static final EntityDataAccessor<Boolean> IS_ENABLED = SynchedEntityData.m_135353_(RebEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean wasOnGround = false;
    private boolean hasPlayedPlacementSound = false;

    public RebEntity(EntityType<RebEntity> type, Level level) {
        super(type, level);
        this.m_20242_(false);
        this.f_19804_.m_135381_(IS_ENABLED, (Object)true);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(IS_ENABLED, (Object)true);
    }

    public boolean isEnabled() {
        return (Boolean)this.f_19804_.m_135370_(IS_ENABLED);
    }

    public void setEnabled(boolean enabled) {
        this.f_19804_.m_135381_(IS_ENABLED, (Object)enabled);
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_6094_() {
        return false;
    }

    @NotNull
    public InteractionResult m_6096_(@NotNull Player player, @NotNull InteractionHand hand) {
        if (player.m_6144_()) {
            if (!this.m_9236_().m_5776_()) {
                if (!player.m_150110_().f_35937_) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)ModItems.REB.get()));
                }
                this.m_146870_();
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        if (!this.m_9236_().m_5776_() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            boolean newState = !this.isEnabled();
            this.setEnabled(newState);
            if (newState) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.REB_TOGGLE_ON.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                serverPlayer.m_5661_((Component)Component.m_237115_((String)"wrbdrones.reb.enabled"), true);
            } else {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.REB_TOGGLE_OFF.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                serverPlayer.m_5661_((Component)Component.m_237115_((String)"wrbdrones.reb.disabled"), true);
            }
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
    }

    public void m_8119_() {
        super.m_8119_();
        boolean isOnGround = this.m_20096_();
        if (isOnGround && !this.wasOnGround && !this.hasPlayedPlacementSound && !this.m_9236_().m_5776_()) {
            this.playPlacementSound();
            this.hasPlayedPlacementSound = true;
        }
        this.wasOnGround = isOnGround;
        if (!isOnGround) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
            this.m_6478_(MoverType.SELF, this.m_20184_());
        } else {
            this.m_20334_(0.0, 0.0, 0.0);
        }
    }

    private void playPlacementSound() {
        SoundEvent sound = this.f_19796_.m_188499_() ? (SoundEvent)ModSounds.REB_PLACEMENT_01.get() : (SoundEvent)ModSounds.REB_PLACEMENT_02.get();
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), sound, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    protected void m_7378_(@NotNull CompoundTag pCompound) {
        if (pCompound.m_128441_("IsEnabled")) {
            this.setEnabled(pCompound.m_128471_("IsEnabled"));
        }
        this.hasPlayedPlacementSound = true;
    }

    protected void m_7380_(@NotNull CompoundTag pCompound) {
        pCompound.m_128379_("IsEnabled", this.isEnabled());
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "on_off_controller", 0, state -> {
            if (this.isEnabled()) {
                return state.setAndContinue(RawAnimation.begin().thenPlay("on"));
            }
            return state.setAndContinue(RawAnimation.begin().thenPlay("off"));
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

