/*
 * Decompiled with CFR 0.152.
 */
package ru.liko.wrbdrones.entity;

import com.atsuishio.superbwarfare.entity.vehicle.DroneEntity;
import java.lang.reflect.Field;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import ru.liko.wrbdrones.Wrbdrones;
import ru.liko.wrbdrones.entity.AddonDroneEntity;

public class MavicDroneWithDropEntity
extends AddonDroneEntity {
    private static final Set<String> ALLOWED_ATTACHMENTS = Set.of("superbwarfare:medical_kit", "superbwarfare:rgo_grenade", "superbwarfare:blu_43_mine");
    private static final int MAX_GRENADES = 2;

    public MavicDroneWithDropEntity(EntityType<? extends DroneEntity> type, Level level) {
        super(type, level);
    }

    @Override
    public ResourceLocation getModelResource() {
        return Wrbdrones.id("geo/mavic_drone_with_drop.geo.json");
    }

    @Override
    public ResourceLocation getTextureResource() {
        return Wrbdrones.id("textures/entity/mavic_drone.png");
    }

    @Override
    protected Set<String> getAllowedAttachments() {
        return ALLOWED_ATTACHMENTS;
    }

    @Override
    @NotNull
    public InteractionResult m_6096_(@NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        String itemId = this.getItemId(stack);
        if (!stack.m_41619_() && !player.m_6047_() && "superbwarfare:rgo_grenade".equals(itemId) && ALLOWED_ATTACHMENTS.contains(itemId)) {
            if (!this.m_9236_().m_5776_()) {
                ammoAccessor = MavicDroneWithDropEntity.getAmmoAccessor();
                if (ammoAccessor != null && (currentAmmo = ((Integer)this.m_20088_().m_135370_(ammoAccessor)).intValue()) >= 2) {
                    @NotNull MutableComponent message = Component.m_237115_((String)"tips.wrbdrones.drone.max_grenades_reached").m_130940_(ChatFormatting.RED);
                    player.m_5661_((Component)message, true);
                    return InteractionResult.m_19078_((boolean)false);
                }
            } else {
                ammoAccessor = MavicDroneWithDropEntity.getAmmoAccessor();
                if (ammoAccessor != null && (currentAmmo = ((Integer)this.m_20088_().m_135370_(ammoAccessor)).intValue()) >= 2) {
                    return InteractionResult.m_19078_((boolean)true);
                }
            }
        }
        InteractionResult result = super.m_6096_(player, hand);
        if (!stack.m_41619_() && "superbwarfare:rgo_grenade".equals(itemId) && !this.m_9236_().m_5776_()) {
            EntityDataAccessor<Integer> ammoAccessor = MavicDroneWithDropEntity.getAmmoAccessor();
            EntityDataAccessor<Integer> maxAmmoAccessor = MavicDroneWithDropEntity.getMaxAmmoAccessor();
            if (ammoAccessor != null && maxAmmoAccessor != null) {
                int currentAmmo = (Integer)this.m_20088_().m_135370_(ammoAccessor);
                int maxAmmo = (Integer)this.m_20088_().m_135370_(maxAmmoAccessor);
                if (currentAmmo > 2) {
                    int excess = currentAmmo - 2;
                    this.m_20088_().m_135381_(ammoAccessor, (Object)2);
                    for (int i = 0; i < excess; ++i) {
                        if (player.m_7500_()) continue;
                        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack.m_255036_(1));
                    }
                }
                if (maxAmmo != 2) {
                    this.m_20088_().m_135381_(maxAmmoAccessor, (Object)2);
                }
            }
        }
        return result;
    }

    @Override
    public void m_6075_() {
        super.m_6075_();
        if (!this.m_9236_().m_5776_()) {
            EntityDataAccessor<Integer> ammoAccessor = MavicDroneWithDropEntity.getAmmoAccessor();
            EntityDataAccessor<Integer> maxAmmoAccessor = MavicDroneWithDropEntity.getMaxAmmoAccessor();
            if (ammoAccessor != null && maxAmmoAccessor != null) {
                try {
                    String itemId;
                    Field currentItemField = DroneEntity.class.getDeclaredField("currentItem");
                    currentItemField.setAccessible(true);
                    ItemStack currentItem = (ItemStack)currentItemField.get((Object)this);
                    if (currentItem != null && !currentItem.m_41619_() && "superbwarfare:rgo_grenade".equals(itemId = this.getItemId(currentItem))) {
                        int currentAmmo = (Integer)this.m_20088_().m_135370_(ammoAccessor);
                        int maxAmmo = (Integer)this.m_20088_().m_135370_(maxAmmoAccessor);
                        if (currentAmmo > 2) {
                            this.m_20088_().m_135381_(ammoAccessor, (Object)2);
                        }
                        if (maxAmmo != 2) {
                            this.m_20088_().m_135381_(maxAmmoAccessor, (Object)2);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

