/*
 * Decompiled with CFR 0.152.
 */
package ru.liko.wrbdrones.entity;

import com.atsuishio.superbwarfare.entity.vehicle.DroneEntity;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.item.Monitor;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.mojang.authlib.GameProfile;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.liko.wrbdrones.registry.ModEntityTypes;
import ru.liko.wrbdrones.registry.ModSounds;

public abstract class AddonDroneEntity
extends DroneEntity {
    private static final GameProfile WRB_FAKE_PROFILE = new GameProfile(UUID.nameUUIDFromBytes("WRBDrones-DroneLoader".getBytes()), "[WRB_Drone]");
    private static final EntityDataAccessor<Float> OPERATOR_POS_X = SynchedEntityData.m_135353_(AddonDroneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> OPERATOR_POS_Y = SynchedEntityData.m_135353_(AddonDroneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> OPERATOR_POS_Z = SynchedEntityData.m_135353_(AddonDroneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> OPERATOR_POS_VALID = SynchedEntityData.m_135353_(AddonDroneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    @Nullable
    private ControlSession controlSession;
    @Nullable
    private Vec3 operatorPosition;
    private static volatile boolean dataAccessorsInitialized = false;
    private static Field DISPLAY_ENTITY_FIELD = null;
    private static Field DISPLAY_ENTITY_TAG_FIELD = null;
    private static Field DISPLAY_DATA_FIELD = null;
    private static Field MAX_AMMO_FIELD = null;
    private static Field AMMO_FIELD = null;

    public SoundEvent getEngineSound() {
        return (SoundEvent)ModSounds.FPV_DRONE_ENGINE.get();
    }

    public float getEngineSoundVolume() {
        float base = super.getEngineSoundVolume();
        return ClientAudio.adjustExteriorVolume(this, base);
    }

    protected AddonDroneEntity(EntityType<? extends DroneEntity> type, Level level) {
        super(type, level);
        this.f_19804_.m_135372_(OPERATOR_POS_X, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(OPERATOR_POS_Y, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(OPERATOR_POS_Z, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(OPERATOR_POS_VALID, (Object)false);
    }

    public float getMaxHealth() {
        return 2.5f;
    }

    public abstract ResourceLocation getModelResource();

    public abstract ResourceLocation getTextureResource();

    public ResourceLocation getAnimationResource() {
        return ModEntityTypes.DEFAULT_ANIMATION;
    }

    public void applySpawnLoadout() {
    }

    protected Set<String> getAllowedAttachments() {
        return null;
    }

    protected boolean canAcceptAttachment(ItemStack stack) {
        Set<String> allowed = this.getAllowedAttachments();
        if (allowed == null) {
            return true;
        }
        String itemId = this.getItemId(stack);
        return allowed.contains(itemId);
    }

    protected String getItemId(ItemStack stack) {
        ResourceLocation key = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        if (key == null) {
            return "";
        }
        return key.toString();
    }

    @NotNull
    public InteractionResult m_6096_(Player player, @NotNull InteractionHand hand) {
        int transferred;
        int needed;
        Optional energyCap;
        ItemStack stack = player.m_21205_();
        if (!stack.m_41619_() && this.hasEnergyStorage() && (energyCap = stack.getCapability(ForgeCapabilities.ENERGY).resolve()).isPresent() && (needed = Math.max(0, this.getMaxEnergy() - this.getEnergy())) > 0 && (transferred = ((IEnergyStorage)energyCap.get()).extractEnergy(needed, false)) > 0) {
            if (!this.m_9236_().m_5776_()) {
                this.setEnergy(this.getEnergy() + transferred);
                player.m_5661_((Component)Component.m_237113_((String)("+" + transferred + " FE")), true);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        String itemId = this.getItemId(stack);
        boolean isMonitor = "superbwarfare:monitor".equals(itemId);
        if (isMonitor) {
            if (!player.m_6047_()) {
                InteractionResult result = super.m_6096_(player, hand);
                if (result.m_19077_() && !this.m_9236_().m_5776_() && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    if (((Boolean)this.f_19804_.m_135370_(DroneEntity.LINKED)).booleanValue() && ((String)this.f_19804_.m_135370_(DroneEntity.CONTROLLER)).equals(serverPlayer.m_20149_())) {
                        this.beginRemoteControl(serverPlayer);
                    }
                }
                return result;
            }
            if (!this.m_9236_().m_5776_() && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                String controllerId = (String)this.f_19804_.m_135370_(DroneEntity.CONTROLLER);
                if (controllerId != null && controllerId.equals(serverPlayer.m_20149_())) {
                    this.endRemoteControl(serverPlayer);
                }
            }
            return super.m_6096_(player, hand);
        }
        if (player.m_6047_() && stack.m_41619_()) {
            return this.handleDisassembly(player);
        }
        if (!stack.m_41619_() && !player.m_6047_() && itemId.startsWith("superbwarfare:") && !this.canAcceptAttachment(stack)) {
            player.m_5661_((Component)Component.m_237115_((String)"tips.wrbdrones.drone.attachment_not_allowed").m_130940_(ChatFormatting.RED), true);
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        return super.m_6096_(player, hand);
    }

    private InteractionResult handleDisassembly(Player player) {
        ItemStack droneItem;
        if (this.m_9236_().m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            String controllerId = (String)this.f_19804_.m_135370_(DroneEntity.CONTROLLER);
            if (controllerId != null && controllerId.equals(serverPlayer.m_20149_())) {
                this.endRemoteControl(serverPlayer);
            }
        }
        if ((droneItem = this.getDroneItem()).m_41619_()) {
            return super.m_6096_(player, InteractionHand.MAIN_HAND);
        }
        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)droneItem);
        try {
            player.m_150109_().f_35974_.stream().filter(stack -> stack.m_41720_() == ModItems.MONITOR.get()).forEach(itemStack -> {
                if (itemStack.m_41784_().m_128461_("LinkedDrone").equals(this.m_20149_())) {
                    Monitor.disLink((ItemStack)itemStack, (Player)player);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_146870_();
        return InteractionResult.SUCCESS;
    }

    private ItemStack getDroneItem() {
        EntityType entityType = this.m_6095_();
        ResourceLocation key = ForgeRegistries.ENTITY_TYPES.getKey((Object)entityType);
        if (key == null) {
            return ItemStack.f_41583_;
        }
        String entityId = key.toString();
        if (entityId.equals("wrbdrones:mavic_drone_with_drop")) {
            return new ItemStack((ItemLike)ru.liko.wrbdrones.registry.ModItems.MAVIC_DRONE_WITH_DROP.get());
        }
        if (entityId.equals("wrbdrones:mavic_drone_no_drop")) {
            return new ItemStack((ItemLike)ru.liko.wrbdrones.registry.ModItems.MAVIC_DRONE_NO_DROP.get());
        }
        if (entityId.equals("wrbdrones:fpv_drone")) {
            return new ItemStack((ItemLike)ru.liko.wrbdrones.registry.ModItems.FPV_DRONE.get());
        }
        return ItemStack.f_41583_;
    }

    public void quickLoadAttachment(ItemStack stack) {
        Level level;
        if (stack.m_41619_() || !((level = this.m_9236_()) instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        FakePlayer fakePlayer = FakePlayerFactory.get((ServerLevel)serverLevel, (GameProfile)WRB_FAKE_PROFILE);
        ItemStack previous = fakePlayer.m_21205_();
        fakePlayer.m_21008_(InteractionHand.MAIN_HAND, stack.m_41777_());
        this.m_6096_((Player)fakePlayer, InteractionHand.MAIN_HAND);
        fakePlayer.m_21008_(InteractionHand.MAIN_HAND, previous);
    }

    private static synchronized void initDataAccessorFields() {
        if (dataAccessorsInitialized) {
            return;
        }
        try {
            DISPLAY_ENTITY_FIELD = DroneEntity.class.getDeclaredField("DISPLAY_ENTITY");
            DISPLAY_ENTITY_TAG_FIELD = DroneEntity.class.getDeclaredField("DISPLAY_ENTITY_TAG");
            DISPLAY_DATA_FIELD = DroneEntity.class.getDeclaredField("DISPLAY_DATA");
            MAX_AMMO_FIELD = DroneEntity.class.getDeclaredField("MAX_AMMO");
            Class<Object> vehicleEntityClass = DroneEntity.class.getSuperclass();
            if (vehicleEntityClass != null) {
                try {
                    AMMO_FIELD = vehicleEntityClass.getDeclaredField("AMMO");
                }
                catch (NoSuchFieldException e) {
                    try {
                        vehicleEntityClass = Class.forName("com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity");
                        AMMO_FIELD = vehicleEntityClass.getDeclaredField("AMMO");
                    }
                    catch (Exception e2) {
                        Field[] fields;
                        for (Field field : fields = vehicleEntityClass.getDeclaredFields()) {
                            if (!field.getName().equals("AMMO") && (!field.getType().getName().contains("EntityDataAccessor") || !field.getName().toUpperCase().contains("AMMO"))) continue;
                            AMMO_FIELD = field;
                            break;
                        }
                    }
                }
            }
            if (AMMO_FIELD == null) {
                throw new NoSuchFieldException("AMMO field not found in VehicleEntity or its subclasses");
            }
            DISPLAY_ENTITY_FIELD.setAccessible(true);
            DISPLAY_ENTITY_TAG_FIELD.setAccessible(true);
            DISPLAY_DATA_FIELD.setAccessible(true);
            MAX_AMMO_FIELD.setAccessible(true);
            AMMO_FIELD.setAccessible(true);
            dataAccessorsInitialized = true;
        }
        catch (Exception e) {
            dataAccessorsInitialized = true;
        }
    }

    public static EntityDataAccessor<String> getDisplayEntityAccessor() {
        AddonDroneEntity.initDataAccessorFields();
        if (DISPLAY_ENTITY_FIELD == null) {
            return null;
        }
        try {
            return (EntityDataAccessor)DISPLAY_ENTITY_FIELD.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static EntityDataAccessor<CompoundTag> getDisplayEntityTagAccessor() {
        AddonDroneEntity.initDataAccessorFields();
        if (DISPLAY_ENTITY_TAG_FIELD == null) {
            return null;
        }
        try {
            return (EntityDataAccessor)DISPLAY_ENTITY_TAG_FIELD.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static EntityDataAccessor<List<Float>> getDisplayDataAccessor() {
        AddonDroneEntity.initDataAccessorFields();
        if (DISPLAY_DATA_FIELD == null) {
            return null;
        }
        try {
            return (EntityDataAccessor)DISPLAY_DATA_FIELD.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static EntityDataAccessor<Integer> getMaxAmmoAccessor() {
        AddonDroneEntity.initDataAccessorFields();
        if (MAX_AMMO_FIELD == null) {
            return null;
        }
        try {
            return (EntityDataAccessor)MAX_AMMO_FIELD.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static EntityDataAccessor<Integer> getAmmoAccessor() {
        AddonDroneEntity.initDataAccessorFields();
        if (AMMO_FIELD == null) {
            EntityDataAccessor accessor;
            Field ammoField;
            Class<Object> vehicleEntityClass2;
            try {
                vehicleEntityClass2 = DroneEntity.class.getSuperclass();
                if (vehicleEntityClass2 != null) {
                    ammoField = vehicleEntityClass2.getDeclaredField("AMMO");
                    ammoField.setAccessible(true);
                    accessor = (EntityDataAccessor)ammoField.get(null);
                    if (accessor != null) {
                        return accessor;
                    }
                }
            }
            catch (Exception vehicleEntityClass2) {
                // empty catch block
            }
            try {
                vehicleEntityClass2 = Class.forName("com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity");
                ammoField = vehicleEntityClass2.getDeclaredField("AMMO");
                ammoField.setAccessible(true);
                accessor = (EntityDataAccessor)ammoField.get(null);
                if (accessor != null) {
                    return accessor;
                }
            }
            catch (Exception vehicleEntityClass3) {
                // empty catch block
            }
            return null;
        }
        try {
            return (EntityDataAccessor)AMMO_FIELD.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public Vec3 getOperatorPosition() {
        if (!this.m_9236_().m_5776_()) {
            if (this.controlSession != null) {
                return this.controlSession.originPos;
            }
            return this.operatorPosition;
        }
        if (!((Boolean)this.f_19804_.m_135370_(OPERATOR_POS_VALID)).booleanValue()) {
            return null;
        }
        return new Vec3((double)((Float)this.f_19804_.m_135370_(OPERATOR_POS_X)).floatValue(), (double)((Float)this.f_19804_.m_135370_(OPERATOR_POS_Y)).floatValue(), (double)((Float)this.f_19804_.m_135370_(OPERATOR_POS_Z)).floatValue());
    }

    private void updateOperatorPosition() {
        Vec3 pos = null;
        if (this.controlSession != null) {
            pos = this.controlSession.originPos;
        } else if (this.operatorPosition != null) {
            pos = this.operatorPosition;
        }
        if (pos != null) {
            this.operatorPosition = pos;
            this.f_19804_.m_135381_(OPERATOR_POS_X, (Object)Float.valueOf((float)pos.f_82479_));
            this.f_19804_.m_135381_(OPERATOR_POS_Y, (Object)Float.valueOf((float)pos.f_82480_));
            this.f_19804_.m_135381_(OPERATOR_POS_Z, (Object)Float.valueOf((float)pos.f_82481_));
            this.f_19804_.m_135381_(OPERATOR_POS_VALID, (Object)true);
        } else {
            this.operatorPosition = null;
            this.f_19804_.m_135381_(OPERATOR_POS_X, (Object)Float.valueOf(0.0f));
            this.f_19804_.m_135381_(OPERATOR_POS_Y, (Object)Float.valueOf(0.0f));
            this.f_19804_.m_135381_(OPERATOR_POS_Z, (Object)Float.valueOf(0.0f));
            this.f_19804_.m_135381_(OPERATOR_POS_VALID, (Object)false);
        }
    }

    public boolean beginRemoteControl(ServerPlayer player) {
        String controllerId = (String)this.f_19804_.m_135370_(DroneEntity.CONTROLLER);
        if (!(controllerId == null || controllerId.equals("undefined") || controllerId.isEmpty() || controllerId.equals(player.m_20149_()))) {
            return false;
        }
        if (this.controlSession == null) {
            this.controlSession = new ControlSession((ResourceKey<Level>)player.m_9236_().m_46472_(), player.m_20182_(), player.m_146908_(), player.m_146909_(), player.f_8941_.m_9290_());
            this.updateOperatorPosition();
        }
        return true;
    }

    public void endRemoteControl(ServerPlayer player) {
        if (this.controlSession == null) {
            return;
        }
        String controllerId = (String)this.f_19804_.m_135370_(DroneEntity.CONTROLLER);
        if (!(controllerId == null || controllerId.equals("undefined") || controllerId.isEmpty() || controllerId.equals(player.m_20149_()))) {
            return;
        }
        this.controlSession = null;
        this.operatorPosition = null;
        this.updateOperatorPosition();
    }

    public void handleSignalLoss(@Nullable ServerPlayer source) {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (this.m_213877_()) {
            return;
        }
        if (source != null) {
            this.endRemoteControl(source);
        } else {
            Player controller;
            String controllerId = (String)this.f_19804_.m_135370_(DroneEntity.CONTROLLER);
            if (controllerId != null && !controllerId.equals("undefined") && !controllerId.isEmpty() && (controller = EntityFindUtil.findPlayer((Level)serverLevel, (String)controllerId)) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)controller;
                this.endRemoteControl(serverPlayer);
            }
        }
        this.unlinkAllLinkedMonitors(serverLevel);
        this.createCustomExplosion().radius(3.5f).damage(8.0f).explode();
        this.m_146870_();
    }

    public void m_6075_() {
        Level level;
        super.m_6075_();
        if (!this.m_9236_().m_5776_() && (level = this.m_9236_()) instanceof ServerLevel) {
            Player controller;
            ServerLevel serverLevel = (ServerLevel)level;
            String controllerId = (String)this.f_19804_.m_135370_(DroneEntity.CONTROLLER);
            if (controllerId != null && !controllerId.equals("undefined") && !controllerId.isEmpty() && (controller = EntityFindUtil.findPlayer((Level)serverLevel, (String)controllerId)) instanceof ServerPlayer) {
                CompoundTag tag;
                ServerPlayer serverPlayer = (ServerPlayer)controller;
                boolean isUsingMonitor = false;
                String droneId = this.m_20149_();
                ItemStack mainHand = serverPlayer.m_21205_();
                if (mainHand.m_150930_((Item)ModItems.MONITOR.get()) && (tag = mainHand.m_41784_()).m_128471_("Linked") && tag.m_128471_("Using") && tag.m_128461_("LinkedDrone").equals(droneId)) {
                    isUsingMonitor = true;
                }
                if (isUsingMonitor && this.controlSession == null) {
                    this.beginRemoteControl(serverPlayer);
                }
                if (!isUsingMonitor && this.controlSession != null) {
                    this.endRemoteControl(serverPlayer);
                }
            }
            this.updateOperatorPosition();
        }
    }

    public void m_142687_(@NotNull // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull @NotNull Entity.RemovalReason reason) {
        Level level;
        if (!this.m_9236_().m_5776_() && (level = this.m_9236_()) instanceof ServerLevel) {
            Player controller;
            ServerLevel serverLevel = (ServerLevel)level;
            String controllerId = (String)this.f_19804_.m_135370_(DroneEntity.CONTROLLER);
            if (controllerId != null && !controllerId.equals("undefined") && !controllerId.isEmpty() && (controller = EntityFindUtil.findPlayer((Level)serverLevel, (String)controllerId)) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)controller;
                if (this.controlSession != null) {
                    this.endRemoteControl(serverPlayer);
                }
            }
        }
        super.m_142687_(reason);
    }

    private void unlinkAllLinkedMonitors(ServerLevel serverLevel) {
        Item monitorItem = (Item)ModItems.MONITOR.get();
        if (monitorItem == null) {
            return;
        }
        String droneId = this.m_20149_();
        for (ServerPlayer player : serverLevel.m_6907_()) {
            this.unlinkMonitorsFromPlayer(player, droneId, monitorItem);
        }
    }

    private void unlinkMonitorsFromPlayer(ServerPlayer player, String droneId, Item monitorItem) {
        this.unlinkMonitorCollection((List<ItemStack>)player.m_150109_().f_35974_, player, droneId, monitorItem);
        this.unlinkMonitorCollection((List<ItemStack>)player.m_150109_().f_35976_, player, droneId, monitorItem);
    }

    private void unlinkMonitorCollection(List<ItemStack> stacks, ServerPlayer player, String droneId, Item monitorItem) {
        for (ItemStack stack : stacks) {
            CompoundTag tag;
            if (stack.m_41619_() || !stack.m_150930_(monitorItem) || (tag = stack.m_41783_()) == null || !droneId.equals(tag.m_128461_("LinkedDrone"))) continue;
            Monitor.disLink((ItemStack)stack, (Player)player);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static final class ClientAudio {
        private static final Map<AddonDroneEntity, InteriorSound> INTERIOR_SOUNDS = new WeakHashMap<AddonDroneEntity, InteriorSound>();

        private ClientAudio() {
        }

        private static float adjustExteriorVolume(AddonDroneEntity drone, float baseVolume) {
            double maxDistance;
            Minecraft mc = Minecraft.m_91087_();
            LocalPlayer listener = mc.f_91074_;
            if (listener == null) {
                return baseVolume;
            }
            if (ClientAudio.isControlling(listener, drone)) {
                return 0.0f;
            }
            double distance = Math.sqrt(drone.m_20280_((Entity)listener));
            if (distance >= (maxDistance = 48.0)) {
                return 0.0f;
            }
            double factor = 1.0 - distance / maxDistance;
            return (float)((double)baseVolume * factor);
        }

        private static void onClientTick(TickEvent.ClientTickEvent event) {
            InteriorSound sound;
            if (event.phase != TickEvent.Phase.END) {
                return;
            }
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_ == null) {
                INTERIOR_SOUNDS.clear();
                return;
            }
            AddonDroneEntity controlled = ClientAudio.getControlledDrone(mc);
            if (controlled != null && controlled.m_213877_()) {
                controlled = null;
            }
            if (controlled != null && ((sound = INTERIOR_SOUNDS.get((Object)controlled)) == null || sound.isTerminated())) {
                sound = new InteriorSound(controlled);
                INTERIOR_SOUNDS.put(controlled, sound);
                mc.m_91106_().m_120367_((SoundInstance)sound);
            }
            Iterator<Map.Entry<AddonDroneEntity, InteriorSound>> iterator = INTERIOR_SOUNDS.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<AddonDroneEntity, InteriorSound> entry = iterator.next();
                AddonDroneEntity drone = entry.getKey();
                InteriorSound sound2 = entry.getValue();
                boolean keep = controlled != null && drone == controlled && !drone.m_213877_();
                if (keep) continue;
                sound2.markForStop();
                iterator.remove();
            }
        }

        private static AddonDroneEntity getControlledDrone(Minecraft mc) {
            AddonDroneEntity addon;
            LocalPlayer player = mc.f_91074_;
            if (player == null) {
                return null;
            }
            ItemStack stack = player.m_21205_();
            if (!stack.m_150930_((Item)ModItems.MONITOR.get())) {
                return null;
            }
            CompoundTag tag = stack.m_41784_();
            if (!tag.m_128471_("Linked")) {
                return null;
            }
            if (!tag.m_128471_("Using")) {
                return null;
            }
            String linkedId = tag.m_128461_("LinkedDrone");
            DroneEntity drone = EntityFindUtil.findDrone((Level)player.m_9236_(), (String)linkedId);
            return drone instanceof AddonDroneEntity ? (addon = (AddonDroneEntity)drone) : null;
        }

        private static boolean isControlling(LocalPlayer listener, AddonDroneEntity drone) {
            if (listener == null) {
                return false;
            }
            ItemStack stack = listener.m_21205_();
            if (!stack.m_150930_((Item)ModItems.MONITOR.get())) {
                return false;
            }
            CompoundTag tag = stack.m_41784_();
            if (!tag.m_128471_("Linked")) {
                return false;
            }
            if (!tag.m_128471_("Using")) {
                return false;
            }
            return drone.m_20149_().equals(tag.m_128461_("LinkedDrone"));
        }

        static {
            MinecraftForge.EVENT_BUS.addListener(ClientAudio::onClientTick);
        }

        private static final class InteriorSound
        extends AbstractTickableSoundInstance {
            private final AddonDroneEntity drone;
            private boolean shouldStop;
            private boolean terminated;

            private InteriorSound(AddonDroneEntity drone) {
                super((SoundEvent)ModSounds.FPV_DRONE_ENGINE_INT.get(), SoundSource.PLAYERS, drone.m_9236_().f_46441_);
                this.drone = drone;
                this.f_119578_ = true;
                this.f_119579_ = 0;
                this.f_119582_ = true;
                this.f_119573_ = 0.2f;
                this.f_119574_ = 1.0f;
            }

            public void m_7788_() {
                LocalPlayer listener = Minecraft.m_91087_().f_91074_;
                if (this.shouldStop || this.drone.m_213877_() || !ClientAudio.isControlling(listener, this.drone)) {
                    this.terminated = true;
                    this.f_119573_ = 0.0f;
                    return;
                }
                float power = Math.abs(((Float)this.drone.f_19804_.m_135370_(DroneEntity.POWER)).floatValue());
                this.f_119573_ = Mth.m_14036_((float)(0.2f + power * 1.2f), (float)0.2f, (float)1.0f);
                this.f_119574_ = Mth.m_14036_((float)(0.8f + power * 0.6f), (float)0.8f, (float)1.4f);
            }

            public boolean m_7801_() {
                return this.terminated || this.shouldStop || this.drone.m_213877_();
            }

            void markForStop() {
                this.shouldStop = true;
            }

            boolean isTerminated() {
                return this.terminated;
            }
        }
    }

    private static final class ControlSession {
        final ResourceKey<Level> dimension;
        final Vec3 originPos;
        final float originYaw;
        final float originPitch;
        final GameType gameMode;

        ControlSession(ResourceKey<Level> dimension, Vec3 originPos, float originYaw, float originPitch, GameType gameMode) {
            this.dimension = dimension;
            this.originPos = originPos;
            this.originYaw = originYaw;
            this.originPitch = originPitch;
            this.gameMode = gameMode;
        }
    }
}

