/*
 * Decompiled with CFR 0.152.
 */
package ru.liko.wrbdrones.client.renderer;

import com.atsuishio.superbwarfare.entity.vehicle.DroneEntity;
import com.atsuishio.superbwarfare.init.ModItems;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import ru.liko.wrbdrones.client.model.AddonDroneModel;
import ru.liko.wrbdrones.entity.AddonDroneEntity;
import ru.liko.wrbdrones.entity.FpvDroneEntity;
import ru.liko.wrbdrones.entity.MavicDroneWithDropEntity;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class AddonDroneRenderer<T extends AddonDroneEntity>
extends GeoEntityRenderer<T> {
    private static Field CURRENT_ITEM_FIELD = null;
    private static boolean currentItemFieldInitialized = false;
    private static Field DISPLAY_ENTITY_FIELD = null;
    private static boolean displayEntityFieldInitialized = false;

    public AddonDroneRenderer(EntityRendererProvider.Context context) {
        super(context, new AddonDroneModel());
        this.f_114477_ = 0.25f;
    }

    public RenderType getRenderType(T animatable, ResourceLocation texture, MultiBufferSource bufferSource, float partialTick) {
        return RenderType.m_110473_((ResourceLocation)this.m_5478_((Entity)animatable));
    }

    public void render(T entity, float entityYaw, float partialTicks, PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-entity.getYaw(partialTicks)));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(entity.getBodyPitch(partialTicks)));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(entity.getRoll(partialTicks)));
        super.m_7392_(entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
        poseStack.m_85849_();
    }

    public void renderRecursively(PoseStack poseStack, T animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        String name = bone.getName();
        if (animatable instanceof FpvDroneEntity) {
            if (name.startsWith("snarad_")) {
                String currentAmmoType = this.getCurrentAmmoType(animatable);
                boolean shouldShow = false;
                if ("snarad_mortar".equals(name)) {
                    shouldShow = "superbwarfare:mortar_shell".equals(currentAmmoType);
                } else if ("snarad_rpg-7tbg".equals(name)) {
                    shouldShow = "superbwarfare:rpg_rocket_tbg".equals(currentAmmoType);
                } else if ("snarad_rpg-7vm".equals(name)) {
                    shouldShow = "superbwarfare:rpg_rocket_standard".equals(currentAmmoType);
                }
                boolean hasAmmo = this.hasAmmo(animatable);
                bone.setHidden(!hasAmmo || !shouldShow);
            }
        } else if ("snarad".equals(name)) {
            boolean hasAmmo = this.hasAmmo(animatable);
            bone.setHidden(!hasAmmo);
        }
        if ("granade1".equals(name) || "granade2".equals(name)) {
            if (animatable instanceof MavicDroneWithDropEntity) {
                boolean grenadeAttached = this.isGrenadeAttached(animatable);
                if (grenadeAttached) {
                    int ammo = this.getAmmoCount(animatable);
                    if ("granade1".equals(name)) {
                        bone.setHidden(ammo < 1);
                    } else if ("granade2".equals(name)) {
                        bone.setHidden(ammo < 2);
                    }
                } else {
                    bone.setHidden(true);
                }
            } else {
                bone.setHidden(true);
            }
        }
        if (!animatable.m_20096_() && AddonDroneRenderer.isRotorBone(name)) {
            bone.setRotY((float)(System.currentTimeMillis() % 36000000L) / 12.0f);
        }
        if ("camera".equals(name)) {
            float cameraPitch = this.getControllerPitch(animatable, partialTick);
            float clampedPitch = Mth.m_14036_((float)cameraPitch, (float)-90.0f, (float)90.0f);
            bone.setRotX((float)Math.toRadians(-clampedPitch));
        }
        super.renderRecursively(poseStack, animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    private int getAmmoCount(T entity) {
        try {
            EntityDataAccessor<Integer> ammoAccessor = AddonDroneEntity.getAmmoAccessor();
            if (ammoAccessor != null) {
                return (Integer)entity.m_20088_().m_135370_(ammoAccessor);
            }
            try {
                Class vehicleEntityClass = DroneEntity.class.getSuperclass();
                if (vehicleEntityClass != null) {
                    Field ammoField = vehicleEntityClass.getDeclaredField("AMMO");
                    ammoField.setAccessible(true);
                    EntityDataAccessor ammoAccessorDirect = (EntityDataAccessor)ammoField.get(null);
                    if (ammoAccessorDirect != null) {
                        return (Integer)entity.m_20088_().m_135370_(ammoAccessorDirect);
                    }
                }
            }
            catch (Exception e2) {
                try {
                    Class<?> vehicleEntityClass = Class.forName("com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity");
                    Field ammoField = vehicleEntityClass.getDeclaredField("AMMO");
                    ammoField.setAccessible(true);
                    EntityDataAccessor ammoAccessorDirect = (EntityDataAccessor)ammoField.get(null);
                    if (ammoAccessorDirect != null) {
                        return (Integer)entity.m_20088_().m_135370_(ammoAccessorDirect);
                    }
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    private boolean isGrenadeAttached(T entity) {
        try {
            EntityDataAccessor<String> displayEntityAccessor = AddonDroneEntity.getDisplayEntityAccessor();
            if (displayEntityAccessor != null) {
                String displayEntity = (String)entity.m_20088_().m_135370_(displayEntityAccessor);
                if (displayEntity != null && !displayEntity.isEmpty() && (displayEntity.contains("rgo_grenade") || displayEntity.equals("superbwarfare:rgo_grenade"))) {
                    return true;
                }
            } else if (!entity.m_9236_().m_5776_()) {
                ResourceLocation key;
                T droneEntity;
                ItemStack currentItem;
                AddonDroneRenderer.initCurrentItemField();
                if (CURRENT_ITEM_FIELD != null && (currentItem = (ItemStack)CURRENT_ITEM_FIELD.get(droneEntity = entity)) != null && !currentItem.m_41619_() && (key = ForgeRegistries.ITEMS.getKey((Object)currentItem.m_41720_())) != null && "superbwarfare:rgo_grenade".equals(key.toString())) {
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static synchronized void initCurrentItemField() {
        if (currentItemFieldInitialized) {
            return;
        }
        try {
            CURRENT_ITEM_FIELD = DroneEntity.class.getDeclaredField("currentItem");
            CURRENT_ITEM_FIELD.setAccessible(true);
            currentItemFieldInitialized = true;
        }
        catch (Exception e) {
            currentItemFieldInitialized = true;
        }
    }

    private static synchronized void initDisplayEntityField() {
        if (displayEntityFieldInitialized) {
            return;
        }
        try {
            DISPLAY_ENTITY_FIELD = DroneEntity.class.getDeclaredField("DISPLAY_ENTITY");
            DISPLAY_ENTITY_FIELD.setAccessible(true);
            displayEntityFieldInitialized = true;
        }
        catch (Exception e) {
            displayEntityFieldInitialized = true;
        }
    }

    private String getCurrentAmmoType(T entity) {
        try {
            String displayEntity;
            EntityDataAccessor<String> displayEntityAccessor;
            AddonDroneRenderer.initCurrentItemField();
            if (CURRENT_ITEM_FIELD != null) {
                try {
                    ResourceLocation key;
                    T droneEntity = entity;
                    ItemStack currentItem = (ItemStack)CURRENT_ITEM_FIELD.get(droneEntity);
                    if (currentItem != null && !currentItem.m_41619_() && (key = ForgeRegistries.ITEMS.getKey((Object)currentItem.m_41720_())) != null) {
                        return key.toString();
                    }
                }
                catch (Exception droneEntity) {
                    // empty catch block
                }
            }
            if ((displayEntityAccessor = AddonDroneEntity.getDisplayEntityAccessor()) != null && (displayEntity = (String)entity.m_20088_().m_135370_(displayEntityAccessor)) != null && !displayEntity.isEmpty() && displayEntity.contains(":") && displayEntity.startsWith("superbwarfare:")) {
                return displayEntity;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    private boolean hasAmmo(T entity) {
        AddonDroneRenderer.initCurrentItemField();
        AddonDroneRenderer.initDisplayEntityField();
        if (DISPLAY_ENTITY_FIELD != null) {
            try {
                EntityDataAccessor displayEntityAccessor = (EntityDataAccessor)DISPLAY_ENTITY_FIELD.get(null);
                SynchedEntityData data = entity.m_20088_();
                String displayEntity = (String)data.m_135370_(displayEntityAccessor);
                if (displayEntity != null && !displayEntity.isEmpty()) {
                    return true;
                }
            }
            catch (Exception displayEntityAccessor) {
                // empty catch block
            }
        }
        if (CURRENT_ITEM_FIELD != null) {
            try {
                T droneEntity = entity;
                ItemStack currentItem = (ItemStack)CURRENT_ITEM_FIELD.get(droneEntity);
                return currentItem != null && !currentItem.m_41619_();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean isRotorBone(String name) {
        return "wingFL".equals(name) || "wingFR".equals(name) || "wingBL".equals(name) || "wingBR".equals(name) || "rotor_fl".equals(name) || "rotor_fr".equals(name) || "rotor_bl".equals(name) || "rotor_br".equals(name) || "rotor_left".equals(name) || "rotor_right".equals(name);
    }

    private float getControllerPitch(T animatable, float partialTick) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return 0.0f;
        }
        ItemStack mainHand = player.m_21205_();
        if (mainHand.m_41720_() == ModItems.MONITOR.get()) {
            String linkedDrone = mainHand.m_41784_().m_128461_("LinkedDrone");
            boolean isUsing = mainHand.m_41784_().m_128471_("Using");
            boolean isLinked = mainHand.m_41784_().m_128471_("Linked");
            if (isUsing && isLinked && linkedDrone.equals(animatable.m_20149_())) {
                return Mth.m_14179_((float)partialTick, (float)player.f_19860_, (float)player.m_146909_());
            }
        }
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (stack.m_41720_() != ModItems.MONITOR.get()) continue;
            String linkedDrone = stack.m_41784_().m_128461_("LinkedDrone");
            boolean isUsing = stack.m_41784_().m_128471_("Using");
            boolean isLinked = stack.m_41784_().m_128471_("Linked");
            if (!isUsing || !isLinked || !linkedDrone.equals(animatable.m_20149_())) continue;
            return Mth.m_14179_((float)partialTick, (float)player.f_19860_, (float)player.m_146909_());
        }
        return 0.0f;
    }
}

