/*
 * Decompiled with CFR 0.152.
 */
package ru.liko.wrbdrones.client.overlay;

import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.entity.vehicle.DroneEntity;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import org.joml.Matrix4f;
import ru.liko.wrbdrones.Wrbdrones;
import ru.liko.wrbdrones.config.ServerConfig;
import ru.liko.wrbdrones.entity.AddonDroneEntity;
import ru.liko.wrbdrones.entity.MavicDroneNoDropEntity;
import ru.liko.wrbdrones.entity.MavicDroneWithDropEntity;
import ru.liko.wrbdrones.entity.RebEntity;
import ru.liko.wrbdrones.network.ModNetworking;

@OnlyIn(value=Dist.CLIENT)
public class MavicHudOverlay
implements IGuiOverlay {
    public static final String ID = "wrbdrones_mavic_hud";
    private static final ResourceLocation TV_FRAME = Wrbdrones.id("textures/overlay/tv_frame.png");
    private static final ResourceLocation CROSSHAIR = Wrbdrones.id("textures/overlay/third_camera.png");
    private static final ResourceLocation NOISE_TEXTURE = Wrbdrones.id("textures/overlay/noise.png");
    private static final int NOISE_TEXTURE_SIZE = 256;
    private static final int TEXT_COLOR = -1;
    private static final int SIGNAL_BAR_COLOR = -16711936;
    private static final int SIGNAL_BAR_EMPTY_COLOR = 0x66FFFFFF;
    private static final int COMPASS_COLOR = -1;
    private static final Set<UUID> SIGNAL_LOSS_REPORTED = new HashSet<UUID>();

    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        Vec3 avatarPos;
        boolean isMavic;
        boolean firstPerson;
        Minecraft mc = gui.getMinecraft();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        boolean bl = firstPerson = Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.FIRST_PERSON || Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.THIRD_PERSON_BACK;
        if (!firstPerson) {
            return;
        }
        ItemStack stack = player.m_21205_();
        if (!(stack.m_150930_((Item)ModItems.MONITOR.get()) && stack.m_41784_().m_128471_("Using") && stack.m_41784_().m_128471_("Linked"))) {
            return;
        }
        DroneEntity drone = EntityFindUtil.findDrone((Level)player.m_9236_(), (String)stack.m_41784_().m_128461_("LinkedDrone"));
        if (drone == null) {
            return;
        }
        boolean bl2 = isMavic = drone instanceof MavicDroneWithDropEntity || drone instanceof MavicDroneNoDropEntity;
        if (!isMavic) {
            return;
        }
        AddonDroneEntity addonDrone = null;
        if (drone instanceof AddonDroneEntity) {
            addonDrone = (AddonDroneEntity)drone;
        }
        Vec3 operatorPos = player.m_20182_();
        if (addonDrone != null && (avatarPos = addonDrone.getOperatorPosition()) != null) {
            operatorPos = avatarPos;
        }
        Vec3 dronePos = drone.m_20182_();
        double distance = operatorPos.m_82554_(dronePos);
        double altitude = drone.m_20186_();
        double speed = drone.m_20184_().m_82553_() * 20.0;
        float yaw = Mth.m_14179_((float)partialTick, (float)drone.f_19859_, (float)drone.m_146908_());
        double rebJammingFactor = addonDrone != null ? this.getRebJammingFactor(addonDrone) : 0.0;
        double maxDistance = (Double)ServerConfig.MAVIC_MAX_DISTANCE.get();
        double signalLossDistance = (Double)ServerConfig.MAVIC_SIGNAL_LOSS_DISTANCE.get();
        double signalPercent = 1.0;
        if (distance > signalLossDistance && maxDistance > signalLossDistance) {
            double norm = Math.min(1.0, (distance - signalLossDistance) / (maxDistance - signalLossDistance));
            signalPercent = 1.0 - norm;
            signalPercent *= signalPercent;
        }
        int signalLevel = this.calculateSignalLevel(signalPercent *= 1.0 - rebJammingFactor);
        if (addonDrone != null) {
            this.handleMavicSignalLoss(addonDrone, signalLevel);
        }
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderTvFrameAndCrosshair(guiGraphics, screenWidth, screenHeight);
        RenderSystem.setShader(GameRenderer::m_172811_);
        this.renderSignalBars(guiGraphics, screenWidth, screenHeight, signalLevel);
        this.renderCompass(guiGraphics, screenWidth, screenHeight, yaw);
        this.renderInfo(guiGraphics, screenWidth, screenHeight, altitude, distance, speed);
        if (signalLevel == 0) {
            this.renderSignalLossWarning(guiGraphics, screenWidth, screenHeight, partialTick);
        }
        RenderSystem.setShader(GameRenderer::m_172817_);
        double rebInterferenceFactor = addonDrone != null ? this.getRebInterferenceFactor(addonDrone) : 0.0;
        this.renderNoise(guiGraphics, screenWidth, screenHeight, distance, partialTick, signalPercent, rebInterferenceFactor);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private int calculateSignalLevel(double signalPercent) {
        if (signalPercent >= 0.8) {
            return 5;
        }
        if (signalPercent >= 0.6) {
            return 4;
        }
        if (signalPercent >= 0.4) {
            return 3;
        }
        if (signalPercent >= 0.2) {
            return 2;
        }
        if (signalPercent > 0.0) {
            return 1;
        }
        return 0;
    }

    private void handleMavicSignalLoss(AddonDroneEntity drone, int signalLevel) {
        UUID droneId = drone.m_20148_();
        if (signalLevel == 0) {
            if (SIGNAL_LOSS_REPORTED.add(droneId)) {
                ModNetworking.reportSignalLost(droneId);
            }
        } else {
            SIGNAL_LOSS_REPORTED.remove(droneId);
        }
    }

    private double getRebJammingFactor(AddonDroneEntity drone) {
        if (drone.m_9236_() == null) {
            return 0.0;
        }
        double rebRadius = (Double)ServerConfig.REB_RADIUS.get();
        double maxFactor = 0.0;
        LevelEntityGetter entities = EntityFindUtil.getEntities((Level)drone.m_9236_());
        for (Entity entity : entities.m_142273_()) {
            double distance;
            RebEntity rebEntity;
            if (!(entity instanceof RebEntity) || (rebEntity = (RebEntity)entity).m_213877_() || !rebEntity.isEnabled() || !((distance = Math.sqrt(drone.m_20280_(rebEntity))) <= rebRadius)) continue;
            double normalizedDistance = distance / rebRadius;
            double factor = 1.0 - normalizedDistance;
            factor *= factor;
            maxFactor = Math.max(maxFactor, factor);
        }
        return Math.min(1.0, maxFactor);
    }

    private double getRebInterferenceFactor(AddonDroneEntity drone) {
        if (drone.m_9236_() == null) {
            return 0.0;
        }
        double rebRadius = (Double)ServerConfig.REB_RADIUS.get();
        double maxFactor = 0.0;
        LevelEntityGetter entities = EntityFindUtil.getEntities((Level)drone.m_9236_());
        for (Entity entity : entities.m_142273_()) {
            double distance;
            RebEntity rebEntity;
            if (!(entity instanceof RebEntity) || (rebEntity = (RebEntity)entity).m_213877_() || !rebEntity.isEnabled() || !((distance = Math.sqrt(drone.m_20280_(rebEntity))) <= rebRadius)) continue;
            double normalizedDistance = distance / rebRadius;
            double factor = 1.0 - normalizedDistance;
            factor *= factor;
            maxFactor = Math.max(maxFactor, factor);
        }
        return Math.min(1.0, maxFactor);
    }

    private void renderNoise(GuiGraphics gfx, int screenWidth, int screenHeight, double distance, float partialTick, double signalPercent, double rebInterferenceFactor) {
        if (!((Boolean)ServerConfig.FPV_ENABLE_NOISE_EFFECT.get()).booleanValue()) {
            return;
        }
        double noise = 0.0;
        boolean isSignalLost = signalPercent <= 0.0;
        double lowSignalFactor = 0.0;
        noise = isSignalLost && rebInterferenceFactor > 0.0 ? 1.0 : rebInterferenceFactor * 0.65;
        if ((noise = Math.min(1.0, noise)) <= 0.0) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        float time = (mc.f_91073_ != null ? (float)mc.f_91073_.m_46467_() + partialTick : 0.0f) * 0.05f;
        float alpha = this.calculateNoiseAlpha(noise, time, isSignalLost, lowSignalFactor);
        this.renderNoiseWithTexture(gfx, screenWidth, screenHeight, alpha, time, isSignalLost, lowSignalFactor);
    }

    private float calculateNoiseAlpha(double intensity, float time, boolean isSignalLost, double lowSignalFactor) {
        if (isSignalLost) {
            float pulse = (float)(0.5 + 0.5 * Math.sin((double)time * 0.5));
            float base = 0.75f;
            return Math.min(1.0f, base + 0.15f * pulse);
        }
        float pulse = (float)(0.5 + 0.5 * Math.sin((double)time * 0.2));
        float base = (float)intensity * 0.4f;
        float lowSignalBoost = (float)(0.25 * lowSignalFactor);
        return Math.min(1.0f, base + (float)intensity * 0.25f * pulse + lowSignalBoost);
    }

    private void renderNoiseWithTexture(GuiGraphics gfx, int screenWidth, int screenHeight, float alpha, float time, boolean isSignalLost, double lowSignalFactor) {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        Minecraft mc = Minecraft.m_91087_();
        int tilesX = screenWidth / 256 + 2;
        int tilesY = screenHeight / 256 + 2;
        int frame = (int)(time * 10.0f);
        int offsetX = (frame * 37 + frame * 13) % 256;
        int offsetY = (frame * 73 + frame * 19) % 256;
        this.blitNoiseLayer(gfx, 0, 0, screenWidth, screenHeight, tilesX, tilesY, offsetX, offsetY);
        if (alpha > 0.25f) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(alpha * 0.4f));
            int frame2 = (int)(time * 8.0f);
            int offsetX2 = (frame2 * 41 + frame2 * 17) % 256;
            int offsetY2 = (frame2 * 67 + frame2 * 23) % 256;
            this.blitNoiseLayer(gfx, 0, 0, screenWidth, screenHeight, tilesX, tilesY, offsetX2, offsetY2);
        }
        if (isSignalLost) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(alpha * 0.5f));
            int frame3 = (int)(time * 12.0f);
            int offsetX3 = (frame3 * 53 + frame3 * 29) % 256;
            int offsetY3 = (frame3 * 79 + frame3 * 31) % 256;
            this.blitNoiseLayer(gfx, 0, 0, screenWidth, screenHeight, tilesX, tilesY, offsetX3, offsetY3);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(alpha * 0.4f));
            int frame4 = (int)(time * 15.0f);
            int offsetX4 = (frame4 * 61 + frame4 * 37) % 256;
            int offsetY4 = (frame4 * 83 + frame4 * 43) % 256;
            this.blitNoiseLayer(gfx, 0, 0, screenWidth, screenHeight, tilesX, tilesY, offsetX4, offsetY4);
            long seedBase = mc.f_91073_ != null ? mc.f_91073_.m_46467_() * 37L : 0L;
            long seed = seedBase ^ (long)(time * 4096.0f);
            RandomSource random = RandomSource.m_216335_((long)seed);
            this.renderSignalLossScramble(gfx, 0, 0, screenWidth, screenHeight, random, 0.8f, true);
        } else if (lowSignalFactor > 0.0) {
            float strength = (float)(0.25 + 0.5 * lowSignalFactor);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)Math.min(1.0f, alpha + strength * 0.15f));
            this.blitNoiseLayer(gfx, 0, 0, screenWidth, screenHeight, tilesX, tilesY, offsetX, offsetY);
            long seedBase = mc.f_91073_ != null ? mc.f_91073_.m_46467_() * 23L : 0L;
            long seed = seedBase ^ (long)(time * 2048.0f);
            RandomSource random = RandomSource.m_216335_((long)seed);
            this.renderSignalLossScramble(gfx, 0, 0, screenWidth, screenHeight, random, strength, false);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void blitNoiseLayer(GuiGraphics gfx, int startX, int startY, int width, int height, int tilesX, int tilesY, int offsetX, int offsetY) {
        for (int x = -1; x < tilesX; ++x) {
            for (int y = -1; y < tilesY; ++y) {
                int px = startX + x * 256 - offsetX;
                int py = startY + y * 256 - offsetY;
                if (px + 256 <= startX || px >= startX + width || py + 256 <= startY || py >= startY + height) continue;
                gfx.m_280163_(NOISE_TEXTURE, px, py, 0.0f, 0.0f, 256, 256, 256, 256);
            }
        }
    }

    private void renderSignalLossScramble(GuiGraphics gfx, int startX, int startY, int width, int height, RandomSource random, float strength, boolean fullLoss) {
        int bandHeight;
        RenderSystem.setShader(GameRenderer::m_172811_);
        for (int y = startY; y < startY + height; y += bandHeight) {
            int maxBand = fullLoss ? 15 : (int)(5.0f + strength * 15.0f);
            bandHeight = Math.min(3 + random.m_188503_(Math.max(4, maxBand)), startY + height - y);
            int intensityBase = fullLoss ? 120 : 70;
            int intensityVariation = fullLoss ? 60 : (int)(90.0f * strength);
            int intensity = intensityBase + random.m_188503_(Math.max(1, intensityVariation));
            if (!fullLoss && random.m_188503_(6) == 0) {
                intensity = 30 + random.m_188503_(45);
            }
            intensity = Math.min(255, (int)((float)intensity * strength));
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder buffer = tesselator.m_85915_();
            Matrix4f matrix = gfx.m_280168_().m_85850_().m_252922_();
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            int color = intensity << 24 | 0xFFFFFF;
            buffer.m_252986_(matrix, (float)startX, (float)y, 0.0f).m_193479_(color).m_5752_();
            buffer.m_252986_(matrix, (float)(startX + width), (float)y, 0.0f).m_193479_(color).m_5752_();
            buffer.m_252986_(matrix, (float)(startX + width), (float)(y + bandHeight), 0.0f).m_193479_(color).m_5752_();
            buffer.m_252986_(matrix, (float)startX, (float)(y + bandHeight), 0.0f).m_193479_(color).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
        }
    }

    private void renderSignalBars(GuiGraphics guiGraphics, int screenWidth, int screenHeight, int signalLevel) {
        int x = 10;
        int y = 10;
        int barWidth = 4;
        int barSpacing = 2;
        int maxBars = 5;
        for (int i = 0; i < maxBars; ++i) {
            int barHeight = 3 + i * 2;
            int barX = x + i * (barWidth + barSpacing);
            int barY = y + (maxBars - i - 1) * 2;
            int color = i < signalLevel ? -16711936 : 0x66FFFFFF;
            guiGraphics.m_280509_(barX, barY, barX + barWidth, barY + barHeight, color);
        }
    }

    private void renderTvFrameAndCrosshair(GuiGraphics guiGraphics, int screenWidth, int screenHeight) {
        guiGraphics.m_280163_(CROSSHAIR, screenWidth / 2 - 16, screenHeight / 2 - 16, 0.0f, 0.0f, 32, 32, 32, 32);
        int addW = screenWidth / screenHeight * 48;
        int addH = screenWidth / screenHeight * 27;
        this.renderTvFrame(guiGraphics, screenWidth, screenHeight, addW, addH);
    }

    private void renderTvFrame(GuiGraphics guiGraphics, int screenWidth, int screenHeight, int addW, int addH) {
        RenderHelper.preciseBlit((GuiGraphics)guiGraphics, (ResourceLocation)TV_FRAME, (float)((float)(-addW) / 2.0f), (float)((float)(-addH) / 2.0f), (float)10.0f, (float)0.0f, (float)0.0f, (float)(screenWidth + addW), (float)(screenHeight + addH), (float)(screenWidth + addW), (float)(screenHeight + addH));
    }

    private void renderCompass(GuiGraphics guiGraphics, int screenWidth, int screenHeight, float yaw) {
        int centerX = screenWidth / 2;
        int y = screenHeight - 100;
        int compassRadius = 50;
        float normalizedYaw = (yaw % 360.0f + 360.0f) % 360.0f;
        float northOffset = -normalizedYaw;
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)centerX, (float)y, 0.0f);
        guiGraphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_(northOffset));
        guiGraphics.m_280168_().m_252880_((float)(-centerX), (float)(-y), 0.0f);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        Matrix4f matrix = guiGraphics.m_280168_().m_85850_().m_252922_();
        RenderSystem.setShader(GameRenderer::m_172811_);
        buffer.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85815_);
        float arrowSize = 8.0f;
        buffer.m_252986_(matrix, (float)centerX, (float)(y - compassRadius), 0.0f).m_193479_(-1).m_5752_();
        buffer.m_252986_(matrix, (float)centerX - arrowSize, (float)(y - compassRadius) + arrowSize * 2.0f, 0.0f).m_193479_(-1).m_5752_();
        buffer.m_252986_(matrix, (float)centerX + arrowSize, (float)(y - compassRadius) + arrowSize * 2.0f, 0.0f).m_193479_(-1).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
        Minecraft mc = Minecraft.m_91087_();
        String northLabel = "N";
        int labelWidth = mc.f_91062_.m_92895_(northLabel);
        guiGraphics.m_280614_(mc.f_91062_, (Component)Component.m_237113_((String)northLabel), centerX - labelWidth / 2, y - compassRadius - 12, -1, false);
        guiGraphics.m_280168_().m_85849_();
    }

    private void renderInfo(GuiGraphics guiGraphics, int screenWidth, int screenHeight, double altitude, double distance, double speed) {
        Minecraft mc = Minecraft.m_91087_();
        int y = screenHeight - 80;
        int x = 10;
        int lineHeight = 12;
        int spacing = 2;
        String altitudeText = String.format("H: %.1fm", altitude);
        String distanceText = String.format("D: %.1fm", distance);
        String speedText = String.format("S: %.1fm/s", speed);
        guiGraphics.m_280614_(mc.f_91062_, (Component)Component.m_237113_((String)altitudeText), x, y, -1, false);
        guiGraphics.m_280614_(mc.f_91062_, (Component)Component.m_237113_((String)distanceText), x, y + lineHeight + spacing, -1, false);
        guiGraphics.m_280614_(mc.f_91062_, (Component)Component.m_237113_((String)speedText), x, y + (lineHeight + spacing) * 2, -1, false);
    }

    private void renderSignalLossWarning(GuiGraphics guiGraphics, int screenWidth, int screenHeight, float partialTick) {
        Minecraft mc = Minecraft.m_91087_();
        String warningText = "\u041f\u041e\u0422\u0415\u0420\u042f \u0421\u0418\u0413\u041d\u0410\u041b\u0410";
        int textWidth = mc.f_91062_.m_92895_(warningText);
        Objects.requireNonNull(mc.f_91062_);
        int textHeight = 9;
        int centerX = screenWidth / 2;
        int centerY = screenHeight / 2 - 50;
        int paddingX = 20;
        int paddingY = 10;
        int bgWidth = textWidth + paddingX * 2;
        int bgHeight = textHeight + paddingY * 2;
        float time = (float)(mc.f_91073_ != null ? mc.f_91073_.m_46467_() : 0L) + partialTick;
        float pulse = (float)((double)0.7f + (double)0.3f * Math.sin((double)time * 0.2));
        int bgAlpha = (int)(153.0f * pulse);
        int bgColor = bgAlpha << 24 | 0;
        guiGraphics.m_280509_(centerX - bgWidth / 2, centerY - bgHeight / 2, centerX + bgWidth / 2, centerY + bgHeight / 2, bgColor);
        int textAlpha = (int)(255.0f * pulse);
        int textColor = textAlpha << 24 | 0xFF0000;
        guiGraphics.m_280614_(mc.f_91062_, (Component)Component.m_237113_((String)warningText), centerX - textWidth / 2 + 1, centerY - textHeight / 2 + 1, Integer.MIN_VALUE, false);
        guiGraphics.m_280614_(mc.f_91062_, (Component)Component.m_237113_((String)warningText), centerX - textWidth / 2, centerY - textHeight / 2, textColor, false);
    }
}

