/*
 * Decompiled with CFR 0.152.
 */
package ru.liko.wrbdrones.client.overlay;

import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.entity.vehicle.DroneEntity;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import org.joml.Matrix4f;
import ru.liko.wrbdrones.Wrbdrones;
import ru.liko.wrbdrones.config.ServerConfig;
import ru.liko.wrbdrones.entity.AddonDroneEntity;
import ru.liko.wrbdrones.entity.MavicDroneNoDropEntity;
import ru.liko.wrbdrones.entity.MavicDroneWithDropEntity;
import ru.liko.wrbdrones.entity.RebEntity;
import ru.liko.wrbdrones.entity.RebMiniEntity;
import ru.liko.wrbdrones.network.ModNetworking;

@OnlyIn(value=Dist.CLIENT)
public final class DroneHudOverlay
implements IGuiOverlay {
    public static final String ID = "wrbdrones_drone_hud";
    private static final ResourceLocation TV_FRAME = Wrbdrones.id("textures/overlay/tv_frame.png");
    private static final ResourceLocation CROSSHAIR = Wrbdrones.id("textures/overlay/third_camera.png");
    private static final ResourceLocation NOISE_TEXTURE = Wrbdrones.id("textures/overlay/noise.png");
    private static final int TARGETING_BRACKET_COLOR = -1;
    private static final int TEXT_COLOR = -1;
    private static final int BLACK_BAR_COLOR = -16777216;
    private static final int NOISE_TEXTURE_SIZE = 256;
    private static final int ANIMATION_SPEED = 2;
    private static final double LOW_SIGNAL_THRESHOLD = 0.08;
    private static int tickCounter = 0;
    private static final Set<UUID> SIGNAL_LOSS_REPORTED = new HashSet<UUID>();

    public void render(ForgeGui gui, GuiGraphics gfx, float partialTick, int screenWidth, int screenHeight) {
        Vec3 avatarPos;
        Minecraft mc = gui.getMinecraft();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        CameraType camera = mc.f_91066_.m_92176_();
        if (camera != CameraType.FIRST_PERSON && camera != CameraType.THIRD_PERSON_BACK) {
            return;
        }
        ItemStack monitor = player.m_21205_();
        if (!monitor.m_150930_((Item)ModItems.MONITOR.get())) {
            return;
        }
        if (!monitor.m_41784_().m_128471_("Using")) {
            return;
        }
        if (!monitor.m_41784_().m_128471_("Linked")) {
            return;
        }
        DroneEntity drone = EntityFindUtil.findDrone((Level)player.m_9236_(), (String)monitor.m_41784_().m_128461_("LinkedDrone"));
        if (!(drone instanceof AddonDroneEntity)) {
            return;
        }
        AddonDroneEntity addonDrone = (AddonDroneEntity)drone;
        if (addonDrone instanceof MavicDroneWithDropEntity || addonDrone instanceof MavicDroneNoDropEntity) {
            return;
        }
        int square = Math.min(screenWidth, screenHeight);
        int visibleWidth = (int)((float)square * 0.4f);
        int sideBarWidth = (screenWidth - visibleWidth) / 2;
        sideBarWidth = (int)((float)sideBarWidth * 0.65f * 0.65f);
        sideBarWidth = Math.max(sideBarWidth, 80);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Vec3 operatorPos = player.m_20182_();
        if (addonDrone != null && (avatarPos = addonDrone.getOperatorPosition()) != null) {
            operatorPos = avatarPos;
        }
        double distance = operatorPos.m_82554_(drone.m_20182_());
        double rebJammingFactor = this.getRebJammingFactor(addonDrone);
        double maxDistance = (Double)ServerConfig.FPV_MAX_DISTANCE.get();
        double signalPercent = Math.max(0.0, 1.0 - distance / maxDistance);
        signalPercent *= signalPercent;
        double signalStrength = Math.max(0.0, Math.min(1.0, signalPercent *= 1.0 - rebJammingFactor));
        int signal = (int)Math.max(0.0, Math.min(99.0, signalStrength * 100.0));
        this.renderFrameAndCrosshair(gfx, screenWidth, screenHeight);
        RenderSystem.setShader(GameRenderer::m_172811_);
        this.renderSideBars(gfx, screenWidth, screenHeight, sideBarWidth);
        this.renderTargetingBrackets(gfx, screenWidth, screenHeight, sideBarWidth);
        this.renderIndicators(gfx, screenWidth, screenHeight, sideBarWidth, drone, (Player)player, distance, monitor, signal);
        RenderSystem.setShader(GameRenderer::m_172817_);
        this.handleSignalLoss(addonDrone, signal);
        double rebInterferenceFactor = this.getRebInterferenceFactor(addonDrone);
        this.renderNoise(gfx, screenWidth, screenHeight, sideBarWidth, distance, partialTick, signal, signalStrength, rebInterferenceFactor);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void handleSignalLoss(AddonDroneEntity drone, int signal) {
        UUID droneId = drone.m_20148_();
        if (signal <= 0) {
            if (SIGNAL_LOSS_REPORTED.add(droneId)) {
                ModNetworking.reportSignalLost(droneId);
            }
        } else {
            SIGNAL_LOSS_REPORTED.remove(droneId);
        }
    }

    private void renderFrameAndCrosshair(GuiGraphics gfx, int screenWidth, int screenHeight) {
        gfx.m_280163_(CROSSHAIR, screenWidth / 2 - 16, screenHeight / 2 - 16, 0.0f, 0.0f, 32, 32, 32, 32);
        float addW = (float)screenWidth / (float)screenHeight * 48.0f;
        float addH = (float)screenWidth / (float)screenHeight * 27.0f;
        RenderHelper.preciseBlit((GuiGraphics)gfx, (ResourceLocation)TV_FRAME, (float)(-addW / 2.0f), (float)(-addH / 2.0f), (float)10.0f, (float)0.0f, (float)0.0f, (float)((float)screenWidth + addW), (float)((float)screenHeight + addH), (float)((float)screenWidth + addW), (float)((float)screenHeight + addH));
    }

    private void renderNoise(GuiGraphics gfx, int screenWidth, int screenHeight, int sideBarWidth, double distance, float partialTick, int signal, double signalStrength, double rebInterferenceFactor) {
        if (!((Boolean)ServerConfig.FPV_ENABLE_NOISE_EFFECT.get()).booleanValue()) {
            return;
        }
        double minDistance = (Double)ServerConfig.FPV_NOISE_MIN_DISTANCE.get();
        double maxDistance = (Double)ServerConfig.FPV_NOISE_MAX_DISTANCE.get();
        double intensityMultiplier = (Double)ServerConfig.FPV_NOISE_INTENSITY_MULTIPLIER.get();
        double noise = 0.0;
        boolean isSignalLost = signalStrength <= 0.0;
        double lowSignalFactor = this.computeLowSignalFactor(signalStrength);
        double easedLowSignalFactor = this.smoothLowSignalFactor(lowSignalFactor);
        double criticalSignalFactor = this.computeCriticalSignalFactor(signalStrength);
        if (isSignalLost) {
            noise = 1.0;
        } else if (distance > minDistance && maxDistance > minDistance) {
            double norm = Math.min(1.0, (distance - minDistance) / (maxDistance - minDistance));
            noise = this.smoothstep(norm) * intensityMultiplier;
        }
        if (lowSignalFactor > 0.0) {
            double boosted = 0.1 * lowSignalFactor + 0.5 * easedLowSignalFactor;
            noise = Math.max(noise, boosted);
        }
        if (criticalSignalFactor > 0.0) {
            double criticalBoost = 0.55 + 0.45 * criticalSignalFactor;
            noise = Math.max(noise, Math.min(1.0, criticalBoost));
        }
        double rebNoise = rebInterferenceFactor * 0.35;
        noise = Math.min(1.0, noise + rebNoise);
        if ((noise = Math.min(1.0, noise)) <= 0.0) {
            return;
        }
        if (++tickCounter >= 2) {
            tickCounter = 0;
        }
        Minecraft mc = Minecraft.m_91087_();
        float time = (mc.f_91073_ != null ? (float)mc.f_91073_.m_46467_() + partialTick : 0.0f) * 0.05f;
        float alpha = this.calculateNoiseAlpha(noise, time, isSignalLost, easedLowSignalFactor, criticalSignalFactor);
        this.renderNoiseWithTexture(gfx, screenWidth, screenHeight, sideBarWidth, alpha, time, isSignalLost, easedLowSignalFactor, lowSignalFactor, criticalSignalFactor);
    }

    private float calculateNoiseAlpha(double intensity, float time, boolean isSignalLost, double lowSignalFactor, double criticalSignalFactor) {
        if (isSignalLost) {
            float pulse = (float)(0.5 + 0.5 * Math.sin((double)time * 0.5));
            float base = 0.9f;
            return Math.min(1.0f, base + 0.08f * pulse);
        }
        float pulse = (float)(0.5 + 0.5 * Math.sin((double)time * 0.2));
        float base = (float)intensity * 0.5f;
        float lowSignalBoost = (float)((double)0.2f * lowSignalFactor);
        float criticalBoost = (float)((double)0.35f * criticalSignalFactor);
        return Math.min(1.0f, base + (float)intensity * 0.25f * pulse + lowSignalBoost + criticalBoost);
    }

    private double computeLowSignalFactor(double signalStrength) {
        double normalized = (0.08 - signalStrength) / 0.08;
        normalized = Math.max(0.0, Math.min(1.0, normalized));
        return Math.pow(normalized, 1.2);
    }

    private double computeCriticalSignalFactor(double signalStrength) {
        double criticalThreshold = 0.05;
        double normalized = (criticalThreshold - signalStrength) / criticalThreshold;
        return Math.max(0.0, Math.min(1.0, normalized));
    }

    private double smoothLowSignalFactor(double factor) {
        if (factor <= 0.0) {
            return 0.0;
        }
        if (factor >= 1.0) {
            return 1.0;
        }
        return factor * factor * (3.0 - 2.0 * factor);
    }

    private double smoothstep(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        if (x >= 1.0) {
            return 1.0;
        }
        return x * x * x * (x * (x * 6.0 - 15.0) + 10.0);
    }

    private void renderNoiseWithTexture(GuiGraphics gfx, int screenWidth, int screenHeight, int sideBarWidth, float alpha, float time, boolean isSignalLost, double lowSignalFactor, double rawLowSignalFactor, double criticalSignalFactor) {
        float strength;
        boolean allowSecondaryLayer;
        int visibleX = sideBarWidth;
        int visibleWidth = screenWidth - 2 * sideBarWidth;
        int visibleHeight = screenHeight;
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        Minecraft mc = Minecraft.m_91087_();
        Window window = mc.m_91268_();
        double guiScale = window.m_85449_();
        int scissorX = (int)((double)visibleX * guiScale);
        int scissorY = (int)((double)window.m_85442_() - (double)visibleHeight * guiScale);
        int scissorW = (int)((double)visibleWidth * guiScale);
        int scissorH = (int)((double)visibleHeight * guiScale);
        RenderSystem.enableScissor((int)scissorX, (int)scissorY, (int)scissorW, (int)scissorH);
        int tilesX = screenWidth / 256 + 2;
        int tilesY = screenHeight / 256 + 2;
        int frame = (int)(time * 10.0f);
        int offsetX = (frame * 37 + frame * 13) % 256;
        int offsetY = (frame * 73 + frame * 19) % 256;
        this.blitNoiseLayer(gfx, 0, 0, screenWidth, screenHeight, tilesX, tilesY, offsetX, offsetY);
        double severity = Math.max(rawLowSignalFactor, criticalSignalFactor);
        boolean bl = allowSecondaryLayer = isSignalLost || severity > 0.75;
        if (allowSecondaryLayer) {
            strength = isSignalLost ? alpha * 0.55f : alpha * (0.05f + 0.35f * (float)((severity - 0.75) / 0.25));
            if ((strength = Math.min(alpha * 0.5f, Math.max(0.0f, strength))) > 0.05f) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)strength);
                int frame2 = (int)(time * 8.0f);
                int offsetX2 = (frame2 * 41 + frame2 * 17) % 256;
                int offsetY2 = (frame2 * 67 + frame2 * 23) % 256;
                this.blitNoiseLayer(gfx, 0, 0, screenWidth, screenHeight, tilesX, tilesY, offsetX2, offsetY2);
            }
        }
        if (isSignalLost) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(alpha * 0.7f));
            int frame3 = (int)(time * 12.0f);
            int offsetX3 = (frame3 * 53 + frame3 * 29) % 256;
            int offsetY3 = (frame3 * 79 + frame3 * 31) % 256;
            this.blitNoiseLayer(gfx, 0, 0, screenWidth, screenHeight, tilesX, tilesY, offsetX3, offsetY3);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(alpha * 0.6f));
            int frame4 = (int)(time * 15.0f);
            int offsetX4 = (frame4 * 61 + frame4 * 37) % 256;
            int offsetY4 = (frame4 * 83 + frame4 * 43) % 256;
            this.blitNoiseLayer(gfx, 0, 0, screenWidth, screenHeight, tilesX, tilesY, offsetX4, offsetY4);
            long seedBase = mc.f_91073_ != null ? mc.f_91073_.m_46467_() * 37L : 0L;
            long seed = seedBase ^ (long)(time * 4096.0f);
            RandomSource random = RandomSource.m_216335_((long)seed);
            this.renderSignalLossScramble(gfx, visibleX, 0, visibleWidth, visibleHeight, random, 1.0f, true);
        } else if (severity > 0.9) {
            strength = (float)((double)0.1f + (double)0.7f * severity);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)Math.min(1.0f, alpha + strength * 0.1f));
            this.blitNoiseLayer(gfx, 0, 0, screenWidth, screenHeight, tilesX, tilesY, offsetX, offsetY);
            long seedBase = mc.f_91073_ != null ? mc.f_91073_.m_46467_() * 23L : 0L;
            long seed = seedBase ^ (long)(time * 2048.0f);
            RandomSource random = RandomSource.m_216335_((long)seed);
            this.renderSignalLossScramble(gfx, visibleX, 0, visibleWidth, visibleHeight, random, strength, false);
        }
        RenderSystem.disableScissor();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderSignalLossScramble(GuiGraphics gfx, int startX, int startY, int width, int height, RandomSource random, float strength, boolean fullLoss) {
        int bandHeight;
        RenderSystem.setShader(GameRenderer::m_172811_);
        for (int y = startY; y < startY + height; y += bandHeight) {
            int maxBand = fullLoss ? 18 : (int)(6.0f + strength * 20.0f);
            bandHeight = Math.min(3 + random.m_188503_(Math.max(4, maxBand)), startY + height - y);
            int intensityBase = fullLoss ? 160 : 90;
            int intensityVariation = fullLoss ? 80 : (int)(120.0f * strength);
            int intensity = intensityBase + random.m_188503_(Math.max(1, intensityVariation));
            if (!fullLoss && random.m_188503_(6) == 0) {
                intensity = 40 + random.m_188503_(60);
            }
            int alpha = Math.min(255, (int)(120.0f + 120.0f * strength));
            int color = alpha << 24 | intensity << 16 | intensity << 8 | intensity;
            int segments = fullLoss ? 1 + random.m_188503_(3) : 1 + random.m_188503_(2);
            for (int s = 0; s < segments; ++s) {
                int glitchWidth = Math.max(6, (int)((double)width * (fullLoss ? 0.6 + random.m_188500_() * 0.4 : 0.25 + (double)strength * random.m_188500_())));
                glitchWidth = Math.min(glitchWidth, width);
                int glitchStart = startX + random.m_188503_(Math.max(1, width - glitchWidth + 1));
                gfx.m_280509_(glitchStart, y, glitchStart + glitchWidth, y + bandHeight, color);
            }
        }
    }

    private void blitNoiseLayer(GuiGraphics gfx, int startX, int startY, int width, int height, int tilesX, int tilesY, int offsetX, int offsetY) {
        for (int x = -1; x < tilesX; ++x) {
            for (int y = -1; y < tilesY; ++y) {
                int px = startX + x * 256 - offsetX;
                int py = startY + y * 256 - offsetY;
                if (px + 256 <= startX || px >= startX + width || py + 256 <= startY || py >= startY + height) continue;
                gfx.m_280163_(NOISE_TEXTURE, px, py, 0.0f, 0.0f, 256, 256, 256, 256);
            }
        }
    }

    private void renderSideBars(GuiGraphics gfx, int screenWidth, int screenHeight, int sideBarWidth) {
        if (sideBarWidth <= 0) {
            return;
        }
        gfx.m_280509_(0, 0, sideBarWidth, screenHeight, -16777216);
        gfx.m_280509_(screenWidth - sideBarWidth, 0, screenWidth, screenHeight, -16777216);
    }

    private void renderTargetingBrackets(GuiGraphics gfx, int screenWidth, int screenHeight, int sideBarWidth) {
        int visibleWidth = screenWidth - 2 * sideBarWidth;
        int centerX = screenWidth / 2;
        int bracketWidth = (int)((float)visibleWidth / 5.94f);
        int bracketHeight = screenHeight / 3;
        int top = screenHeight / 2 - bracketHeight / 2;
        int bottom = screenHeight / 2 + bracketHeight / 2;
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        Matrix4f matrix = gfx.m_280168_().m_85850_().m_252922_();
        buffer.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
        this.drawDashedLine(buffer, matrix, centerX - bracketWidth, top, centerX - bracketWidth, bottom, 8, 4, -1);
        this.drawDashedLine(buffer, matrix, centerX + bracketWidth, top, centerX + bracketWidth, bottom, 8, 4, -1);
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
    }

    private void drawDashedLine(BufferBuilder buffer, Matrix4f matrix, float x1, float y1, float x2, float y2, int dashLength, int dashGap, int color) {
        float dx = x2 - x1;
        float dy = y2 - y1;
        float length = (float)Math.sqrt(dx * dx + dy * dy);
        if (length <= 0.0f) {
            return;
        }
        float step = dashLength + dashGap;
        int segments = (int)(length / step) + 1;
        for (int i = 0; i < segments; ++i) {
            float start = (float)i * step / length;
            float end = Math.min(1.0f, ((float)i * step + (float)dashLength) / length);
            float sx = x1 + dx * start;
            float sy = y1 + dy * start;
            float ex = x1 + dx * end;
            float ey = y1 + dy * end;
            buffer.m_252986_(matrix, sx, sy, 0.0f).m_193479_(color).m_5752_();
            buffer.m_252986_(matrix, ex, ey, 0.0f).m_193479_(color).m_5752_();
        }
    }

    private void renderIndicators(GuiGraphics gfx, int screenWidth, int screenHeight, int sideBarWidth, DroneEntity drone, Player player, double distance, ItemStack monitor, int signal) {
        Minecraft mc = Minecraft.m_91087_();
        if (!(drone instanceof AddonDroneEntity)) {
            return;
        }
        String controllerUuid = (String)drone.m_20088_().m_135370_(DroneEntity.CONTROLLER);
        Player controller = null;
        if (!(controllerUuid == null || controllerUuid.isEmpty() || "undefined".equals(controllerUuid) || "none".equals(controllerUuid))) {
            controller = EntityFindUtil.findPlayer((Level)drone.m_9236_(), (String)controllerUuid);
        }
        if (controller == null) {
            String linked = monitor.m_41784_().m_128461_("LinkedDrone");
            if (drone.m_20149_().equals(linked)) {
                controller = player;
            }
        }
        String callsign = controller != null ? controller.m_5446_().getString() : "CROCUS";
        int centerX = screenWidth / 2;
        gfx.m_280653_(mc.f_91062_, (Component)Component.m_237113_((String)callsign), centerX, screenHeight / 2 - 60, -1);
        String distanceText = String.format("%.1fm", distance);
        int distanceX = sideBarWidth + 10;
        gfx.m_280614_(mc.f_91062_, (Component)Component.m_237113_((String)distanceText), distanceX, screenHeight - 60, -1, false);
        String signalText = String.format("%02d", signal);
        int signalTextX = screenWidth - sideBarWidth - 10;
        int signalY = screenHeight - 60;
        int signalTextWidth = mc.f_91062_.m_92895_(signalText);
        int signalIconX = (signalTextX -= signalTextWidth) - 25;
        this.renderSignalIcon(gfx, signalIconX, signalY, signal);
        gfx.m_280614_(mc.f_91062_, (Component)Component.m_237113_((String)signalText), signalTextX, signalY, -1, false);
    }

    private void renderSignalIcon(GuiGraphics gfx, int x, int y, int signal) {
        int activeBars = 1;
        if (signal >= 25) {
            activeBars = 2;
        }
        if (signal >= 50) {
            activeBars = 3;
        }
        if (signal >= 75) {
            activeBars = 4;
        }
        int barWidth = 3;
        int barSpacing = 2;
        int[] barHeights = new int[]{4, 6, 8, 10};
        int maxBarHeight = 10;
        int iconBaseY = y + 1;
        for (int i = 0; i < 4; ++i) {
            int barX = x + i * (barWidth + barSpacing);
            int barHeight = barHeights[i];
            int barY = iconBaseY + (maxBarHeight - barHeight);
            int color = i < activeBars ? -1 : -8355712;
            gfx.m_280509_(barX, barY, barX + barWidth, barY + barHeight, color);
        }
    }

    private double getRebJammingFactor(AddonDroneEntity drone) {
        if (drone.m_9236_() == null) {
            return 0.0;
        }
        double rebRadius = (Double)ServerConfig.REB_RADIUS.get();
        double rebMiniRadius = (Double)ServerConfig.REB_MINI_RADIUS.get();
        double maxFactor = 0.0;
        LevelEntityGetter entities = EntityFindUtil.getEntities((Level)drone.m_9236_());
        for (Entity entity : entities.m_142273_()) {
            RebMiniEntity rebMiniEntity;
            double factor;
            double normalizedDistance;
            double distance;
            RebEntity rebEntity;
            if (entity instanceof RebEntity && !(rebEntity = (RebEntity)entity).m_213877_() && rebEntity.isEnabled() && (distance = Math.sqrt(drone.m_20280_(rebEntity))) <= rebRadius) {
                normalizedDistance = distance / rebRadius;
                factor = 1.0 - normalizedDistance;
                factor *= factor;
                maxFactor = Math.max(maxFactor, factor);
            }
            if (!(entity instanceof RebMiniEntity) || (rebMiniEntity = (RebMiniEntity)entity).m_213877_() || !rebMiniEntity.isEnabled() || !((distance = Math.sqrt(drone.m_20280_(rebMiniEntity))) <= rebMiniRadius)) continue;
            normalizedDistance = distance / rebMiniRadius;
            factor = 1.0 - normalizedDistance;
            factor *= factor;
            maxFactor = Math.max(maxFactor, factor);
        }
        return Math.min(1.0, maxFactor);
    }

    private double getRebInterferenceFactor(AddonDroneEntity drone) {
        if (drone.m_9236_() == null) {
            return 0.0;
        }
        double rebRadius = (Double)ServerConfig.REB_RADIUS.get();
        double rebMiniRadius = (Double)ServerConfig.REB_MINI_RADIUS.get();
        double maxFactor = 0.0;
        LevelEntityGetter entities = EntityFindUtil.getEntities((Level)drone.m_9236_());
        for (Entity entity : entities.m_142273_()) {
            RebMiniEntity rebMiniEntity;
            double factor;
            double normalizedDistance;
            double distance;
            RebEntity rebEntity;
            if (entity instanceof RebEntity && !(rebEntity = (RebEntity)entity).m_213877_() && rebEntity.isEnabled() && (distance = Math.sqrt(drone.m_20280_(rebEntity))) <= rebRadius) {
                normalizedDistance = distance / rebRadius;
                factor = 1.0 - normalizedDistance;
                factor *= factor;
                maxFactor = Math.max(maxFactor, factor);
            }
            if (!(entity instanceof RebMiniEntity) || (rebMiniEntity = (RebMiniEntity)entity).m_213877_() || !rebMiniEntity.isEnabled() || !((distance = Math.sqrt(drone.m_20280_(rebMiniEntity))) <= rebMiniRadius)) continue;
            normalizedDistance = distance / rebMiniRadius;
            factor = 1.0 - normalizedDistance;
            factor *= factor;
            maxFactor = Math.max(maxFactor, factor);
        }
        return Math.min(1.0, maxFactor);
    }
}

