/*
 * Decompiled with CFR 0.152.
 */
package ru.liko.wrbdrones.client;

import net.minecraft.world.entity.EntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import ru.liko.wrbdrones.client.overlay.DroneHudOverlay;
import ru.liko.wrbdrones.client.overlay.DroneInterferenceOverlay;
import ru.liko.wrbdrones.client.overlay.MavicHudOverlay;
import ru.liko.wrbdrones.client.renderer.AddonDroneRenderer;
import ru.liko.wrbdrones.client.renderer.RebMiniRenderer;
import ru.liko.wrbdrones.client.renderer.RebRenderer;
import ru.liko.wrbdrones.registry.ModEntityTypes;

@Mod.EventBusSubscriber(modid="wrbdrones", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ClientSetup {
    private ClientSetup() {
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)ModEntityTypes.MAVIC_DRONE_WITH_DROP.get(), context -> new AddonDroneRenderer(context));
        event.registerEntityRenderer((EntityType)ModEntityTypes.MAVIC_DRONE_NO_DROP.get(), context -> new AddonDroneRenderer(context));
        event.registerEntityRenderer((EntityType)ModEntityTypes.FPV_DRONE.get(), context -> new AddonDroneRenderer(context));
        event.registerEntityRenderer((EntityType)ModEntityTypes.REB.get(), RebRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityTypes.REB_MINI.get(), RebMiniRenderer::new);
    }

    @SubscribeEvent
    public static void registerGuiOverlays(RegisterGuiOverlaysEvent event) {
        event.registerBelowAll("wrbdrones_drone_hud", (IGuiOverlay)new DroneHudOverlay());
        event.registerAboveAll("wrbdrones_mavic_hud", (IGuiOverlay)new MavicHudOverlay());
        event.registerAboveAll("wrbdrones_drone_interference", (IGuiOverlay)new DroneInterferenceOverlay());
    }
}

