/*
 * Decompiled with CFR 0.152.
 */
package ru.liko.capturepoints;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Scoreboard;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;
import ru.liko.capturepoints.ClientConfig;
import ru.liko.capturepoints.ClientZones;
import ru.liko.capturepoints.TeamUtils;

@Mod.EventBusSubscriber(modid="wrbcapturepoint", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class ZoneWorldRenderer {
    private static final int HOLO_CYAN = -16711681;
    private static final int HOLO_ORANGE = -39424;
    private static final int HOLO_PURPLE = -3407617;
    private static final int HOLO_GREEN = -16711834;
    private static final int HOLO_RED = -52378;
    private static final int HOLO_WHITE = -1;
    private static float glitchTime = 0.0f;
    private static float scanlineTime = 0.0f;
    private static float pulseTime = 0.0f;
    private static long lastUpdateTime = 0L;

    @SubscribeEvent
    public static void onRenderWorld(RenderLevelStageEvent e) {
        if (e.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        if (!((Boolean)ClientConfig.HUD_HOLOGRAMS_ENABLED.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91074_ == null) {
            return;
        }
        List<ClientZones.Label> labels = ClientZones.get();
        if (labels.isEmpty()) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (lastUpdateTime == 0L) {
            lastUpdateTime = currentTime;
        }
        float deltaTime = (float)(currentTime - lastUpdateTime) / 1000.0f;
        lastUpdateTime = currentTime;
        glitchTime += deltaTime * 8.0f;
        scanlineTime += deltaTime * 12.0f;
        pulseTime += deltaTime * 3.0f;
        Camera camera = mc.f_91063_.m_109153_();
        Vec3 camPos = camera.m_90583_();
        PoseStack ps = e.getPoseStack();
        Font font = mc.f_91062_;
        MultiBufferSource.BufferSource buffers = mc.m_91269_().m_110104_();
        for (ClientZones.Label label : labels) {
            boolean glitching;
            double dx = label.x - camPos.f_82479_;
            double dy = label.y - camPos.f_82480_;
            double dz = label.z - camPos.f_82481_;
            double dist = Math.sqrt(dx * dx + dy * dy + dz * dz);
            if (dist > 80.0) continue;
            ps.m_85836_();
            float hover = (float)(Math.sin((double)pulseTime + label.x * 0.1) * 0.15);
            float sway = (float)(Math.cos((double)pulseTime * 0.7 + label.z * 0.1) * 0.05);
            ps.m_85837_(dx + (double)sway, dy + (double)hover, dz);
            ps.m_252781_(camera.m_253121_());
            float scale = (float)Math.max(0.015, Math.min(0.04, 0.02 + dist * 8.0E-4));
            ps.m_85841_(-scale, -scale, scale);
            boolean bl = glitching = Math.sin((double)glitchTime * 2.3) > 0.85;
            if (glitching) {
                float glitchX = (float)(Math.random() - 0.5) * 2.0f;
                float glitchY = (float)(Math.random() - 0.5) * 1.0f;
                ps.m_252880_(glitchX, glitchY, 0.0f);
            }
            float alpha = (float)Math.max(0.3, Math.min(1.0, (80.0 - dist) / 80.0));
            if (glitching) {
                alpha *= 0.7f;
            }
            ZoneWorldRenderer.renderHologramLabel(ps, (MultiBufferSource)buffers, font, label, alpha);
            ps.m_85849_();
        }
        buffers.m_109911_();
    }

    private static void renderHologramLabel(PoseStack ps, MultiBufferSource buffers, Font font, ClientZones.Label label, float alpha) {
        int primaryColor = ZoneWorldRenderer.getHologramColor(label.status);
        int secondaryColor = ZoneWorldRenderer.mixColors(primaryColor, -1, 0.6f);
        String zoneText = "[ \u0417\u041e\u041d\u0410 " + label.id + " ]";
        String statusText = ZoneWorldRenderer.formatHologramStatus(label.status);
        int zoneWidth = font.m_92895_(zoneText);
        int statusWidth = font.m_92895_(statusText);
        int maxWidth = Math.max(zoneWidth, statusWidth);
        float centerX = (float)(-maxWidth) * 0.5f;
        ZoneWorldRenderer.drawHologramBackdrop(ps, buffers, centerX - 10.0f, -20.0f, maxWidth + 20, 36.0f, primaryColor, alpha);
        ZoneWorldRenderer.drawHologramFrameQuad(ps, buffers, centerX - 10.0f, -20.0f, maxWidth + 20, 36.0f, primaryColor, alpha);
        ZoneWorldRenderer.drawScanlines(ps, buffers, centerX - 10.0f, -20.0f, maxWidth + 20, 36.0f, primaryColor, alpha);
        float titlePulse = (float)(Math.sin((double)pulseTime * 2.5) * 0.3 + 0.7);
        int titleColor = ZoneWorldRenderer.applyAlpha(primaryColor, (int)(255.0f * alpha * titlePulse));
        ZoneWorldRenderer.drawHologramText(font, ps, buffers, zoneText, centerX, -12.0f, titleColor, true);
        float statusPulse = (float)(Math.sin((double)pulseTime * 1.8 + 1.0) * 0.2 + 0.8);
        int statusColor = ZoneWorldRenderer.applyAlpha(secondaryColor, (int)(255.0f * alpha * statusPulse));
        ZoneWorldRenderer.drawHologramText(font, ps, buffers, statusText, (float)(-statusWidth) * 0.5f, -2.0f, statusColor, false);
        if (label.progress > 0.01f && ZoneWorldRenderer.shouldShowProgress(label.status)) {
            ZoneWorldRenderer.drawHologramProgressBar(ps, buffers, centerX, 8.0f, maxWidth, label.progress, primaryColor, alpha);
        }
        ZoneWorldRenderer.drawStatusIndicator(ps, buffers, 0.0f, -25.0f, primaryColor, alpha, label.status);
    }

    private static int getHologramColor(String status) {
        int argb;
        if (status == null) {
            return -16711681;
        }
        String s = status.trim();
        String sl = s.toLowerCase();
        String teamName = null;
        if (sl.startsWith("\u0437\u0430\u0445\u0432\u0430\u0442\u044b\u0432\u0430\u0435\u0442\u0441\u044f:")) {
            teamName = s.substring("\u0417\u0430\u0445\u0432\u0430\u0442\u044b\u0432\u0430\u0435\u0442\u0441\u044f:".length()).trim();
        } else if (sl.startsWith("\u0437\u0430\u0445\u0432\u0430\u0447\u0435\u043d\u0430:")) {
            teamName = s.substring("\u0417\u0430\u0445\u0432\u0430\u0447\u0435\u043d\u0430:".length()).trim();
        }
        if (teamName != null && !teamName.isBlank() && (argb = ZoneWorldRenderer.teamColorARGBFromScoreboard(teamName, 0)) != 0) {
            return argb | 0xFF000000;
        }
        if (sl.contains("\u043d\u0435\u0439\u0442\u0440\u0430\u043b\u0438\u0437")) {
            return -39424;
        }
        if (sl.contains("\u0441\u043f\u043e\u0440\u043d\u0430\u044f")) {
            return -3407617;
        }
        if (sl.contains("\u043d\u0435\u0439\u0442\u0440\u0430\u043b\u044c\u043d\u0430\u044f")) {
            return -1;
        }
        return -16711834;
    }

    private static String formatHologramStatus(String status) {
        if (status == null) {
            return ">> \u041d\u0415\u0418\u0417\u0412\u0415\u0421\u0422\u041d\u041e <<";
        }
        String team1 = (String)ClientConfig.TEAM_AXIS_NAME.get();
        String team2 = (String)ClientConfig.TEAM_ALLIES_NAME.get();
        String s = status.trim();
        if (s.startsWith("\u041d\u0435\u0439\u0442\u0440\u0430\u043b\u0438\u0437\u0443\u0435\u0442\u0441\u044f:")) {
            return ">> \u041d\u0415\u0419\u0422\u0420\u0410\u041b\u0418\u0417\u0410\u0426\u0418\u042f \u0422\u041e\u0427\u041a\u0418 <<";
        }
        if (s.startsWith("\u0417\u0430\u0445\u0432\u0430\u0442\u044b\u0432\u0430\u0435\u0442\u0441\u044f:")) {
            String team = s.substring("\u0417\u0430\u0445\u0432\u0430\u0442\u044b\u0432\u0430\u0435\u0442\u0441\u044f:".length()).trim();
            String teamDisplay = ZoneWorldRenderer.teamDisplayNameFromScoreboard(team, team);
            return ">> \u0417\u0410\u0425\u0412\u0410\u0422 " + teamDisplay.toUpperCase() + " <<";
        }
        if (s.startsWith("\u0417\u0430\u0445\u0432\u0430\u0447\u0435\u043d\u0430:")) {
            String team = s.substring("\u0417\u0430\u0445\u0432\u0430\u0447\u0435\u043d\u0430:".length()).trim();
            String teamDisplay = ZoneWorldRenderer.teamDisplayNameFromScoreboard(team, team);
            return ">> \u041a\u041e\u041d\u0422\u0420\u041e\u041b\u042c " + teamDisplay.toUpperCase() + " <<";
        }
        if (s.equalsIgnoreCase("\u041d\u0435\u0439\u0442\u0440\u0430\u043b\u044c\u043d\u0430\u044f")) {
            return ">> \u041d\u0415\u0419\u0422\u0420\u0410\u041b\u042c\u041d\u0410\u042f \u0417\u041e\u041d\u0410 <<";
        }
        if (s.equalsIgnoreCase("\u0421\u043f\u043e\u0440\u043d\u0430\u044f")) {
            return ">> \u0421\u041f\u041e\u0420\u041d\u0410\u042f \u0417\u041e\u041d\u0410 <<";
        }
        return ">> " + s.toUpperCase() + " <<";
    }

    private static void drawHologramFrame(PoseStack ps, MultiBufferSource buffers, float x, float y, float width, float height, int color, float alpha) {
        Matrix4f m = ps.m_85850_().m_252922_();
        VertexConsumer vc = buffers.m_6299_(RenderType.m_285907_());
        float a = Math.max(0.35f, Math.min(1.0f, alpha));
        int frameColor = ZoneWorldRenderer.applyAlpha(color, (int)(255.0f * a));
        int accentColor = ZoneWorldRenderer.applyAlpha(-1, (int)(255.0f * a));
        float fr = (float)(frameColor >> 16 & 0xFF) / 255.0f;
        float fg = (float)(frameColor >> 8 & 0xFF) / 255.0f;
        float fb = (float)(frameColor & 0xFF) / 255.0f;
        float fa = (float)(frameColor >> 24 & 0xFF) / 255.0f;
        vc.m_252986_(m, x, y + 1.0f, 0.0f).m_85950_(fr, fg, fb, fa).m_5752_();
        vc.m_252986_(m, x + width, y + 1.0f, 0.0f).m_85950_(fr, fg, fb, fa).m_5752_();
        vc.m_252986_(m, x + width, y, 0.0f).m_85950_(fr, fg, fb, fa).m_5752_();
        vc.m_252986_(m, x, y, 0.0f).m_85950_(fr, fg, fb, fa).m_5752_();
        vc.m_252986_(m, x, y + height, 0.0f).m_85950_(fr, fg, fb, fa).m_5752_();
        vc.m_252986_(m, x + width, y + height, 0.0f).m_85950_(fr, fg, fb, fa).m_5752_();
        vc.m_252986_(m, x + width, y + height - 1.0f, 0.0f).m_85950_(fr, fg, fb, fa).m_5752_();
        vc.m_252986_(m, x, y + height - 1.0f, 0.0f).m_85950_(fr, fg, fb, fa).m_5752_();
        vc.m_252986_(m, x + 1.0f, y + height, 0.0f).m_85950_(fr, fg, fb, fa).m_5752_();
        vc.m_252986_(m, x + 1.0f, y, 0.0f).m_85950_(fr, fg, fb, fa).m_5752_();
        vc.m_252986_(m, x, y, 0.0f).m_85950_(fr, fg, fb, fa).m_5752_();
        vc.m_252986_(m, x, y + height, 0.0f).m_85950_(fr, fg, fb, fa).m_5752_();
        vc.m_252986_(m, x + width, y + height, 0.0f).m_85950_(fr, fg, fb, fa).m_5752_();
        vc.m_252986_(m, x + width, y, 0.0f).m_85950_(fr, fg, fb, fa).m_5752_();
        vc.m_252986_(m, x + width - 1.0f, y, 0.0f).m_85950_(fr, fg, fb, fa).m_5752_();
        vc.m_252986_(m, x + width - 1.0f, y + height, 0.0f).m_85950_(fr, fg, fb, fa).m_5752_();
        float ar = (float)(accentColor >> 16 & 0xFF) / 255.0f;
        float ag = (float)(accentColor >> 8 & 0xFF) / 255.0f;
        float ab = (float)(accentColor & 0xFF) / 255.0f;
        float aa = (float)(accentColor >> 24 & 0xFF) / 255.0f;
        float c = 5.0f;
        vc.m_252986_(m, x + c, y - 1.0f, 0.0f).m_85950_(ar, ag, ab, aa).m_5752_();
        vc.m_252986_(m, x - 2.0f, y - 1.0f, 0.0f).m_85950_(ar, ag, ab, aa).m_5752_();
        vc.m_252986_(m, x - 2.0f, y - 2.0f, 0.0f).m_85950_(ar, ag, ab, aa).m_5752_();
        vc.m_252986_(m, x + c, y - 2.0f, 0.0f).m_85950_(ar, ag, ab, aa).m_5752_();
        vc.m_252986_(m, x - 1.0f, y + c, 0.0f).m_85950_(ar, ag, ab, aa).m_5752_();
        vc.m_252986_(m, x - 1.0f, y - 2.0f, 0.0f).m_85950_(ar, ag, ab, aa).m_5752_();
        vc.m_252986_(m, x - 2.0f, y - 2.0f, 0.0f).m_85950_(ar, ag, ab, aa).m_5752_();
        vc.m_252986_(m, x - 2.0f, y + c, 0.0f).m_85950_(ar, ag, ab, aa).m_5752_();
        vc.m_252986_(m, x + width + 2.0f, y - 1.0f, 0.0f).m_85950_(ar, ag, ab, aa).m_5752_();
        vc.m_252986_(m, x + width - c, y - 1.0f, 0.0f).m_85950_(ar, ag, ab, aa).m_5752_();
        vc.m_252986_(m, x + width - c, y - 2.0f, 0.0f).m_85950_(ar, ag, ab, aa).m_5752_();
        vc.m_252986_(m, x + width + 2.0f, y - 2.0f, 0.0f).m_85950_(ar, ag, ab, aa).m_5752_();
        vc.m_252986_(m, x + width + 2.0f, y + c, 0.0f).m_85950_(ar, ag, ab, aa).m_5752_();
        vc.m_252986_(m, x + width + 2.0f, y - 2.0f, 0.0f).m_85950_(ar, ag, ab, aa).m_5752_();
        vc.m_252986_(m, x + width + 1.0f, y - 2.0f, 0.0f).m_85950_(ar, ag, ab, aa).m_5752_();
        vc.m_252986_(m, x + width + 1.0f, y + c, 0.0f).m_85950_(ar, ag, ab, aa).m_5752_();
        vc.m_252986_(m, x + c, y + height + 2.0f, 0.0f).m_85950_(ar, ag, ab, aa).m_5752_();
        vc.m_252986_(m, x - 2.0f, y + height + 2.0f, 0.0f).m_85950_(ar, ag, ab, aa).m_5752_();
        vc.m_252986_(m, x - 2.0f, y + height + 1.0f, 0.0f).m_85950_(ar, ag, ab, aa).m_5752_();
        vc.m_252986_(m, x + c, y + height + 1.0f, 0.0f).m_85950_(ar, ag, ab, aa).m_5752_();
        vc.m_252986_(m, x - 1.0f, y + height + 2.0f, 0.0f).m_85950_(ar, ag, ab, aa).m_5752_();
        vc.m_252986_(m, x - 1.0f, y + height - c, 0.0f).m_85950_(ar, ag, ab, aa).m_5752_();
        vc.m_252986_(m, x - 2.0f, y + height - c, 0.0f).m_85950_(ar, ag, ab, aa).m_5752_();
        vc.m_252986_(m, x - 2.0f, y + height + 2.0f, 0.0f).m_85950_(ar, ag, ab, aa).m_5752_();
        vc.m_252986_(m, x + width + 2.0f, y + height + 2.0f, 0.0f).m_85950_(ar, ag, ab, aa).m_5752_();
        vc.m_252986_(m, x + width - c, y + height + 2.0f, 0.0f).m_85950_(ar, ag, ab, aa).m_5752_();
        vc.m_252986_(m, x + width - c, y + height + 1.0f, 0.0f).m_85950_(ar, ag, ab, aa).m_5752_();
        vc.m_252986_(m, x + width + 2.0f, y + height + 1.0f, 0.0f).m_85950_(ar, ag, ab, aa).m_5752_();
        vc.m_252986_(m, x + width + 2.0f, y + height + 2.0f, 0.0f).m_85950_(ar, ag, ab, aa).m_5752_();
        vc.m_252986_(m, x + width + 2.0f, y + height - c, 0.0f).m_85950_(ar, ag, ab, aa).m_5752_();
        vc.m_252986_(m, x + width + 1.0f, y + height - c, 0.0f).m_85950_(ar, ag, ab, aa).m_5752_();
        vc.m_252986_(m, x + width + 1.0f, y + height + 2.0f, 0.0f).m_85950_(ar, ag, ab, aa).m_5752_();
    }

    private static void drawScanlines(PoseStack ps, MultiBufferSource buffers, float x, float y, float width, float height, int color, float alpha) {
        Matrix4f matrix = ps.m_85850_().m_252922_();
        VertexConsumer buffer = buffers.m_6299_(RenderType.m_110504_());
        float scanPos = (float)(Math.sin(scanlineTime) * 0.5 + 0.5) * height;
        int scanColor = ZoneWorldRenderer.applyAlpha(color, (int)(255.0f * alpha * 0.4f));
        ZoneWorldRenderer.drawHologramLine(buffer, matrix, x, y + scanPos, x + width, y + scanPos, scanColor);
        for (int i = 0; i < 6; ++i) {
            float lineY = y + height / 6.0f * (float)i;
            int lineAlpha = (int)(alpha * 80.0f);
            int lineColor = ZoneWorldRenderer.applyAlpha(color, lineAlpha);
            ZoneWorldRenderer.drawHologramLine(buffer, matrix, x + 2.0f, lineY, x + width - 2.0f, lineY, lineColor);
        }
    }

    private static void drawHologramText(Font font, PoseStack ps, MultiBufferSource buffers, String text, float x, float y, int color, boolean isTitle) {
        boolean flicker;
        boolean bl = flicker = Math.random() > 0.95;
        if (flicker) {
            color = ZoneWorldRenderer.applyAlpha(color, 100);
        }
        font.m_271703_(text, x, y, color, false, ps.m_85850_().m_252922_(), buffers, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        if (isTitle) {
            int glowColor = ZoneWorldRenderer.applyAlpha(color, 60);
            font.m_271703_(text, x, y, glowColor, false, ps.m_85850_().m_252922_(), buffers, Font.DisplayMode.NORMAL, glowColor, 0xF000F0);
        }
    }

    private static void drawHologramProgressBar(PoseStack ps, MultiBufferSource buffers, float x, float y, float width, float progress, int color, float alpha) {
        Matrix4f matrix = ps.m_85850_().m_252922_();
        VertexConsumer buffer = buffers.m_6299_(RenderType.m_285907_());
        float height = 3.0f;
        int bgColor = ZoneWorldRenderer.applyAlpha(0x333333, (int)(255.0f * alpha * 0.6f));
        ZoneWorldRenderer.fillHologramQuad(buffer, matrix, x, y, x + width, y + height, bgColor);
        if (progress > 0.0f) {
            float fillWidth = width * progress;
            float pulse = (float)(Math.sin((double)pulseTime * 4.0) * 0.3 + 0.7);
            int fillColor = ZoneWorldRenderer.applyAlpha(color, (int)(255.0f * alpha * pulse));
            ZoneWorldRenderer.fillHologramQuad(buffer, matrix, x, y, x + fillWidth, y + height, fillColor);
            float pixelPos = (float)(Math.sin((double)scanlineTime * 2.0) * 0.5 + 0.5) * fillWidth;
            int pixelColor = ZoneWorldRenderer.applyAlpha(-1, (int)(255.0f * alpha));
            ZoneWorldRenderer.fillHologramQuad(buffer, matrix, x + pixelPos - 1.0f, y, x + pixelPos + 1.0f, y + height, pixelColor);
        }
        VertexConsumer lineBuffer = buffers.m_6299_(RenderType.m_110504_());
        int frameColor = ZoneWorldRenderer.applyAlpha(color, (int)(255.0f * alpha * 0.8f));
        ZoneWorldRenderer.drawHologramLine(lineBuffer, matrix, x, y, x + width, y, frameColor);
        ZoneWorldRenderer.drawHologramLine(lineBuffer, matrix, x, y + height, x + width, y + height, frameColor);
        ZoneWorldRenderer.drawHologramLine(lineBuffer, matrix, x, y, x, y + height, frameColor);
        ZoneWorldRenderer.drawHologramLine(lineBuffer, matrix, x + width, y, x + width, y + height, frameColor);
    }

    private static void drawStatusIndicator(PoseStack ps, MultiBufferSource buffers, float x, float y, int color, float alpha, String status) {
        Matrix4f matrix = ps.m_85850_().m_252922_();
        VertexConsumer buffer = buffers.m_6299_(RenderType.m_110504_());
        float size = 3.0f;
        float pulse = (float)(Math.sin((double)pulseTime * 3.0) * 0.5 + 0.5);
        int indicatorColor = ZoneWorldRenderer.applyAlpha(color, (int)(255.0f * alpha * (0.6f + pulse * 0.4f)));
        ZoneWorldRenderer.drawHologramLine(buffer, matrix, x - size, y, x, y - size, indicatorColor);
        ZoneWorldRenderer.drawHologramLine(buffer, matrix, x, y - size, x + size, y, indicatorColor);
        ZoneWorldRenderer.drawHologramLine(buffer, matrix, x + size, y, x, y + size, indicatorColor);
        ZoneWorldRenderer.drawHologramLine(buffer, matrix, x, y + size, x - size, y, indicatorColor);
        if (status != null && status.toLowerCase().contains("\u0437\u0430\u0445\u0432\u0430\u0442\u044b\u0432\u0430\u0435\u0442\u0441\u044f")) {
            float angle = glitchTime * 2.0f;
            float radius = 6.0f;
            for (int i = 0; i < 4; ++i) {
                float a = angle + (float)i * 1.5707964f;
                float px = x + (float)Math.cos(a) * radius;
                float py = y + (float)Math.sin(a) * radius;
                int dotColor = ZoneWorldRenderer.applyAlpha(-39424, (int)(255.0f * alpha * 0.8f));
                ZoneWorldRenderer.fillHologramQuad(buffers.m_6299_(RenderType.m_285907_()), matrix, px - 0.5f, py - 0.5f, px + 0.5f, py + 0.5f, dotColor);
            }
        }
    }

    private static boolean shouldShowProgress(String status) {
        return status != null && (status.toLowerCase().contains("\u0437\u0430\u0445\u0432\u0430\u0442\u044b\u0432\u0430\u0435\u0442\u0441\u044f") || status.toLowerCase().contains("\u043d\u0435\u0439\u0442\u0440\u0430\u043b\u0438\u0437"));
    }

    private static int mixColors(int color1, int color2, float factor) {
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int r = (int)((float)r1 + (float)(r2 - r1) * factor);
        int g = (int)((float)g1 + (float)(g2 - g1) * factor);
        int b = (int)((float)b1 + (float)(b2 - b1) * factor);
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    private static void drawHologramLine(VertexConsumer buffer, Matrix4f matrix, float x1, float y1, float x2, float y2, int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        buffer.m_252986_(matrix, x1, y1, 0.0f).m_85950_(r, g, b, a).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix, x2, y2, 0.0f).m_85950_(r, g, b, a).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
    }

    private static void fillHologramQuad(VertexConsumer buffer, Matrix4f matrix, float x1, float y1, float x2, float y2, int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        buffer.m_252986_(matrix, x1, y2, 0.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, x2, y2, 0.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, x2, y1, 0.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, x1, y1, 0.0f).m_85950_(r, g, b, a).m_5752_();
    }

    private static int applyAlpha(int color, int alpha) {
        alpha = Math.max(0, Math.min(255, alpha));
        return alpha << 24 | color & 0xFFFFFF;
    }

    private static void fillQuad(VertexConsumer vc, Matrix4f m, float x1, float y1, float x2, float y2, int argb) {
        float r = (float)(argb >> 16 & 0xFF) / 255.0f;
        float g = (float)(argb >> 8 & 0xFF) / 255.0f;
        float b = (float)(argb & 0xFF) / 255.0f;
        float a = (float)(argb >> 24 & 0xFF) / 255.0f;
        vc.m_252986_(m, x1, y2, 0.0f).m_85950_(r, g, b, a).m_5752_();
        vc.m_252986_(m, x2, y2, 0.0f).m_85950_(r, g, b, a).m_5752_();
        vc.m_252986_(m, x2, y1, 0.0f).m_85950_(r, g, b, a).m_5752_();
        vc.m_252986_(m, x1, y1, 0.0f).m_85950_(r, g, b, a).m_5752_();
    }

    private static void drawBorder(VertexConsumer vc, Matrix4f m, float x1, float y1, float x2, float y2, int argb) {
        ZoneWorldRenderer.fillQuad(vc, m, x1, y1, x2, y1 + 1.0f, argb);
        ZoneWorldRenderer.fillQuad(vc, m, x1, y2 - 1.0f, x2, y2, argb);
        ZoneWorldRenderer.fillQuad(vc, m, x1, y1, x1 + 1.0f, y2, argb);
        ZoneWorldRenderer.fillQuad(vc, m, x2 - 1.0f, y1, x2, y2, argb);
    }

    private static int teamColorARGBFromScoreboard(String teamName, int fallback) {
        try {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_ == null || teamName == null || teamName.isBlank()) {
                return fallback;
            }
            Scoreboard sb = mc.f_91073_.m_6188_();
            Integer rgb = TeamUtils.getTeamRgb(sb, teamName);
            if (rgb == null) {
                return fallback;
            }
            return 0xFF000000 | rgb;
        }
        catch (Throwable t) {
            return fallback;
        }
    }

    private static String teamDisplayNameFromScoreboard(String teamName, String fallback) {
        try {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_ == null || teamName == null || teamName.isBlank()) {
                return fallback;
            }
            Scoreboard sb = mc.f_91073_.m_6188_();
            return TeamUtils.getDisplayName(sb, teamName);
        }
        catch (Throwable t) {
            return fallback;
        }
    }

    private static void drawHologramBackdrop(PoseStack ps, MultiBufferSource buffers, float x, float y, float w, float h, int color, float alpha) {
        Matrix4f m = ps.m_85850_().m_252922_();
        VertexConsumer quad = buffers.m_6299_(RenderType.m_285907_());
        int bg = ZoneWorldRenderer.applyAlpha(-15658216, (int)(220.0f * Math.min(1.0f, alpha + 0.2f)));
        ZoneWorldRenderer.fillHologramQuad(quad, m, x, y, x + w, y + h, bg);
        int glow = ZoneWorldRenderer.applyAlpha(ZoneWorldRenderer.mixColors(color, -1, 0.6f), (int)(90.0f * alpha));
        ZoneWorldRenderer.fillHologramQuad(quad, m, x - 2.0f, y - 2.0f, x + w + 2.0f, y, glow);
        ZoneWorldRenderer.fillHologramQuad(quad, m, x - 2.0f, y + h, x + w + 2.0f, y + h + 2.0f, glow);
        ZoneWorldRenderer.fillHologramQuad(quad, m, x - 2.0f, y, x, y + h, glow);
        ZoneWorldRenderer.fillHologramQuad(quad, m, x + w, y, x + w + 2.0f, y + h, glow);
    }

    private static void drawHologramFrameQuad(PoseStack ps, MultiBufferSource buffers, float x, float y, float w, float h, int color, float alpha) {
        Matrix4f m = ps.m_85850_().m_252922_();
        VertexConsumer quad = buffers.m_6299_(RenderType.m_285907_());
        int frame = ZoneWorldRenderer.applyAlpha(color, (int)(255.0f * Math.min(1.0f, alpha + 0.15f)));
        ZoneWorldRenderer.fillHologramQuad(quad, m, x, y, x + w, y + 1.0f, frame);
        ZoneWorldRenderer.fillHologramQuad(quad, m, x, y + h - 1.0f, x + w, y + h, frame);
        ZoneWorldRenderer.fillHologramQuad(quad, m, x, y, x + 1.0f, y + h, frame);
        ZoneWorldRenderer.fillHologramQuad(quad, m, x + w - 1.0f, y, x + w, y + h, frame);
        int accent = ZoneWorldRenderer.applyAlpha(ZoneWorldRenderer.mixColors(color, -1, 0.7f), (int)(255.0f * alpha));
        float c = 5.0f;
        ZoneWorldRenderer.fillHologramQuad(quad, m, x - 2.0f, y - 2.0f, x + c, y - 1.0f, accent);
        ZoneWorldRenderer.fillHologramQuad(quad, m, x - 2.0f, y - 2.0f, x - 1.0f, y + c, accent);
        ZoneWorldRenderer.fillHologramQuad(quad, m, x + w - c, y - 2.0f, x + w + 2.0f, y - 1.0f, accent);
        ZoneWorldRenderer.fillHologramQuad(quad, m, x + w + 1.0f, y - 2.0f, x + w + 2.0f, y + c, accent);
        ZoneWorldRenderer.fillHologramQuad(quad, m, x - 2.0f, y + h + 1.0f, x + c, y + h + 2.0f, accent);
        ZoneWorldRenderer.fillHologramQuad(quad, m, x - 2.0f, y + h - c, x - 1.0f, y + h + 2.0f, accent);
        ZoneWorldRenderer.fillHologramQuad(quad, m, x + w - c, y + h + 1.0f, x + w + 2.0f, y + h + 2.0f, accent);
        ZoneWorldRenderer.fillHologramQuad(quad, m, x + w + 1.0f, y + h - c, x + w + 2.0f, y + h + 2.0f, accent);
    }
}

