/*
 * Decompiled with CFR 0.152.
 */
package ru.liko.capturepoints;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.phys.AABB;
import ru.liko.capturepoints.CaptureConfig;

public final class Zone {
    public String id;
    public String dimension;
    public BlockPos min;
    public BlockPos max;
    public String ownerTeam = "neutral";
    public String capturingTeam = null;
    public float progress = 0.0f;
    public int captureSeconds;

    public Zone(String id, String dimension, BlockPos p1, BlockPos p2) {
        this.id = id;
        this.dimension = dimension;
        this.min = new BlockPos(Math.min(p1.m_123341_(), p2.m_123341_()), Math.min(p1.m_123342_(), p2.m_123342_()), Math.min(p1.m_123343_(), p2.m_123343_()));
        this.max = new BlockPos(Math.max(p1.m_123341_(), p2.m_123341_()), Math.max(p1.m_123342_(), p2.m_123342_()), Math.max(p1.m_123343_(), p2.m_123343_()));
        this.captureSeconds = Math.max(1, (Integer)CaptureConfig.CAPTURE_TIME_SECONDS.get());
    }

    public boolean contains(BlockPos p) {
        return p.m_123341_() >= this.min.m_123341_() && p.m_123341_() <= this.max.m_123341_() && p.m_123342_() >= this.min.m_123342_() && p.m_123342_() <= this.max.m_123342_() && p.m_123343_() >= this.min.m_123343_() && p.m_123343_() <= this.max.m_123343_();
    }

    public AABB aabb() {
        return new AABB((double)this.min.m_123341_(), (double)this.min.m_123342_(), (double)this.min.m_123343_(), (double)(this.max.m_123341_() + 1), (double)(this.max.m_123342_() + 1), (double)(this.max.m_123343_() + 1));
    }

    public double centerX() {
        return (double)(this.min.m_123341_() + this.max.m_123341_() + 1) / 2.0;
    }

    public double centerY() {
        return (double)(this.min.m_123342_() + this.max.m_123342_() + 1) / 2.0;
    }

    public double centerZ() {
        return (double)(this.min.m_123343_() + this.max.m_123343_() + 1) / 2.0;
    }

    public CompoundTag toTag() {
        CompoundTag t = new CompoundTag();
        t.m_128359_("id", this.id);
        t.m_128359_("dim", this.dimension);
        t.m_128405_("minX", this.min.m_123341_());
        t.m_128405_("minY", this.min.m_123342_());
        t.m_128405_("minZ", this.min.m_123343_());
        t.m_128405_("maxX", this.max.m_123341_());
        t.m_128405_("maxY", this.max.m_123342_());
        t.m_128405_("maxZ", this.max.m_123343_());
        t.m_128359_("owner", this.ownerTeam);
        if (this.capturingTeam != null) {
            t.m_128359_("capturing", this.capturingTeam);
        }
        t.m_128350_("progress", this.progress);
        t.m_128405_("capSecs", Math.max(1, this.captureSeconds));
        return t;
    }

    public static Zone fromTag(CompoundTag t) {
        String id = t.m_128461_("id");
        String dim = t.m_128461_("dim");
        Zone z = new Zone(id, dim, new BlockPos(t.m_128451_("minX"), t.m_128451_("minY"), t.m_128451_("minZ")), new BlockPos(t.m_128451_("maxX"), t.m_128451_("maxY"), t.m_128451_("maxZ")));
        z.ownerTeam = t.m_128461_("owner");
        z.capturingTeam = t.m_128441_("capturing") ? t.m_128461_("capturing") : null;
        z.progress = t.m_128457_("progress");
        z.captureSeconds = t.m_128441_("capSecs") ? Math.max(1, t.m_128451_("capSecs")) : Math.max(1, (Integer)CaptureConfig.CAPTURE_TIME_SECONDS.get());
        return z;
    }
}

