/*
 * Decompiled with CFR 0.152.
 */
package ru.liko.capturepoints;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import ru.liko.capturepoints.ClientData;

public final class S2CZoneStatusPacket {
    public final boolean enabled;
    public final String zoneId;
    public final String ownerTeam;
    public final String capturingTeam;
    public final float progress;
    public final int axisScore;
    public final int alliesScore;
    public final boolean roundRunning;
    public final int roundRemainingTicks;
    public final int roundTotalTicks;

    public S2CZoneStatusPacket(boolean enabled, String zoneId, String ownerTeam, String capturingTeam, float progress, int axisScore, int alliesScore, boolean roundRunning, int roundRemainingTicks, int roundTotalTicks) {
        this.enabled = enabled;
        this.zoneId = zoneId;
        this.ownerTeam = ownerTeam;
        this.capturingTeam = capturingTeam;
        this.progress = progress;
        this.axisScore = axisScore;
        this.alliesScore = alliesScore;
        this.roundRunning = roundRunning;
        this.roundRemainingTicks = roundRemainingTicks;
        this.roundTotalTicks = roundTotalTicks;
    }

    public static void encode(S2CZoneStatusPacket m, FriendlyByteBuf buf) {
        buf.writeBoolean(m.enabled);
        buf.m_130070_(m.zoneId);
        buf.m_130070_(m.ownerTeam);
        buf.m_130070_(m.capturingTeam);
        buf.writeFloat(m.progress);
        buf.writeInt(m.axisScore);
        buf.writeInt(m.alliesScore);
        buf.writeBoolean(m.roundRunning);
        buf.writeInt(m.roundRemainingTicks);
        buf.writeInt(m.roundTotalTicks);
    }

    public static S2CZoneStatusPacket decode(FriendlyByteBuf buf) {
        return new S2CZoneStatusPacket(buf.readBoolean(), buf.m_130277_(), buf.m_130277_(), buf.m_130277_(), buf.readFloat(), buf.readInt(), buf.readInt(), buf.readBoolean(), buf.readInt(), buf.readInt());
    }

    public static void handle(S2CZoneStatusPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientData.accept(msg)));
        ctx.get().setPacketHandled(true);
    }
}

