/*
 * Decompiled with CFR 0.152.
 */
package ru.liko.capturepoints;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import ru.liko.capturepoints.ClientZones;

public final class S2CZoneLabelsPacket {
    public final List<Label> labels;

    public S2CZoneLabelsPacket(List<Label> labels) {
        this.labels = labels;
    }

    public static void encode(S2CZoneLabelsPacket m, FriendlyByteBuf buf) {
        buf.m_130130_(m.labels.size());
        for (Label l : m.labels) {
            buf.m_130070_(l.id);
            buf.writeDouble(l.x);
            buf.writeDouble(l.y);
            buf.writeDouble(l.z);
            buf.m_130070_(l.status);
            buf.writeFloat(l.progress);
            buf.writeInt(l.minX);
            buf.writeInt(l.minY);
            buf.writeInt(l.minZ);
            buf.writeInt(l.maxX);
            buf.writeInt(l.maxY);
            buf.writeInt(l.maxZ);
        }
    }

    public static S2CZoneLabelsPacket decode(FriendlyByteBuf buf) {
        int n = buf.m_130242_();
        ArrayList<Label> out = new ArrayList<Label>(n);
        for (int i = 0; i < n; ++i) {
            String id = buf.m_130277_();
            double x = buf.readDouble();
            double y = buf.readDouble();
            double z = buf.readDouble();
            String status = buf.m_130277_();
            float progress = buf.readFloat();
            int minX = buf.readInt();
            int minY = buf.readInt();
            int minZ = buf.readInt();
            int maxX = buf.readInt();
            int maxY = buf.readInt();
            int maxZ = buf.readInt();
            out.add(new Label(id, x, y, z, status, progress, minX, minY, minZ, maxX, maxY, maxZ));
        }
        return new S2CZoneLabelsPacket(out);
    }

    public static void handle(S2CZoneLabelsPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientZones.accept(msg.labels)));
        ctx.get().setPacketHandled(true);
    }

    public static final class Label {
        public final String id;
        public final double x;
        public final double y;
        public final double z;
        public final String status;
        public final float progress;
        public final int minX;
        public final int minY;
        public final int minZ;
        public final int maxX;
        public final int maxY;
        public final int maxZ;

        public Label(String id, double x, double y, double z, String status, float progress, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
            this.id = id;
            this.x = x;
            this.y = y;
            this.z = z;
            this.status = status;
            this.progress = progress;
            this.minX = minX;
            this.minY = minY;
            this.minZ = minZ;
            this.maxX = maxX;
            this.maxY = maxY;
            this.maxZ = maxZ;
        }
    }
}

