/*
 * Decompiled with CFR 0.152.
 */
package ru.liko.capturepoints;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.scores.Scoreboard;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import ru.liko.capturepoints.CaptureConfig;
import ru.liko.capturepoints.ClientConfig;
import ru.liko.capturepoints.ClientData;
import ru.liko.capturepoints.TeamUtils;

@Mod.EventBusSubscriber(modid="wrbcapturepoint", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ClientHUD {
    private static final int COL_BG = -871757297;
    private static final int COL_BG_DARK = -586873591;
    private static final int COL_BG_LIGHT = -2011884256;
    private static final int COL_FRAME = -1711276033;
    private static final int COL_FRAME_GLOW = 0x44FFFFFF;
    private static final int COL_TEXT = -1;
    private static final int COL_TEXT_DIM = -857874979;
    private static final int COL_TEXT_SHADOW = -2013265920;
    private static final int COL_TEXT_GLOW = 0x44FFFFFF;
    private static final int COL_AXIS = -1489568;
    private static final int COL_AXIS_LIGHT = -38014;
    private static final int COL_ALLIES = -11886849;
    private static final int COL_ALLIES_LIGHT = -8668929;
    private static final int COL_NEUTRAL = -6645094;
    private static final int COL_NEUTRAL_LIGHT = -4671304;
    private static final int COL_CONTEST = -5210881;
    private static final int COL_NEUTRALIZING = -19641;
    private static final float GLOW_PULSE_SPEED = 0.05f;
    private static final float PROGRESS_SMOOTH_SPEED = 0.08f;
    private static final int BLUR_RADIUS = 2;
    private static float SMOOTH_PROGRESS = 0.0f;
    private static String SMOOTH_ZONE_ID = "";
    private static int CAPTURE_BANNER_TICKS = 80;
    private static int bannerTicksLeft = 0;
    private static long lastGameTick = 0L;
    private static String bannerMsg = "";
    private static int bannerColor = -6645094;
    private static int PANEL_FADE_TICKS = 36;
    private static int panelFadeTicks = 0;
    private static long lastTickPanel = 0L;
    private static String panelLastId = "";
    private static String panelLastOwner = "neutral";
    private static String panelLastCapt = "";
    private static float panelLastProg = 0.0f;
    private static String LAST_ZONE_ID = "";
    private static String LAST_OWNER = "";
    private static String LAST_CAPTURING = "";
    private static String LAST_DIM = "";
    private static boolean INZONE_VISIBLE = false;
    private static boolean lastDesiredInZone = false;
    private static int desiredHoldTicks = 0;
    private static final int INZONE_DEBOUNCE_TICKS = 4;
    private static float glowPulse = 0.0f;
    private static long lastFrameTime = 0L;
    public static final IGuiOverlay HUD = (gui, g, pt, w, h) -> {
        boolean inZone;
        if (!((Boolean)ClientConfig.HUD_ENABLED.get()).booleanValue()) {
            return;
        }
        ClientHUD.updateAnimations();
        Font font = Minecraft.m_91087_().f_91062_;
        int ox = (Integer)ClientConfig.HUD_OFFSET_X.get();
        int oy = (Integer)ClientConfig.HUD_OFFSET_Y.get();
        double guiScale = Minecraft.m_91087_().m_91268_().m_85449_();
        boolean COMPACT = guiScale >= 3.0;
        int topY = 6 + oy;
        if (ClientData.roundRunning() && ClientData.roundTotalTicks() > 0) {
            int remaining = Math.max(0, ClientData.roundRemainingTicks() / 20);
            String time = String.format("%02d:%02d", remaining / 60, remaining % 60);
            String timer = I18n.m_118938_((String)"wrbcapturepoint.hud.time", (Object[])new Object[]{time});
            int tw = font.m_92895_(timer);
            int tx = (w - tw) / 2 + ox;
            int timerBgW = tw + 16;
            int timerBgH = 14;
            int timerBgX = tx - 8;
            int timerBgY = topY - 2;
            g.m_280024_(timerBgX, timerBgY, timerBgX + timerBgW, timerBgY + timerBgH, -2011884256, -586873591);
            g.m_280509_(timerBgX - 1, timerBgY - 1, timerBgX + timerBgW + 1, timerBgY, -1711276033);
            g.m_280509_(timerBgX - 1, timerBgY + timerBgH, timerBgX + timerBgW + 1, timerBgY + timerBgH + 1, -1711276033);
            g.m_280509_(timerBgX - 1, timerBgY - 1, timerBgX, timerBgY + timerBgH + 1, -1711276033);
            g.m_280509_(timerBgX + timerBgW, timerBgY - 1, timerBgX + timerBgW + 1, timerBgY + timerBgH + 1, -1711276033);
            ClientHUD.drawEnhancedText(g, font, timer, tx, topY, -1);
            if (((Boolean)CaptureConfig.TICKETS_ENABLED.get()).booleanValue()) {
                String ticketsLabel = I18n.m_118938_((String)"wrbcapturepoint.hud.tickets", (Object[])new Object[0]);
                int clw = font.m_92895_(ticketsLabel);
                int cx = (w - clw) / 2 + ox;
                int cy = topY + 14;
                g.m_280056_(font, ticketsLabel, cx, cy, -857874979, false);
            }
        }
        if (ClientData.roundRunning()) {
            String team1Name = (String)ClientConfig.TEAM_AXIS_NAME.get();
            String team2Name = (String)ClientConfig.TEAM_ALLIES_NAME.get();
            String team1Score = String.valueOf(ClientData.axisScore());
            String team2Score = String.valueOf(ClientData.alliesScore());
            String left = ClientHUD.getTeamDisplayName(team1Name) + " " + team1Score;
            String right = team2Score + " " + ClientHUD.getTeamDisplayName(team2Name);
            int pad = 6;
            int lh = 14;
            int lw = font.m_92895_(left) + pad * 2;
            int rw = font.m_92895_(right) + pad * 2;
            int lx = w / 2 - 10 - lw + ox;
            int rx = w / 2 + 10 + ox;
            int badgeY = topY + 18;
            int t1c = ClientHUD.teamColor(team1Name);
            int t2c = ClientHUD.teamColor(team2Name);
            int t1cLight = ClientHUD.mix(t1c, -1, 0.35f);
            int t2cLight = ClientHUD.mix(t2c, -1, 0.35f);
            g.m_280024_(lx, badgeY, lx + lw, badgeY + lh, ClientHUD.tint(t1cLight, 0.7f), ClientHUD.tint(t1c, 0.95f));
            g.m_280509_(lx - 1, badgeY - 1, lx + lw + 1, badgeY, -1711276033);
            g.m_280509_(lx - 1, badgeY + lh, lx + lw + 1, badgeY + lh + 1, -1711276033);
            g.m_280509_(lx - 1, badgeY - 1, lx, badgeY + lh + 1, -1711276033);
            g.m_280509_(lx + lw, badgeY - 1, lx + lw + 1, badgeY + lh + 1, -1711276033);
            ClientHUD.drawEnhancedText(g, font, left, lx + pad, badgeY + 3, ClientHUD.withAlpha(t1c, 255));
            g.m_280024_(rx, badgeY, rx + rw, badgeY + lh, ClientHUD.tint(t2cLight, 0.7f), ClientHUD.tint(t2c, 0.95f));
            g.m_280509_(rx - 1, badgeY - 1, rx + rw + 1, badgeY, -1711276033);
            g.m_280509_(rx - 1, badgeY + lh, rx + rw + 1, badgeY + lh + 1, -1711276033);
            g.m_280509_(rx - 1, badgeY - 1, rx, badgeY + lh + 1, -1711276033);
            g.m_280509_(rx + rw, badgeY - 1, rx + rw + 1, badgeY + lh + 1, -1711276033);
            ClientHUD.drawEnhancedText(g, font, right, rx + pad, badgeY + 3, ClientHUD.withAlpha(t2c, 255));
        }
        boolean bl = inZone = ClientData.isEnabled() && ClientData.zoneId() != null && !ClientData.zoneId().isEmpty() && ClientData.isFresh((Integer)ClientConfig.HUD_STALE_TIMEOUT_TICKS.get());
        if (inZone) {
            int statusColor;
            String status;
            int panelW;
            boolean capturingActive;
            String id = ClientData.zoneId();
            String owner = ClientData.owner() != null ? ClientData.owner() : "neutral";
            String capt = ClientData.capturing() != null ? ClientData.capturing() : "";
            float prog = Math.max(0.0f, Math.min(1.0f, ClientData.progress()));
            if (!id.equals(SMOOTH_ZONE_ID)) {
                SMOOTH_ZONE_ID = id;
                SMOOTH_PROGRESS = prog;
            } else {
                SMOOTH_PROGRESS += (prog - SMOOTH_PROGRESS) * 0.25f;
            }
            boolean bl2 = capturingActive = !capt.isEmpty();
            int n = capturingActive ? (COMPACT ? 220 : 260) : (panelW = COMPACT ? 200 : 220);
            int panelH = capturingActive ? (COMPACT ? 42 : 50) : (COMPACT ? 24 : 28);
            int bottomGap = COMPACT ? 45 : 60;
            int x = (w - panelW) / 2 + ox;
            int y = h - panelH - bottomGap + oy;
            g.m_280024_(x, y, x + panelW, y + panelH, -871757297, -586873591);
            g.m_280509_(x, y, x + panelW, y + 1, -1711276033);
            g.m_280509_(x, y + panelH - 1, x + panelW, y + panelH, -1711276033);
            g.m_280509_(x, y, x + 1, y + panelH, -1711276033);
            g.m_280509_(x + panelW - 1, y, x + panelW, y + panelH, -1711276033);
            String zoneTitle = I18n.m_118938_((String)"wrbcapturepoint.hud.zone_title", (Object[])new Object[]{id});
            int titleWidth = font.m_92895_(zoneTitle);
            g.m_280056_(font, zoneTitle, x + (panelW - titleWidth) / 2, y + 4, -1, false);
            String team1Name = (String)ClientConfig.TEAM_AXIS_NAME.get();
            String team2Name = (String)ClientConfig.TEAM_ALLIES_NAME.get();
            if (!capt.isEmpty()) {
                if (!"neutral".equalsIgnoreCase(owner) && !capt.equalsIgnoreCase(owner)) {
                    status = I18n.m_118938_((String)"wrbcapturepoint.hud.status.neutralizing", (Object[])new Object[0]);
                    statusColor = -6645094;
                } else {
                    teamDisplay = ClientHUD.getTeamDisplayName(capt);
                    status = I18n.m_118938_((String)"wrbcapturepoint.hud.status.capturing", (Object[])new Object[]{teamDisplay});
                    statusColor = ClientHUD.teamColor(capt);
                }
            } else if ("neutral".equalsIgnoreCase(owner)) {
                status = I18n.m_118938_((String)"wrbcapturepoint.hud.status.neutral", (Object[])new Object[0]);
                statusColor = -6645094;
            } else {
                teamDisplay = ClientHUD.getTeamDisplayName(owner);
                status = I18n.m_118938_((String)"wrbcapturepoint.hud.status.control", (Object[])new Object[]{teamDisplay});
                statusColor = ClientHUD.teamColor(owner);
            }
            int statusWidth = font.m_92895_(status);
            g.m_280056_(font, status, x + (panelW - statusWidth) / 2, y + 16, statusColor, false);
            if (!capt.isEmpty()) {
                int barX = x + 20;
                int barY = y + (COMPACT ? 26 : 30);
                int barW = panelW - 40;
                int barH = COMPACT ? 10 : 12;
                ClientHUD.drawEnhancedProgressBar(g, barX, barY, barW, barH, SMOOTH_PROGRESS, statusColor);
                String progressText = Math.round(SMOOTH_PROGRESS * 100.0f) + "%";
                int progWidth = font.m_92895_(progressText);
                g.m_280056_(font, progressText, barX + (barW - progWidth) / 2, barY + (COMPACT ? 1 : 2), -1, false);
            }
        } else {
            SMOOTH_ZONE_ID = "";
            SMOOTH_PROGRESS = 0.0f;
        }
    };

    private static void updateAnimations() {
        long currentTime = System.currentTimeMillis();
        if (lastFrameTime == 0L) {
            lastFrameTime = currentTime;
        }
        float deltaTime = (float)(currentTime - lastFrameTime) / 1000.0f;
        lastFrameTime = currentTime;
        if ((double)(glowPulse += 0.05f * deltaTime * 60.0f) > Math.PI * 2) {
            glowPulse = (float)((double)glowPulse - Math.PI * 2);
        }
    }

    private static int addGlow(int baseColor, float intensity) {
        int r = baseColor >> 16 & 0xFF;
        int g = baseColor >> 8 & 0xFF;
        int b = baseColor & 0xFF;
        int a = baseColor >> 24 & 0xFF;
        float pulse = (float)(Math.sin(glowPulse) * 0.5 + 0.5) * intensity;
        r = Math.min(255, (int)((float)r + pulse * 60.0f));
        g = Math.min(255, (int)((float)g + pulse * 60.0f));
        b = Math.min(255, (int)((float)b + pulse * 60.0f));
        return a << 24 | r << 16 | g << 8 | b;
    }

    private static void drawGlowRect(GuiGraphics g, int x, int y, int w, int h, int color, float intensity) {
        for (int i = 2; i >= 0; --i) {
            int alpha = (int)(intensity * 40.0f / (float)(i + 1));
            int glowColor = alpha << 24 | color & 0xFFFFFF;
            g.m_280509_(x - i, y - i, x + w + i, y + h + i, glowColor);
        }
    }

    private static void drawEnhancedProgressBar(GuiGraphics g, int x, int y, int w, int h, float progress, int teamColor) {
        g.m_280024_(x, y, x + w, y + h, -586873591, -871757297);
        if (progress > 0.0f) {
            int fillWidth = (int)((float)w * progress);
            int glowColor = ClientHUD.addGlow(teamColor, 0.3f);
            ClientHUD.drawGlowRect(g, x, y, fillWidth, h, teamColor, 0.2f);
            int lightColor = teamColor == -1489568 ? -38014 : (teamColor == -11886849 ? -8668929 : -4671304);
            g.m_280024_(x, y, x + fillWidth, y + h, lightColor, teamColor);
            float highlightPos = (float)(Math.sin(glowPulse * 2.0f) * 0.5 + 0.5);
            int highlightX = x + (int)((float)fillWidth * highlightPos);
            g.m_280509_(highlightX - 1, y, highlightX + 1, y + h, 0x44FFFFFF);
        }
        g.m_280509_(x - 1, y - 1, x + w + 1, y, 0x44FFFFFF);
        g.m_280509_(x - 1, y + h, x + w + 1, y + h + 1, 0x44FFFFFF);
        g.m_280509_(x - 1, y - 1, x, y + h + 1, 0x44FFFFFF);
        g.m_280509_(x + w, y - 1, x + w + 1, y + h + 1, 0x44FFFFFF);
        g.m_280509_(x - 1, y - 1, x + w + 1, y, -1711276033);
        g.m_280509_(x - 1, y + h, x + w + 1, y + h + 1, -1711276033);
        g.m_280509_(x - 1, y - 1, x, y + h + 1, -1711276033);
        g.m_280509_(x + w, y - 1, x + w + 1, y + h + 1, -1711276033);
    }

    private static void drawEnhancedText(GuiGraphics g, Font font, String text, int x, int y, int color) {
        g.m_280056_(font, text, x, y, color, false);
    }

    private static int withAlpha(int color, int alpha) {
        return alpha << 24 | color & 0xFFFFFF;
    }

    private static int mulAlpha(int color, float factor) {
        int originalAlpha = color >> 24 & 0xFF;
        int newAlpha = (int)((float)originalAlpha * factor);
        return ClientHUD.withAlpha(color, Math.max(0, Math.min(255, newAlpha)));
    }

    private static int tint(int color, float factor) {
        int alpha = color >> 24 & 0xFF;
        int red = (int)((float)(color >> 16 & 0xFF) * factor);
        int green = (int)((float)(color >> 8 & 0xFF) * factor);
        int blue = (int)((float)(color & 0xFF) * factor);
        red = Math.max(0, Math.min(255, red));
        green = Math.max(0, Math.min(255, green));
        blue = Math.max(0, Math.min(255, blue));
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    private static int mix(int color1, int color2, float factor) {
        factor = Math.max(0.0f, Math.min(1.0f, factor));
        int a1 = color1 >> 24 & 0xFF;
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int a2 = color2 >> 24 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int a = (int)((float)a1 + (float)(a2 - a1) * factor);
        int r = (int)((float)r1 + (float)(r2 - r1) * factor);
        int g = (int)((float)g1 + (float)(g2 - g1) * factor);
        int b = (int)((float)b1 + (float)(b2 - b1) * factor);
        return a << 24 | r << 16 | g << 8 | b;
    }

    private static int teamColor(String team) {
        if (team == null || team.isBlank()) {
            return -6645094;
        }
        try {
            Scoreboard sb;
            Integer rgb;
            Minecraft mc = Minecraft.m_91087_();
            if (mc != null && mc.f_91073_ != null && (rgb = TeamUtils.getTeamRgb(sb = mc.f_91073_.m_6188_(), team)) != null) {
                return 0xFF000000 | rgb & 0xFFFFFF;
            }
        }
        catch (Throwable mc) {
            // empty catch block
        }
        String team1Name = (String)ClientConfig.TEAM_AXIS_NAME.get();
        String team2Name = (String)ClientConfig.TEAM_ALLIES_NAME.get();
        if (team.equalsIgnoreCase(team1Name)) {
            return -1489568;
        }
        if (team.equalsIgnoreCase(team2Name)) {
            return -11886849;
        }
        return -6645094;
    }

    private static float clamp01(float value) {
        return Math.max(0.0f, Math.min(1.0f, value));
    }

    private static float easeInOutCubic(float t) {
        return t < 0.5f ? 4.0f * t * t * t : 1.0f - (float)Math.pow(-2.0f * t + 2.0f, 3.0) / 2.0f;
    }

    private static float easeOutCubic(float t) {
        return 1.0f - (float)Math.pow(1.0f - t, 3.0);
    }

    private static float easeInCubic(float t) {
        return t * t * t;
    }

    private static String getTeamDisplayName(String teamId) {
        try {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_ == null || teamId == null || teamId.isBlank()) {
                return teamId == null ? "" : teamId;
            }
            Scoreboard sb = mc.f_91073_.m_6188_();
            return TeamUtils.getDisplayName(sb, teamId);
        }
        catch (Throwable throwable) {
            return teamId == null ? "" : teamId;
        }
    }

    @SubscribeEvent
    public static void registerHud(RegisterGuiOverlaysEvent e) {
        e.registerAbove(VanillaGuiOverlay.EXPERIENCE_BAR.id(), "capture_hud", HUD);
    }
}

