/*
 * Decompiled with CFR 0.152.
 */
package ru.liko.capturepoints;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.scores.Scoreboard;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import ru.liko.capturepoints.CaptureConfig;
import ru.liko.capturepoints.SelectionStore;
import ru.liko.capturepoints.TeamUtils;
import ru.liko.capturepoints.Zone;
import ru.liko.capturepoints.ZonesData;

@Mod.EventBusSubscriber(modid="wrbcapturepoint", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class CaptureCommands {
    @SubscribeEvent
    public static void onRegister(RegisterCommandsEvent e) {
        LiteralArgumentBuilder root = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"cp").requires(src -> src.m_6761_(3))).then(Commands.m_82127_((String)"start").executes(ctx -> {
            ServerLevel lvl = ((CommandSourceStack)ctx.getSource()).m_81372_();
            ZonesData.get(lvl).setEnabled(true);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237115_((String)"commands.wrbcapturepoint.started"), true);
            return 1;
        }))).then(Commands.m_82127_((String)"stop").executes(ctx -> {
            ServerLevel lvl = ((CommandSourceStack)ctx.getSource()).m_81372_();
            ZonesData.get(lvl).setEnabled(false);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237115_((String)"commands.wrbcapturepoint.stopped"), true);
            return 1;
        }))).then(Commands.m_82127_((String)"pos1").executes(ctx -> {
            ServerPlayer p = ((CommandSourceStack)ctx.getSource()).m_81375_();
            BlockPos here = BlockPos.m_274446_((Position)((CommandSourceStack)ctx.getSource()).m_81371_());
            SelectionStore.setPos1(p, here);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("pos1 = " + here.m_123341_() + "," + here.m_123342_() + "," + here.m_123343_())), false);
            return 1;
        }))).then(Commands.m_82127_((String)"pos2").executes(ctx -> {
            ServerPlayer p = ((CommandSourceStack)ctx.getSource()).m_81375_();
            BlockPos here = BlockPos.m_274446_((Position)((CommandSourceStack)ctx.getSource()).m_81371_());
            SelectionStore.setPos2(p, here);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("pos2 = " + here.m_123341_() + "," + here.m_123342_() + "," + here.m_123343_())), false);
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"zone").then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"id", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            ServerPlayer p = ((CommandSourceStack)ctx.getSource()).m_81375_();
            Optional<BlockPos> o1 = SelectionStore.getPos1(p);
            Optional<BlockPos> o2 = SelectionStore.getPos2(p);
            if (o1.isEmpty() || o2.isEmpty()) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237115_((String)"commands.wrbcapturepoint.error.select_pos"));
                return 0;
            }
            ServerLevel lvl = ((CommandSourceStack)ctx.getSource()).m_81372_();
            String dimId = lvl.m_46472_().m_135782_().toString();
            String id = StringArgumentType.getString((CommandContext)ctx, (String)"id");
            Zone z = new Zone(id, dimId, o1.get(), o2.get());
            boolean ok = ZonesData.get(lvl).addZone(z);
            if (!ok) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237115_((String)"commands.wrbcapturepoint.error.zone_exists"));
                return 0;
            }
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.wrbcapturepoint.zone.added", (Object[])new Object[]{id}), true);
            SelectionStore.clear(p);
            return 1;
        })))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"id", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            ServerLevel lvl = ((CommandSourceStack)ctx.getSource()).m_81372_();
            String dimId = lvl.m_46472_().m_135782_().toString();
            String id = StringArgumentType.getString((CommandContext)ctx, (String)"id");
            boolean ok = ZonesData.get(lvl).removeZone(dimId, id);
            if (ok) {
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.wrbcapturepoint.zone.removed", (Object[])new Object[]{id}), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237115_((String)"commands.wrbcapturepoint.error.zone_not_found"));
            }
            return ok ? 1 : 0;
        })))).then(Commands.m_82127_((String)"setowner").then(Commands.m_82129_((String)"id", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"team", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            ServerLevel lvl = ((CommandSourceStack)ctx.getSource()).m_81372_();
            String dimId = lvl.m_46472_().m_135782_().toString();
            String id = StringArgumentType.getString((CommandContext)ctx, (String)"id");
            String team = StringArgumentType.getString((CommandContext)ctx, (String)"team");
            Optional<Zone> opt = ZonesData.get(lvl).find(dimId, id);
            if (opt.isEmpty()) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237115_((String)"commands.wrbcapturepoint.error.zone_not_found"));
                return 0;
            }
            Zone z = opt.get();
            z.ownerTeam = team;
            z.capturingTeam = null;
            z.progress = 0.0f;
            ZonesData.get(lvl).m_77762_();
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.wrbcapturepoint.zone.owner.set", (Object[])new Object[]{id, team}), true);
            return 1;
        }))))).then(Commands.m_82127_((String)"settime").then(Commands.m_82129_((String)"id", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"seconds", (ArgumentType)IntegerArgumentType.integer((int)1, (int)600)).executes(ctx -> {
            ServerLevel lvl = ((CommandSourceStack)ctx.getSource()).m_81372_();
            String dimId = lvl.m_46472_().m_135782_().toString();
            String id = StringArgumentType.getString((CommandContext)ctx, (String)"id");
            int secs = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"seconds");
            Optional<Zone> opt = ZonesData.get(lvl).find(dimId, id);
            if (opt.isEmpty()) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237115_((String)"commands.wrbcapturepoint.error.zone_not_found"));
                return 0;
            }
            Zone z = opt.get();
            z.captureSeconds = Math.max(1, secs);
            ZonesData.get(lvl).m_77762_();
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.wrbcapturepoint.zone.time.set", (Object[])new Object[]{id, secs}), true);
            return 1;
        }))))).then(Commands.m_82127_((String)"list").executes(ctx -> {
            ServerLevel lvl = ((CommandSourceStack)ctx.getSource()).m_81372_();
            String dimId = lvl.m_46472_().m_135782_().toString();
            List<Zone> list = ZonesData.get(lvl).zonesForDimension(dimId);
            if (list.isEmpty()) {
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237115_((String)"commands.wrbcapturepoint.zones.none_here"), false);
            } else {
                for (Zone z : list) {
                    ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("- " + z.id + " owner=" + z.ownerTeam + " [" + z.min.m_123341_() + "," + z.min.m_123342_() + "," + z.min.m_123343_() + " -> " + z.max.m_123341_() + "," + z.max.m_123342_() + "," + z.max.m_123343_() + "]")), false);
                }
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"mode").executes(ctx -> {
            String mode = (String)CaptureConfig.GAME_MODE.get();
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.wrbcapturepoint.mode.current", (Object[])new Object[]{mode}), false);
            return 1;
        })).then(Commands.m_82129_((String)"mode", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            String m = StringArgumentType.getString((CommandContext)ctx, (String)"mode");
            String upper = m.toUpperCase();
            if (!(upper.equals("FREE") || upper.equals("CHAIN_AB") || upper.equals("LINEAR") || upper.equals("ALTERNATING"))) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237115_((String)"commands.wrbcapturepoint.mode.unknown"));
                return 0;
            }
            CaptureConfig.GAME_MODE.set((Object)upper);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.wrbcapturepoint.mode.set", (Object[])new Object[]{upper}), true);
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tickets").then(Commands.m_82127_((String)"status").executes(ctx -> {
            ServerLevel lvl = ((CommandSourceStack)ctx.getSource()).m_81372_();
            ZonesData d = ZonesData.get(lvl);
            boolean en = (Boolean)CaptureConfig.TICKETS_ENABLED.get();
            String t1id = (String)CaptureConfig.TEAM_AXIS_NAME.get();
            String t2id = (String)CaptureConfig.TEAM_ALLIES_NAME.get();
            String t1 = CaptureCommands.getTeamDisplayName(lvl, t1id);
            String t2 = CaptureCommands.getTeamDisplayName(lvl, t2id);
            String st = en ? "ON" : "OFF";
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.wrbcapturepoint.tickets.status", (Object[])new Object[]{st, t1, d.axisTickets, t2, d.alliesTickets, d.ticketsMode}), false);
            return 1;
        }))).then(Commands.m_82127_((String)"on").executes(ctx -> {
            CaptureConfig.TICKETS_ENABLED.set((Object)true);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237115_((String)"commands.wrbcapturepoint.tickets.on"), true);
            return 1;
        }))).then(Commands.m_82127_((String)"off").executes(ctx -> {
            ServerLevel lvl = ((CommandSourceStack)ctx.getSource()).m_81372_();
            ZonesData d = ZonesData.get(lvl);
            CaptureConfig.TICKETS_ENABLED.set((Object)false);
            d.ticketsMode = false;
            d.roundRunning = false;
            d.m_77762_();
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237115_((String)"commands.wrbcapturepoint.tickets.off"), true);
            return 1;
        }))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)100000)).executes(ctx -> {
            ServerLevel lvl = ((CommandSourceStack)ctx.getSource()).m_81372_();
            int val = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"value");
            ZonesData d = ZonesData.get(lvl);
            d.axisTickets = val;
            d.alliesTickets = val;
            d.ticketsMode = true;
            d.m_77762_();
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.wrbcapturepoint.tickets.set", (Object[])new Object[]{val}), true);
            return 1;
        }))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"hud").then(Commands.m_82127_((String)"status").executes(ctx -> {
            boolean hudEn = (Boolean)CaptureConfig.HUD_ENABLED.get();
            int ox = (Integer)CaptureConfig.HUD_OFFSET_X.get();
            int oy = (Integer)CaptureConfig.HUD_OFFSET_Y.get();
            boolean holo = (Boolean)CaptureConfig.HUD_HOLOGRAMS_ENABLED.get();
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("HUD: " + (hudEn ? "ON" : "OFF") + ", offsetX=" + ox + ", offsetY=" + oy + ", holograms=" + (holo ? "ON" : "OFF"))), false);
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"holograms").then(Commands.m_82127_((String)"on").executes(ctx -> {
            CaptureConfig.HUD_HOLOGRAMS_ENABLED.set((Object)true);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237115_((String)"commands.wrbcapturepoint.hud.holograms.on"), true);
            return 1;
        }))).then(Commands.m_82127_((String)"off").executes(ctx -> {
            CaptureConfig.HUD_HOLOGRAMS_ENABLED.set((Object)false);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237115_((String)"commands.wrbcapturepoint.hud.holograms.off"), true);
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"offset").then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"x", (ArgumentType)IntegerArgumentType.integer((int)-10000, (int)10000)).then(Commands.m_82129_((String)"y", (ArgumentType)IntegerArgumentType.integer((int)-10000, (int)10000)).executes(ctx -> {
            int x = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"x");
            int y = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"y");
            CaptureConfig.HUD_OFFSET_X.set((Object)x);
            CaptureConfig.HUD_OFFSET_Y.set((Object)y);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("HUD offset set: x=" + x + ", y=" + y)), true);
            return 1;
        }))))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"dx", (ArgumentType)IntegerArgumentType.integer((int)-10000, (int)10000)).then(Commands.m_82129_((String)"dy", (ArgumentType)IntegerArgumentType.integer((int)-10000, (int)10000)).executes(ctx -> {
            int dx = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"dx");
            int dy = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"dy");
            int nx = (Integer)CaptureConfig.HUD_OFFSET_X.get() + dx;
            int ny = (Integer)CaptureConfig.HUD_OFFSET_Y.get() + dy;
            CaptureConfig.HUD_OFFSET_X.set((Object)nx);
            CaptureConfig.HUD_OFFSET_Y.set((Object)ny);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("HUD offset add: x=" + nx + ", y=" + ny)), true);
            return 1;
        }))))).then(Commands.m_82127_((String)"reset").executes(ctx -> {
            CaptureConfig.HUD_OFFSET_X.set((Object)0);
            CaptureConfig.HUD_OFFSET_Y.set((Object)0);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"HUD offset reset."), true);
            return 1;
        }))));
        e.getDispatcher().register(root);
    }

    private static String getTeamDisplayName(ServerLevel lvl, String teamId) {
        if (teamId == null || teamId.isBlank()) {
            return "";
        }
        try {
            ServerScoreboard sb = lvl.m_6188_();
            return TeamUtils.getDisplayName((Scoreboard)sb, teamId);
        }
        catch (Throwable throwable) {
            return teamId;
        }
    }
}

