/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.workersplus.utils;

import com.talhanation.workers.entities.AbstractWorkerEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.sosly.workersplus.config.CommonConfig;
import org.sosly.workersplus.data.Need;
import org.sosly.workersplus.utils.Containers;

public class Worker {
    public static boolean canWork(@Nullable AbstractWorkerEntity worker) {
        if (worker == null || !worker.m_6084_()) {
            return false;
        }
        return worker.getStatus() == AbstractWorkerEntity.Status.WORK;
    }

    public static Optional<Container> getChestContainer(AbstractWorkerEntity worker) {
        BlockPos pos = worker.getChestPos();
        return Containers.getFromBlockPos(pos, worker.m_9236_());
    }

    public static Optional<Item> getMainTool(AbstractWorkerEntity worker) {
        if (worker.inventoryInputHelp() == null || worker.inventoryInputHelp().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((Item)worker.inventoryInputHelp().get(0));
    }

    public static Optional<Item> getSecondTool(AbstractWorkerEntity worker) {
        if (worker.inventoryInputHelp() == null || worker.inventoryInputHelp().isEmpty()) {
            return Optional.empty();
        }
        if (worker.inventoryInputHelp().size() < 2) {
            return Optional.empty();
        }
        return Optional.of((Item)worker.inventoryInputHelp().get(1));
    }

    public static List<Need> getNeeds(AbstractWorkerEntity worker) {
        ArrayList<Need> needs = new ArrayList<Need>();
        if (worker.hasAMainTool()) {
            if (!Worker.hasToolInInventory(worker, arg_0 -> ((AbstractWorkerEntity)worker).isRequiredMainTool(arg_0))) {
                Worker.getMainTool(worker).ifPresent(tool -> needs.add(Need.item(tool)));
            }
        }
        if (worker.hasASecondTool()) {
            if (!Worker.hasToolInInventory(worker, arg_0 -> ((AbstractWorkerEntity)worker).isRequiredSecondTool(arg_0))) {
                Worker.getSecondTool(worker).ifPresent(tool -> needs.add(Need.item(tool)));
            }
        }
        AtomicInteger food = new AtomicInteger(Worker.countFoodInContainer((Container)worker.getInventory()));
        Worker.getChestContainer(worker).ifPresent(container -> food.addAndGet(Worker.countFoodInContainer(container)));
        if (food.get() < CommonConfig.workerFoodThreshold) {
            needs.add(Need.food());
        }
        return needs;
    }

    private static boolean hasToolInInventory(AbstractWorkerEntity worker, Predicate<ItemStack> toolMatcher) {
        if (worker.getInventory() == null) {
            return false;
        }
        for (int i = 0; i < worker.getInventory().m_6643_(); ++i) {
            ItemStack stack = worker.getInventory().m_8020_(i);
            if (stack.m_41619_() || !toolMatcher.test(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasEmptyInventorySlot(AbstractWorkerEntity worker) {
        if (worker == null || worker.getInventory() == null) {
            return false;
        }
        for (int i = 0; i < worker.getInventory().m_6643_(); ++i) {
            if (!worker.getInventory().m_8020_(i).m_41619_()) continue;
            return true;
        }
        return false;
    }

    private static int countFoodInContainer(Container container) {
        int food = 0;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_() || !Need.FOOD_MATCHER.test(stack)) continue;
            food += stack.m_41613_();
        }
        return food;
    }
}

