/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.workersplus.utils;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.sosly.workersplus.data.ItemPredicate;

public class Containers {
    public static boolean hasItem(Container container, ItemPredicate predicate) {
        if (container == null) {
            return false;
        }
        for (int i = 0; i < container.m_6643_(); ++i) {
            if (!predicate.matches(container.m_8020_(i))) continue;
            return true;
        }
        return false;
    }

    public static Optional<Container> getFromBlockPos(BlockPos pos, Level level) {
        ChestBlock chestBlock;
        Container chestContainer;
        BlockState state;
        Block block;
        if (pos == null || !level.m_46749_(pos)) {
            return Optional.empty();
        }
        BlockEntity entity = level.m_7702_(pos);
        if (entity instanceof ChestBlockEntity && (block = (state = level.m_8055_(pos)).m_60734_()) instanceof ChestBlock && (chestContainer = ChestBlock.m_51511_((ChestBlock)(chestBlock = (ChestBlock)block), (BlockState)state, (Level)level, (BlockPos)pos, (boolean)true)) != null) {
            return Optional.of(chestContainer);
        }
        if (entity instanceof Container) {
            Container container = (Container)entity;
            return Optional.of(container);
        }
        return Optional.empty();
    }

    public static ItemStack putItem(Container container, ItemStack stack) {
        if (container == null || stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        for (int i = 0; i < container.m_6643_(); ++i) {
            int space;
            ItemStack existingStack = container.m_8020_(i);
            if (existingStack.m_41619_()) {
                int amountToPlace = Math.min(stack.m_41741_(), stack.m_41613_());
                container.m_6836_(i, stack.m_41620_(amountToPlace));
                if (!stack.m_41619_()) continue;
                return ItemStack.f_41583_;
            }
            if (!ItemStack.m_41656_((ItemStack)existingStack, (ItemStack)stack) || (space = Math.min(existingStack.m_41741_() - existingStack.m_41613_(), stack.m_41613_())) <= 0) continue;
            existingStack.m_41769_(space);
            stack.m_41774_(space);
            if (!stack.m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return stack;
    }

    public static ItemStack removeItem(Container container, ItemPredicate predicate, int maxCount) {
        if (container == null) {
            return ItemStack.f_41583_;
        }
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (!predicate.matches(stack)) continue;
            int countToRemove = Math.min(maxCount, stack.m_41613_());
            ItemStack removedStack = stack.m_41620_(countToRemove);
            if (stack.m_41619_()) {
                container.m_6836_(i, ItemStack.f_41583_);
            }
            return removedStack;
        }
        return ItemStack.f_41583_;
    }
}

