/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.workersplus.tasks;

import com.talhanation.workers.entities.AbstractWorkerEntity;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import org.sosly.workersplus.VillageWorkersPlus;
import org.sosly.workersplus.entities.ai.AssessWorkerExcessGoal;
import org.sosly.workersplus.entities.ai.AssessWorkerNeedsGoal;
import org.sosly.workersplus.entities.ai.GetItemsFromContainerGoal;
import org.sosly.workersplus.entities.ai.MoveToDestinationGoal;
import org.sosly.workersplus.entities.ai.PutItemsInContainerGoal;
import org.sosly.workersplus.entities.ai.TargetKnownWorkerGoal;
import org.sosly.workersplus.tasks.AbstractTask;
import org.sosly.workersplus.tasks.TaskCoordinator;
import org.sosly.workersplus.tasks.TaskState;

public class PorterTask
extends AbstractTask<State> {
    private final AbstractWorkerEntity porter;
    private List<?> needs;
    private List<?> excess;
    private AbstractWorkerEntity target;
    private static final String ITEMS = "items";
    private static final String TARGET = "target";

    public PorterTask(AbstractWorkerEntity porter, TaskCoordinator coordinator) {
        super(State.class, coordinator);
        this.porter = porter;
        this.reset();
    }

    @Override
    public void reset() {
        State currentState = this.getCurrentState();
        if (currentState == State.ASSESSING_NEEDS) {
            VillageWorkersPlus.LOGGER.info("No needs found, skipping to GOING_TO_WORKER_CHEST");
            this.skipToState(State.GOING_TO_WORKER_CHEST);
            return;
        }
        if (currentState == State.ASSESSING_EXCESS) {
            VillageWorkersPlus.LOGGER.info("No excess found, skipping to RETURNING_HOME");
            this.skipToState(State.RETURNING_HOME);
            return;
        }
        super.reset();
        this.target = null;
        this.needs = null;
        this.excess = null;
    }

    @Override
    public void setData(String key, Object value) {
        switch (key) {
            case "items": {
                if (!(value instanceof List)) {
                    throw new IllegalArgumentException("items must be a List");
                }
                State currentState = this.getCurrentState();
                if (currentState == State.ASSESSING_NEEDS) {
                    this.needs = (List)value;
                    break;
                }
                if (currentState == State.ASSESSING_EXCESS) {
                    this.excess = (List)value;
                    break;
                }
                throw new IllegalStateException("Cannot set items in state: " + currentState);
            }
            case "target": {
                if (!(value instanceof AbstractWorkerEntity)) {
                    throw new IllegalArgumentException("target must be an AbstractWorkerEntity");
                }
                this.target = (AbstractWorkerEntity)value;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown task data key: " + key);
            }
        }
    }

    @Override
    public Optional<Object> getData(String key) {
        switch (key) {
            case "items": {
                State currentState = this.getCurrentState();
                if (currentState == null) {
                    return Optional.empty();
                }
                return switch (currentState) {
                    case State.COLLECTING_DELIVERY_ITEMS, State.DELIVERING_ITEMS -> {
                        if (this.needs == null) {
                            yield Optional.empty();
                        }
                        yield Optional.of(this.needs);
                    }
                    case State.COLLECTING_EXCESS_ITEMS, State.DEPOSITING_EXCESS -> {
                        if (this.excess == null) {
                            yield Optional.empty();
                        }
                        yield Optional.of(this.excess);
                    }
                    default -> Optional.empty();
                };
            }
            case "target": {
                if (this.target == null) {
                    return Optional.empty();
                }
                return Optional.of(this.target);
            }
        }
        throw new IllegalArgumentException("Unknown task data key: " + key);
    }

    @Override
    public CompoundTag save() {
        CompoundTag nbt = super.save();
        if (this.target != null) {
            nbt.m_128362_(TARGET, this.target.m_20148_());
        }
        return nbt;
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        VillageWorkersPlus.LOGGER.debug("Loading porter task");
        if (tag.m_128441_(TARGET)) {
            this.target = (AbstractWorkerEntity)Objects.requireNonNull(this.porter.m_20194_()).m_129783_().m_8791_(tag.m_128342_(TARGET));
            if (this.target == null) {
                this.reset();
                return;
            }
        }
    }

    private State getCurrentState() {
        if (this.step < 0 || this.step >= State.values().length) {
            return null;
        }
        return State.values()[this.step];
    }

    public static enum State implements TaskState
    {
        SELECTING_WORKER(new TaskState.Step(TargetKnownWorkerGoal.class)),
        NAVIGATING_TO_WORKER(new TaskState.Step(MoveToDestinationGoal.class, t -> State.getTargetAt((PorterTask)t))),
        ASSESSING_NEEDS(new TaskState.Step(AssessWorkerNeedsGoal.class)),
        GOING_TO_OWN_CHEST_FOR_DELIVERY(new TaskState.Step(MoveToDestinationGoal.class, t -> State.getPorterChest((PorterTask)t))),
        COLLECTING_DELIVERY_ITEMS(new TaskState.Step(GetItemsFromContainerGoal.class, t -> State.getPorterChest((PorterTask)t))),
        GOING_TO_WORKER_CHEST_FOR_DELIVERY(new TaskState.Step(MoveToDestinationGoal.class, t -> State.getTargetChest((PorterTask)t))),
        DELIVERING_ITEMS(new TaskState.Step(PutItemsInContainerGoal.class, t -> State.getTargetChest((PorterTask)t))),
        GOING_TO_WORKER_CHEST(new TaskState.Step(MoveToDestinationGoal.class, t -> State.getTargetChest((PorterTask)t))),
        ASSESSING_EXCESS(new TaskState.Step(AssessWorkerExcessGoal.class)),
        COLLECTING_EXCESS_ITEMS(new TaskState.Step(GetItemsFromContainerGoal.class, t -> State.getTargetChest((PorterTask)t))),
        GOING_TO_OWN_CHEST_FOR_DEPOSIT(new TaskState.Step(MoveToDestinationGoal.class, t -> State.getPorterChest((PorterTask)t))),
        DEPOSITING_EXCESS(new TaskState.Step(PutItemsInContainerGoal.class, t -> State.getPorterChest((PorterTask)t))),
        RETURNING_HOME(new TaskState.Step(MoveToDestinationGoal.class, t -> State.getPorterHome((PorterTask)t)));

        private final TaskState.Step step;

        private State(TaskState.Step step) {
            this.step = step;
        }

        @Override
        public TaskState.Step getStep() {
            return this.step;
        }

        private static BlockPos getPorterHome(PorterTask task) {
            AbstractWorkerEntity porter = task.porter;
            if (porter == null) {
                return null;
            }
            return porter.getStartPos();
        }

        private static BlockPos getTargetAt(PorterTask task) {
            AbstractWorkerEntity target = task.target;
            if (target == null) {
                return null;
            }
            return target.m_20183_();
        }

        private static BlockPos getPorterChest(PorterTask task) {
            AbstractWorkerEntity porter = task.porter;
            if (porter == null) {
                return null;
            }
            return porter.getChestPos();
        }

        private static BlockPos getTargetChest(PorterTask task) {
            AbstractWorkerEntity target = task.target;
            if (target == null) {
                return null;
            }
            return target.getChestPos();
        }
    }
}

