/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.workersplus.tasks;

import com.talhanation.workers.entities.AbstractWorkerEntity;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import org.sosly.workersplus.VillageWorkersPlus;
import org.sosly.workersplus.data.Need;
import org.sosly.workersplus.entities.ai.AssessWorkerNeedsGoal;
import org.sosly.workersplus.entities.ai.GetItemsFromContainerGoal;
import org.sosly.workersplus.entities.ai.MoveToDestinationGoal;
import org.sosly.workersplus.entities.ai.PutItemsInContainerGoal;
import org.sosly.workersplus.entities.ai.TargetKnownWorkerGoal;
import org.sosly.workersplus.tasks.AbstractTask;
import org.sosly.workersplus.tasks.TaskCoordinator;
import org.sosly.workersplus.tasks.TaskState;

public class DeliveryTask
extends AbstractTask<State> {
    private final AbstractWorkerEntity deliverer;
    private List<Need> needs;
    private AbstractWorkerEntity target;
    private static final String NEEDS = "items";
    private static final String TARGET = "target";

    public DeliveryTask(AbstractWorkerEntity deliverer, TaskCoordinator coordinator) {
        super(State.class, coordinator);
        this.deliverer = deliverer;
        this.reset();
    }

    @Override
    public void reset() {
        super.reset();
        this.target = null;
    }

    @Override
    public void setData(String key, Object value) {
        switch (key) {
            case "items": {
                if (!(value instanceof List)) {
                    throw new IllegalArgumentException("needs must be a List<Need>");
                }
                List valueList = (List)value;
                if (!valueList.stream().allMatch(Need.class::isInstance)) {
                    throw new IllegalArgumentException("needs must be a List<Need>");
                }
                this.needs = valueList;
                break;
            }
            case "target": {
                if (!(value instanceof AbstractWorkerEntity)) {
                    throw new IllegalArgumentException("target must be an AbstractWorkerEntity");
                }
                this.target = (AbstractWorkerEntity)value;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown task data key: " + key);
            }
        }
    }

    @Override
    public Optional<Object> getData(String key) {
        switch (key) {
            case "items": {
                if (this.needs == null) {
                    return Optional.empty();
                }
                return Optional.of(this.needs);
            }
            case "target": {
                if (this.target == null) {
                    return Optional.empty();
                }
                return Optional.of(this.target);
            }
        }
        throw new IllegalArgumentException("Unknown task data key: " + key);
    }

    @Override
    public CompoundTag save() {
        CompoundTag nbt = super.save();
        if (this.target != null) {
            nbt.m_128362_(TARGET, this.target.m_20148_());
        }
        return nbt;
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        VillageWorkersPlus.LOGGER.debug("Loading delivery task");
        if (tag.m_128441_(TARGET)) {
            this.target = (AbstractWorkerEntity)Objects.requireNonNull(this.deliverer.m_20194_()).m_129783_().m_8791_(tag.m_128342_(TARGET));
            if (this.target == null) {
                this.reset();
                return;
            }
        }
    }

    public static enum State implements TaskState
    {
        SELECTING_WORKER(new TaskState.Step(TargetKnownWorkerGoal.class)),
        NAVIGATING_TO_WORKER(new TaskState.Step(MoveToDestinationGoal.class, t -> State.getTargetAt((DeliveryTask)t))),
        ASSESSING_NEEDS(new TaskState.Step(AssessWorkerNeedsGoal.class)),
        GOING_TO_OWN_CHEST(new TaskState.Step(MoveToDestinationGoal.class, t -> State.getDeliverChest((DeliveryTask)t))),
        COLLECTING_ITEMS(new TaskState.Step(GetItemsFromContainerGoal.class, t -> State.getDeliverChest((DeliveryTask)t))),
        GOING_TO_WORKER_CHEST(new TaskState.Step(MoveToDestinationGoal.class, t -> State.getTargetChest((DeliveryTask)t))),
        DELIVERING_ITEMS(new TaskState.Step(PutItemsInContainerGoal.class, t -> State.getTargetChest((DeliveryTask)t))),
        RETURNING_HOME(new TaskState.Step(MoveToDestinationGoal.class, t -> State.getDelivererHome((DeliveryTask)t)));

        private final TaskState.Step step;

        private State(TaskState.Step step) {
            this.step = step;
        }

        @Override
        public TaskState.Step getStep() {
            return this.step;
        }

        private static BlockPos getDelivererHome(DeliveryTask task) {
            AbstractWorkerEntity deliverer = task.deliverer;
            if (deliverer == null) {
                return null;
            }
            return deliverer.getStartPos();
        }

        private static BlockPos getTargetAt(DeliveryTask task) {
            AbstractWorkerEntity target = task.target;
            if (target == null) {
                return null;
            }
            return target.m_20183_();
        }

        private static BlockPos getDeliverChest(DeliveryTask task) {
            AbstractWorkerEntity deliverer = task.deliverer;
            if (deliverer == null) {
                return null;
            }
            return deliverer.getChestPos();
        }

        private static BlockPos getTargetChest(DeliveryTask task) {
            AbstractWorkerEntity target = task.target;
            if (target == null) {
                return null;
            }
            return target.getChestPos();
        }
    }
}

