/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.workersplus.tasks;

import com.talhanation.workers.entities.AbstractWorkerEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import org.sosly.workersplus.VillageWorkersPlus;
import org.sosly.workersplus.data.Want;
import org.sosly.workersplus.entities.ai.AssessWorkerExcessGoal;
import org.sosly.workersplus.entities.ai.GetItemsFromContainerGoal;
import org.sosly.workersplus.entities.ai.MoveToDestinationGoal;
import org.sosly.workersplus.entities.ai.PutItemsInContainerGoal;
import org.sosly.workersplus.entities.ai.TargetKnownWorkerGoal;
import org.sosly.workersplus.entities.ai.VerifyCollectionGoal;
import org.sosly.workersplus.tasks.AbstractTask;
import org.sosly.workersplus.tasks.TaskCoordinator;
import org.sosly.workersplus.tasks.TaskState;

public class CollectionTask
extends AbstractTask<State> {
    private final AbstractWorkerEntity collector;
    private List<Want> itemsToCollect;
    private AbstractWorkerEntity target;
    private static final String ITEMS = "items";
    private static final String TARGET = "target";

    public CollectionTask(AbstractWorkerEntity collector, TaskCoordinator coordinator) {
        super(State.class, coordinator);
        this.collector = collector;
        this.reset();
    }

    @Override
    public void reset() {
        super.reset();
        this.target = null;
        this.itemsToCollect = new ArrayList<Want>();
    }

    @Override
    public void setData(String key, Object value) {
        switch (key) {
            case "items": {
                if (!(value instanceof List)) {
                    throw new IllegalArgumentException("items must be a List<Want>");
                }
                List valueList = (List)value;
                if (!valueList.stream().allMatch(Want.class::isInstance)) {
                    throw new IllegalArgumentException("items must be a List<Want>");
                }
                this.itemsToCollect = new ArrayList<Want>(valueList);
                break;
            }
            case "target": {
                if (!(value instanceof AbstractWorkerEntity)) {
                    throw new IllegalArgumentException("target must be an AbstractWorkerEntity");
                }
                this.target = (AbstractWorkerEntity)value;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown task data key: " + key);
            }
        }
    }

    @Override
    public Optional<Object> getData(String key) {
        switch (key) {
            case "items": {
                if (this.itemsToCollect == null) {
                    return Optional.empty();
                }
                return Optional.of(this.itemsToCollect);
            }
            case "target": {
                if (this.target == null) {
                    return Optional.empty();
                }
                return Optional.of(this.target);
            }
        }
        throw new IllegalArgumentException("Unknown task data key: " + key);
    }

    @Override
    public CompoundTag save() {
        CompoundTag nbt = super.save();
        if (this.target != null) {
            nbt.m_128362_(TARGET, this.target.m_20148_());
        }
        return nbt;
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        VillageWorkersPlus.LOGGER.debug("Loading collection task");
        if (tag.m_128441_(TARGET)) {
            this.target = (AbstractWorkerEntity)Objects.requireNonNull(this.collector.m_20194_()).m_129783_().m_8791_(tag.m_128342_(TARGET));
            if (this.target == null) {
                this.reset();
                return;
            }
        }
    }

    public static enum State implements TaskState
    {
        FINDING_WORKERS(new TaskState.Step(TargetKnownWorkerGoal.class)),
        GOING_TO_WORKER(new TaskState.Step(MoveToDestinationGoal.class, t -> State.getTargetChest((CollectionTask)t))),
        ASSESSING_EXCESS(new TaskState.Step(AssessWorkerExcessGoal.class)),
        COLLECTING_ITEMS(new TaskState.Step(GetItemsFromContainerGoal.class, t -> State.getTargetChest((CollectionTask)t))),
        VERIFY_COLLECTION(new TaskState.Step(VerifyCollectionGoal.class)),
        GOING_TO_CHEST(new TaskState.Step(MoveToDestinationGoal.class, t -> State.getCollectorChest((CollectionTask)t))),
        DEPOSITING_ITEMS(new TaskState.Step(PutItemsInContainerGoal.class, t -> State.getCollectorChest((CollectionTask)t))),
        GOING_HOME(new TaskState.Step(MoveToDestinationGoal.class, t -> State.getCollectorHome((CollectionTask)t)));

        private final TaskState.Step step;

        private State(TaskState.Step step) {
            this.step = step;
        }

        @Override
        public TaskState.Step getStep() {
            return this.step;
        }

        private static BlockPos getCollectorHome(CollectionTask task) {
            AbstractWorkerEntity collector = task.collector;
            if (collector == null) {
                return null;
            }
            return collector.getStartPos();
        }

        private static BlockPos getCollectorChest(CollectionTask task) {
            AbstractWorkerEntity collector = task.collector;
            if (collector == null) {
                return null;
            }
            return collector.getChestPos();
        }

        private static BlockPos getTargetChest(CollectionTask task) {
            AbstractWorkerEntity target = task.target;
            if (target == null) {
                return null;
            }
            return target.getChestPos();
        }
    }
}

