/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.workersplus.tasks;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.ai.goal.Goal;
import org.sosly.workersplus.VillageWorkersPlus;
import org.sosly.workersplus.tasks.TaskCoordinator;
import org.sosly.workersplus.tasks.TaskState;

public abstract class AbstractTask<S extends Enum<S>> {
    private final S[] states;
    protected int step = -1;
    protected long stateStartTime;
    protected long taskStartTime;
    private final TaskCoordinator coordinator;
    private final String CURRENT_STEP = "CurrentStep";
    private final String STATE_START_TIME = "StateStartTime";
    private final String TASK_START_TIME = "TaskStartTime";

    public AbstractTask(Class<S> stateClass, TaskCoordinator coordinator) {
        this.states = (Enum[])stateClass.getEnumConstants();
        this.coordinator = coordinator;
    }

    public void next() {
        ++this.step;
        this.stateStartTime = System.currentTimeMillis();
        if (this.complete()) {
            this.reset();
        }
    }

    public void previous() {
        --this.step;
        this.stateStartTime = System.currentTimeMillis();
    }

    protected void skipToStep(int targetStep) {
        if (targetStep >= 0 && targetStep < this.states.length) {
            this.step = targetStep;
            this.stateStartTime = System.currentTimeMillis();
        }
    }

    protected <S extends Enum<S>> void skipToState(S targetState) {
        S[] allStates = this.states;
        for (int i = 0; i < allStates.length; ++i) {
            if (allStates[i] != targetState) continue;
            this.skipToStep(i);
            break;
        }
    }

    @Nullable
    public TaskState.Step current() {
        if (this.step < 0 || this.step >= this.states.length) {
            return null;
        }
        return ((TaskState)this.states[this.step]).getStep();
    }

    public boolean isCurrentStep(Goal goal) {
        if (this.step < 0 || this.step >= this.states.length) {
            return false;
        }
        return Objects.requireNonNull(this.current()).isGoal(goal);
    }

    public boolean complete() {
        return this.step >= this.states.length;
    }

    public <T> T currentData(Class<T> type) {
        return Objects.requireNonNull(this.current()).getData(this, type);
    }

    public boolean canStart() {
        return this.coordinator == null || this.coordinator.canStartTask(this);
    }

    public void start() {
        if (!this.canStart()) {
            VillageWorkersPlus.LOGGER.debug("Task {} blocked from starting - another task is active: {}", (Object)this.getClass().getSimpleName(), (Object)(this.coordinator.getActiveTask() != null ? this.coordinator.getActiveTask().getClass().getSimpleName() : "null"));
            return;
        }
        if (this.coordinator != null) {
            this.coordinator.setActiveTask(this);
        }
        this.stateStartTime = this.taskStartTime = System.currentTimeMillis();
        this.step = 0;
    }

    public boolean isActive() {
        return this.step >= 0 && this.step < this.states.length;
    }

    public long getStateStartTime() {
        return this.stateStartTime;
    }

    public long getTimeInState() {
        long currentTime = System.currentTimeMillis();
        return this.stateStartTime > 0L ? currentTime - this.stateStartTime : 0L;
    }

    public long getTotalTime() {
        long currentTime = System.currentTimeMillis();
        return this.taskStartTime > 0L ? currentTime - this.taskStartTime : 0L;
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("CurrentStep", this.step);
        tag.m_128356_("StateStartTime", this.stateStartTime);
        tag.m_128356_("TaskStartTime", this.taskStartTime);
        return tag;
    }

    public void load(CompoundTag tag) {
        this.step = tag.m_128441_("CurrentStep") ? tag.m_128451_("CurrentStep") : -1;
        this.stateStartTime = tag.m_128454_("StateStartTime");
        this.taskStartTime = tag.m_128454_("TaskStartTime");
    }

    public void reset() {
        if (this.coordinator != null) {
            this.coordinator.clearActiveTask(this);
        }
        this.step = -1;
        this.stateStartTime = 0L;
        this.taskStartTime = 0L;
    }

    public abstract void setData(String var1, Object var2);

    public abstract Optional<Object> getData(String var1);
}

