/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.workersplus.networking;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.sosly.workersplus.VillageWorkersPlus;
import org.sosly.workersplus.networking.Message;
import org.sosly.workersplus.networking.clientbound.UpdateHireScreen;
import org.sosly.workersplus.networking.serverbound.OpenHireGUI;
import org.sosly.workersplus.networking.serverbound.OpenWorkerGUI;

@Mod.EventBusSubscriber(modid="workersplus", bus=Mod.EventBusSubscriber.Bus.MOD)
public class PacketHandler {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel network = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("workersplus", "main"), () -> "1", "1"::equals, "1"::equals);

    @SubscribeEvent
    public static void registerMessages(FMLCommonSetupEvent event) {
        int packetId = 0;
        PacketHandler.registerMessage(packetId++, OpenHireGUI.class);
        PacketHandler.registerMessage(packetId++, OpenWorkerGUI.class);
        PacketHandler.registerMessage(packetId++, UpdateHireScreen.class);
    }

    private static <T extends Message<T>> void registerMessage(int id, Class<T> message) {
        network.registerMessage(id, message, Message::toBytes, buf -> {
            try {
                Message msg = (Message)message.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                return msg.fromBytes((FriendlyByteBuf)buf);
            }
            catch (Exception e) {
                VillageWorkersPlus.LOGGER.error("Failed to create message instance for {}", (Object)message.getSimpleName(), (Object)e);
                throw new RuntimeException(e);
            }
        }, (msg, contextSupplier) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)contextSupplier.get();
            if (msg.isValid(context)) {
                msg.execute(context);
            }
        });
    }
}

