/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.workersplus.gui;

import com.talhanation.workers.entities.AbstractWorkerEntity;
import java.util.UUID;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.sosly.workersplus.gui.containers.HireContainer;
import org.sosly.workersplus.gui.containers.WorkerContainer;
import org.sosly.workersplus.gui.screens.HireScreen;
import org.sosly.workersplus.gui.screens.WorkerScreen;

public class Menus {
    public static final DeferredRegister<MenuType<?>> MENUS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"workersplus");
    public static final RegistryObject<MenuType<HireContainer>> HIRE_GUI = MENUS.register("hire_container", () -> IForgeMenuType.create((id, inv, data) -> {
        UUID workerID = data.m_130259_();
        AbstractWorkerEntity worker = Menus.getWorkerByUUID(inv.f_35978_, workerID);
        if (worker == null) {
            return null;
        }
        return new HireContainer(id, inv.f_35978_, worker, inv);
    }));
    public static final RegistryObject<MenuType<WorkerContainer>> WORKER_GUI = MENUS.register("worker_container", () -> IForgeMenuType.create((id, inv, data) -> {
        UUID workerID = data.m_130259_();
        AbstractWorkerEntity worker = Menus.getWorkerByUUID(inv.f_35978_, workerID);
        if (worker == null) {
            return null;
        }
        return new WorkerContainer(id, worker, inv);
    }));

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void register(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            MenuScreens.m_96206_((MenuType)((MenuType)HIRE_GUI.get()), HireScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)WORKER_GUI.get()), WorkerScreen::new);
        });
    }

    private static AbstractWorkerEntity getWorkerByUUID(Player player, UUID uuid) {
        double distance = 10.0;
        return player.m_20193_().m_6443_(AbstractWorkerEntity.class, new AABB(player.m_20185_() - distance, player.m_20186_() - distance, player.m_20189_() - distance, player.m_20185_() + distance, player.m_20186_() + distance, player.m_20189_() + distance), entity -> entity.m_20148_().equals(uuid)).stream().findAny().orElse(null);
    }
}

