/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.workersplus.entities.workers;

import com.talhanation.workers.CommandEvents;
import com.talhanation.workers.entities.AbstractWorkerEntity;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.sosly.workersplus.VillageWorkersPlus;
import org.sosly.workersplus.config.CommonConfig;
import org.sosly.workersplus.data.WorkerRelationships;
import org.sosly.workersplus.entities.ai.AssessWorkerExcessGoal;
import org.sosly.workersplus.entities.ai.AssessWorkerNeedsGoal;
import org.sosly.workersplus.entities.ai.EndTaskGoal;
import org.sosly.workersplus.entities.ai.GetItemsFromContainerGoal;
import org.sosly.workersplus.entities.ai.MeetNewWorkerGoal;
import org.sosly.workersplus.entities.ai.MoveToDestinationGoal;
import org.sosly.workersplus.entities.ai.PutItemsInContainerGoal;
import org.sosly.workersplus.entities.ai.ReturnToHomeGoal;
import org.sosly.workersplus.entities.ai.StartTaskGoal;
import org.sosly.workersplus.entities.ai.TargetKnownWorkerGoal;
import org.sosly.workersplus.gui.providers.HireProvider;
import org.sosly.workersplus.gui.providers.WorkerProvider;
import org.sosly.workersplus.networking.PacketHandler;
import org.sosly.workersplus.networking.clientbound.UpdateHireScreen;
import org.sosly.workersplus.networking.serverbound.OpenHireGUI;
import org.sosly.workersplus.networking.serverbound.OpenWorkerGUI;
import org.sosly.workersplus.tasks.PorterTask;
import org.sosly.workersplus.tasks.TaskCoordinator;

public class Porter
extends AbstractWorkerEntity {
    private WorkerRelationships relationships;
    private PorterTask porterTask;
    private TaskCoordinator taskCoordinator;

    public Porter(EntityType<? extends AbstractWorkerEntity> entityType, Level world) {
        super(entityType, world);
        this.setProfessionName("Porter");
        this.cost = CommonConfig.porterCost;
    }

    public void m_7380_(@NotNull CompoundTag nbt) {
        super.m_7380_(nbt);
        CompoundTag relationships = this.relationships.save();
        nbt.m_128365_("relationships", (Tag)relationships);
        CompoundTag porterData = this.porterTask.save();
        nbt.m_128365_("porter", (Tag)porterData);
    }

    public void m_7378_(@NotNull CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_("relationships")) {
            CompoundTag relationships = nbt.m_128469_("relationships");
            this.relationships.load(relationships);
        }
        if (nbt.m_128441_("porter")) {
            CompoundTag porterData = nbt.m_128469_("porter");
            this.porterTask.load(porterData);
        }
    }

    public boolean canWorkWithoutTool() {
        return true;
    }

    protected void registerDependencies() {
        if (this.taskCoordinator == null) {
            this.taskCoordinator = new TaskCoordinator();
        }
        if (this.porterTask == null) {
            this.porterTask = new PorterTask(this, this.taskCoordinator);
        }
        if (this.relationships == null) {
            this.relationships = new WorkerRelationships();
        }
    }

    protected void m_8099_() {
        super.m_8099_();
        this.registerDependencies();
        this.f_21345_.m_25352_(10, (Goal)new StartTaskGoal(this, this.porterTask));
        this.f_21345_.m_25352_(5, (Goal)new PutItemsInContainerGoal(this, this.porterTask));
        this.f_21345_.m_25352_(5, (Goal)new GetItemsFromContainerGoal(this, this.porterTask));
        this.f_21345_.m_25352_(5, (Goal)new MoveToDestinationGoal((AbstractWorkerEntity)this, this.porterTask, 2.5));
        this.f_21345_.m_25352_(5, (Goal)new AssessWorkerNeedsGoal(this, this.porterTask));
        this.f_21345_.m_25352_(5, (Goal)new AssessWorkerExcessGoal(this, this.porterTask));
        this.f_21345_.m_25352_(5, (Goal)new TargetKnownWorkerGoal(this, this.porterTask, this.relationships));
        this.f_21345_.m_25352_(10, (Goal)new EndTaskGoal(this.porterTask));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.3));
        this.f_21345_.m_25352_(30, (Goal)new ReturnToHomeGoal(this));
        this.f_21345_.m_25352_(35, (Goal)new MeetNewWorkerGoal(this, this.relationships));
        this.f_21345_.m_25352_(40, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.65, 300));
    }

    public boolean isRequiredMainTool(ItemStack tool) {
        return false;
    }

    public boolean isRequiredSecondTool(ItemStack tool) {
        return false;
    }

    public List<Item> inventoryInputHelp() {
        return null;
    }

    public boolean hasAMainTool() {
        return false;
    }

    public boolean hasASecondTool() {
        return false;
    }

    public Predicate<ItemEntity> getAllowedItems() {
        return null;
    }

    public void openHireGUI(Player player) {
        this.f_21344_.m_26573_();
        if (!(player instanceof ServerPlayer)) {
            PacketHandler.network.sendToServer((Object)new OpenHireGUI(player, this.m_20148_()));
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        PacketHandler.network.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new UpdateHireScreen(CommandEvents.getWorkersCurrency(), this.getWorkerCost()));
        Consumer<FriendlyByteBuf> extraDataWriter = packetBuffer -> packetBuffer.m_130077_(this.m_20148_());
        NetworkHooks.openScreen((ServerPlayer)serverPlayer, new HireProvider<Porter>(this), extraDataWriter);
    }

    public void openGUI(Player player) {
        if (!(player instanceof ServerPlayer)) {
            VillageWorkersPlus.LOGGER.info("Porter inventory GUI opened on client side, sending to server.");
            PacketHandler.network.sendToServer((Object)new OpenWorkerGUI(player, this.m_20148_()));
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        Consumer<FriendlyByteBuf> extraDataWriter = packetBuffer -> packetBuffer.m_130077_(this.m_20148_());
        NetworkHooks.openScreen((ServerPlayer)serverPlayer, new WorkerProvider<Porter>(this), extraDataWriter);
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel level, @NotNull AgeableMob mob) {
        return null;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return AbstractWorkerEntity.m_21183_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22277_, 16.0);
    }
}

