/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.workersplus.entities.ai;

import com.talhanation.workers.entities.AbstractWorkerEntity;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import org.sosly.workersplus.VillageWorkersPlus;
import org.sosly.workersplus.data.Want;
import org.sosly.workersplus.entities.ai.AbstractTaskGoal;
import org.sosly.workersplus.tasks.AbstractTask;
import org.sosly.workersplus.utils.Worker;

public class VerifyCollectionGoal
extends AbstractTaskGoal {
    private final AbstractWorkerEntity collector;
    private static final int MAX_RETRIES = 3;
    private int retryCount = 0;

    public VerifyCollectionGoal(AbstractWorkerEntity collector, AbstractTask<?> task) {
        super(task);
        this.collector = collector;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!Worker.canWork(this.collector) || !this.getTask().isCurrentStep(this)) {
            return false;
        }
        if (this.isStuckInCurrentStep()) {
            VillageWorkersPlus.LOGGER.warn("Worker {} is stuck in VerifyCollectionGoal, resetting task.", (Object)this.collector.m_20148_());
            this.getTask().reset();
            return false;
        }
        return this.getTaskItems().isPresent();
    }

    public boolean m_8045_() {
        return false;
    }

    public void m_8056_() {
        boolean hasMissingItems;
        Optional taskItemsOpt = this.getTaskItems();
        if (taskItemsOpt.isEmpty()) {
            this.getTask().reset();
            return;
        }
        List taskItems = (List)taskItemsOpt.get();
        if (taskItems.isEmpty()) {
            this.getTask().next();
            return;
        }
        List<Want> originalWants = this.extractWants(taskItems);
        if (originalWants.isEmpty()) {
            this.getTask().next();
            return;
        }
        ArrayList<Want> collectedItems = new ArrayList<Want>();
        ArrayList<Want> missingItems = new ArrayList<Want>();
        this.categorizeItems(originalWants, collectedItems, missingItems);
        if (collectedItems.isEmpty()) {
            VillageWorkersPlus.LOGGER.warn("Collection failed - no items collected");
            this.getTask().reset();
            return;
        }
        boolean hasSpace = Worker.hasEmptyInventorySlot(this.collector);
        boolean bl = hasMissingItems = !missingItems.isEmpty();
        if (hasMissingItems && hasSpace && this.retryCount < 3) {
            ++this.retryCount;
            this.getTask().setData("items", missingItems);
            VillageWorkersPlus.LOGGER.debug("Retrying collection - {} items missing, attempt {}/{}", (Object)missingItems.size(), (Object)this.retryCount, (Object)3);
            this.getTask().previous();
            return;
        }
        this.retryCount = 0;
        this.getTask().setData("items", collectedItems);
        if (hasMissingItems) {
            VillageWorkersPlus.LOGGER.debug("Partial collection - got {} of {} items", (Object)collectedItems.size(), (Object)originalWants.size());
        }
        this.getTask().next();
    }

    private List<Want> extractWants(List<?> taskItems) {
        ArrayList<Want> wants = new ArrayList<Want>();
        for (Object item : taskItems) {
            if (!(item instanceof Want)) continue;
            Want want = (Want)item;
            wants.add(want);
        }
        return wants;
    }

    private void categorizeItems(List<Want> originalWants, List<Want> collectedItems, List<Want> missingItems) {
        for (Want want : originalWants) {
            ItemStack representativeStack;
            int collectedAmount = this.countInInventory(want);
            if (collectedAmount > 0 && (representativeStack = this.findRepresentativeStack(want)) != null) {
                ItemStack collectedStack = representativeStack.m_41777_();
                collectedStack.m_41764_(Math.min(collectedAmount, want.getAmount()));
                collectedItems.add(new Want(collectedStack));
            }
            if (collectedAmount >= want.getAmount()) continue;
            int remaining = want.getAmount() - collectedAmount;
            missingItems.add(new Want(want::matches, remaining, want.getName()));
        }
    }

    private int countInInventory(Want want) {
        int count = 0;
        for (int i = 0; i < this.collector.getInventory().m_6643_(); ++i) {
            ItemStack stack = this.collector.getInventory().m_8020_(i);
            if (stack.m_41619_() || !want.matches(stack)) continue;
            count += stack.m_41613_();
        }
        return count;
    }

    private ItemStack findRepresentativeStack(Want want) {
        for (int i = 0; i < this.collector.getInventory().m_6643_(); ++i) {
            ItemStack stack = this.collector.getInventory().m_8020_(i);
            if (stack.m_41619_() || !want.matches(stack)) continue;
            return stack;
        }
        return null;
    }

    public boolean m_6767_() {
        return false;
    }
}

