/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.workersplus.entities.ai;

import com.talhanation.workers.entities.AbstractWorkerEntity;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import org.sosly.workersplus.VillageWorkersPlus;
import org.sosly.workersplus.config.CommonConfig;
import org.sosly.workersplus.data.WorkerInfo;
import org.sosly.workersplus.data.WorkerRelationships;
import org.sosly.workersplus.entities.ai.AbstractTaskGoal;
import org.sosly.workersplus.tasks.AbstractTask;
import org.sosly.workersplus.utils.Chat;
import org.sosly.workersplus.utils.Worker;

public class TargetKnownWorkerGoal
extends AbstractTaskGoal {
    private final WorkerRelationships relationships;
    private final AbstractWorkerEntity worker;
    private final boolean useRecencyCheck;
    private final Map<UUID, Long> lastSelectTimes = new HashMap<UUID, Long>();
    private static final long RECENCY_THRESHOLD = 1200L;
    private AbstractWorkerEntity selectedTarget = null;

    public TargetKnownWorkerGoal(AbstractWorkerEntity worker, AbstractTask<?> task, WorkerRelationships relationships) {
        this(worker, task, relationships, true);
    }

    public TargetKnownWorkerGoal(AbstractWorkerEntity worker, AbstractTask<?> task, WorkerRelationships relationships, boolean useRecencyCheck) {
        super(task);
        this.relationships = relationships;
        this.worker = worker;
        this.useRecencyCheck = useRecencyCheck;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!Worker.canWork(this.worker)) {
            return false;
        }
        if (this.isStuckInCurrentStep()) {
            VillageWorkersPlus.LOGGER.warn("Worker {} is stuck in TargetKnownWorkerGoal, resetting task.", (Object)this.worker.m_20148_());
            this.getTask().reset();
            return false;
        }
        if (!this.getTask().isCurrentStep(this)) {
            return false;
        }
        if (this.relationships.getRelationships().isEmpty()) {
            this.getTask().reset();
            return false;
        }
        this.selectedTarget = this.findValidTarget();
        if (this.selectedTarget == null) {
            this.getTask().reset();
            return false;
        }
        return true;
    }

    public void m_8056_() {
        if (this.selectedTarget == null) {
            this.getTask().reset();
            return;
        }
        if (this.useRecencyCheck) {
            this.lastSelectTimes.put(this.selectedTarget.m_20148_(), this.worker.m_9236_().m_46467_());
        }
        this.getTask().setData("target", this.selectedTarget);
        Chat.send(this.worker, (Component)Component.m_237110_((String)"chat.workersplus.selecting_worker.success", (Object[])new Object[]{this.selectedTarget.m_7755_()}));
        this.getTask().next();
        this.selectedTarget = null;
    }

    private AbstractWorkerEntity findValidTarget() {
        long currentTime = this.worker.m_9236_().m_46467_();
        List candidates = this.relationships.getRelationships().keySet().stream().filter(uuid -> !uuid.equals(this.worker.m_20148_())).filter(uuid -> !this.useRecencyCheck || !this.isRecentlySelected((UUID)uuid, currentTime)).collect(Collectors.toList());
        if (candidates.isEmpty()) {
            return null;
        }
        UUID selectedId = (UUID)candidates.get(this.worker.m_217043_().m_188503_(candidates.size()));
        AbstractWorkerEntity entity = (AbstractWorkerEntity)this.worker.m_20194_().m_129783_().m_8791_(selectedId);
        if (entity == null || !entity.m_6084_()) {
            WorkerInfo forgottenWorker = this.relationships.getRelationships().get(selectedId);
            if (forgottenWorker != null) {
                Chat.send(this.worker, (Component)Component.m_237110_((String)"chat.workersplus.selecting_worker.failure", (Object[])new Object[]{forgottenWorker.getName()}));
                this.relationships.removeKnown(selectedId);
            }
            return null;
        }
        if (this.worker.m_20280_((Entity)entity) > (double)(CommonConfig.workerDetectionRadius * CommonConfig.workerDetectionRadius)) {
            return null;
        }
        return entity;
    }

    private boolean isRecentlySelected(UUID workerId, long currentTime) {
        Long lastVisit = this.lastSelectTimes.get(workerId);
        return lastVisit != null && currentTime - lastVisit < 1200L;
    }

    public boolean m_8045_() {
        return false;
    }
}

