/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.workersplus.entities.ai;

import com.talhanation.workers.entities.AbstractWorkerEntity;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import org.sosly.workersplus.VillageWorkersPlus;
import org.sosly.workersplus.config.CommonConfig;
import org.sosly.workersplus.data.ItemPredicate;
import org.sosly.workersplus.entities.ai.AbstractTaskGoal;
import org.sosly.workersplus.tasks.AbstractTask;
import org.sosly.workersplus.utils.Chat;
import org.sosly.workersplus.utils.Containers;
import org.sosly.workersplus.utils.Worker;

public class PutItemsInContainerGoal
extends AbstractTaskGoal {
    private AbstractWorkerEntity worker;
    private BlockPos pos;
    private List<ItemPredicate> items;
    private int lastTicked = 0;
    private int currentNeedIndex = 0;
    private boolean[] attemptedNeeds;

    public PutItemsInContainerGoal(AbstractWorkerEntity worker, AbstractTask<?> task) {
        super(task);
        this.worker = worker;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
    }

    public PutItemsInContainerGoal(AbstractWorkerEntity worker, List<ItemPredicate> items, BlockPos pos) {
        super(null);
        this.worker = worker;
        this.items = items;
        this.pos = pos;
    }

    public boolean m_8036_() {
        if (!Worker.canWork(this.worker)) {
            return false;
        }
        if (this.task != null && !this.canUseTask()) {
            return false;
        }
        if (this.pos == null || this.items == null) {
            return false;
        }
        return this.pos.m_203195_((Position)this.worker.m_20182_(), CommonConfig.containerReachDistance);
    }

    public boolean m_8045_() {
        if (this.allNeedsAttempted()) {
            return false;
        }
        return this.m_8036_();
    }

    public boolean m_6767_() {
        return false;
    }

    public void m_8056_() {
        this.currentNeedIndex = 0;
        this.attemptedNeeds = new boolean[this.items.size()];
        LivingEntity livingEntity = this.worker.m_269323_();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        BlockEntity be = this.worker.m_9236_().m_7702_(this.pos);
        if (be instanceof ChestBlockEntity) {
            ChestBlockEntity chest = (ChestBlockEntity)be;
            chest.m_5856_(player);
        }
    }

    public void m_8041_() {
        if (this.task != null) {
            this.getTask().next();
        }
        BlockEntity be = this.worker.m_9236_().m_7702_(this.pos);
        this.currentNeedIndex = 0;
        this.attemptedNeeds = null;
        this.items = null;
        this.pos = null;
        LivingEntity livingEntity = this.worker.m_269323_();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (be instanceof ChestBlockEntity) {
            ChestBlockEntity chest = (ChestBlockEntity)be;
            chest.m_5785_(player);
        }
    }

    public void m_8037_() {
        if (this.worker.m_9236_().m_46467_() - (long)this.lastTicked < 20L) {
            return;
        }
        this.lastTicked = (int)this.worker.m_9236_().m_46467_();
        Container chest = Containers.getFromBlockPos(this.pos, this.worker.m_9236_()).orElse(null);
        if (chest == null) {
            return;
        }
        if (this.currentNeedIndex >= this.items.size()) {
            return;
        }
        if (this.attemptedNeeds[this.currentNeedIndex]) {
            ++this.currentNeedIndex;
            return;
        }
        ItemPredicate need = this.items.get(this.currentNeedIndex);
        ItemStack toDeposit = Containers.removeItem((Container)this.worker.getInventory(), need, need.getAmount());
        if (toDeposit.m_41619_()) {
            this.attemptedNeeds[this.currentNeedIndex] = true;
            ++this.currentNeedIndex;
            return;
        }
        ItemStack depositing = toDeposit.m_41777_();
        ItemStack remainder = Containers.putItem(chest, toDeposit);
        int placed = depositing.m_41613_() - remainder.m_41613_();
        if (!remainder.m_41619_() && !(remainder = this.worker.getInventory().m_19173_(remainder)).m_41619_()) {
            VillageWorkersPlus.LOGGER.error("Failed to put back remainder in worker inventory: {}", (Object)remainder);
        }
        if (placed > 0) {
            Chat.send(this.worker, (Component)Component.m_237110_((String)"chat.workersplus.put_items_in_container.success", (Object[])new Object[]{placed, depositing.m_41611_()}));
        }
    }

    private boolean canUseTask() {
        if (!this.getTask().isCurrentStep(this)) {
            return false;
        }
        if (this.isStuckInCurrentStep()) {
            VillageWorkersPlus.LOGGER.warn("Worker {} is stuck in PutItemsInContainerGoal, resetting task.", (Object)this.worker.m_20148_());
            this.getTask().reset();
            return false;
        }
        if (this.pos == null) {
            this.pos = this.getTask().currentData(BlockPos.class);
        }
        if (this.items == null && this.getTaskItems().isPresent()) {
            this.items = (List)this.getTaskItems().get();
        }
        return true;
    }

    private boolean allNeedsAttempted() {
        if (this.attemptedNeeds == null) {
            return true;
        }
        for (boolean attempted : this.attemptedNeeds) {
            if (attempted) continue;
            return false;
        }
        return true;
    }
}

