/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.workersplus.entities.ai;

import com.talhanation.workers.entities.AbstractWorkerEntity;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.ai.goal.Goal;
import org.sosly.workersplus.VillageWorkersPlus;
import org.sosly.workersplus.entities.ai.AbstractTaskGoal;
import org.sosly.workersplus.tasks.AbstractTask;
import org.sosly.workersplus.utils.Worker;

public class MoveToDestinationGoal
extends AbstractTaskGoal {
    private final AbstractWorkerEntity worker;
    private final double distanceThreshold;
    private BlockPos destination;

    public MoveToDestinationGoal(AbstractWorkerEntity worker, AbstractTask<?> task, double distanceThreshold) {
        super(task);
        this.worker = worker;
        this.distanceThreshold = distanceThreshold;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public MoveToDestinationGoal(AbstractWorkerEntity worker, double distanceThreshold, BlockPos destination) {
        super(null);
        this.worker = worker;
        this.destination = destination;
        this.distanceThreshold = distanceThreshold;
    }

    public boolean m_8036_() {
        if (!Worker.canWork(this.worker)) {
            return false;
        }
        if (this.task != null && !this.canUseTask()) {
            return false;
        }
        if (this.destination == null) {
            return false;
        }
        return !this.destination.m_203195_((Position)this.worker.m_20182_(), this.distanceThreshold);
    }

    public boolean m_8045_() {
        return this.m_8036_();
    }

    public void m_8037_() {
        this.worker.m_21573_().m_26519_((double)this.destination.m_123341_(), (double)this.destination.m_123342_(), (double)this.destination.m_123343_(), 1.0);
    }

    public void m_8041_() {
        if (this.task != null) {
            this.getTask().next();
        }
        this.destination = null;
        this.worker.m_21573_().m_26573_();
    }

    private boolean canUseTask() {
        if (!this.getTask().isCurrentStep(this)) {
            return false;
        }
        if (this.isStuckInCurrentStep()) {
            VillageWorkersPlus.LOGGER.warn("Worker {} is stuck in MoveToDestinationGoal, resetting task.", (Object)this.worker.m_20148_());
            this.getTask().reset();
            return false;
        }
        BlockPos destination = this.getTask().currentData(BlockPos.class);
        if (destination == null) {
            return false;
        }
        this.destination = destination;
        return true;
    }
}

