/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.workersplus.entities.ai;

import com.talhanation.workers.entities.AbstractWorkerEntity;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import org.sosly.workersplus.config.CommonConfig;
import org.sosly.workersplus.data.WorkerInfo;
import org.sosly.workersplus.data.WorkerRelationships;
import org.sosly.workersplus.utils.Chat;
import org.sosly.workersplus.utils.Worker;

public class MeetNewWorkerGoal
extends Goal {
    private final WorkerRelationships relationships;
    private final AbstractWorkerEntity worker;
    private long introductionStartTime = 0L;
    private long lastScanTime = 0L;
    private boolean isIntroducing;
    private boolean isMovingToTarget;

    public MeetNewWorkerGoal(AbstractWorkerEntity worker, WorkerRelationships relationships) {
        this.worker = worker;
        this.relationships = relationships;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (!Worker.canWork(this.worker)) {
            return false;
        }
        long currentTime = this.worker.m_9236_().m_46467_();
        if (currentTime - this.lastScanTime < 100L) {
            return false;
        }
        this.lastScanTime = currentTime;
        return true;
    }

    public boolean m_6767_() {
        return false;
    }

    public boolean m_8045_() {
        if (!Worker.canWork(this.worker)) {
            return false;
        }
        if (this.worker.m_5448_() == null || !this.worker.m_5448_().m_6084_()) {
            return false;
        }
        if (!this.isIntroducing && !this.isMovingToTarget) {
            return false;
        }
        if (this.isMovingToTarget) {
            return true;
        }
        long currentTime = this.worker.m_9236_().m_46467_();
        return currentTime - this.introductionStartTime <= (long)CommonConfig.workerMeetingDuration;
    }

    public void m_8056_() {
        AbstractWorkerEntity targetWorker = this.findUnknownWorker();
        if (targetWorker == null) {
            return;
        }
        this.isMovingToTarget = true;
        this.worker.m_6710_((LivingEntity)targetWorker);
        Chat.send(this.worker, (Component)Component.m_237115_((String)"chat.workersplus.meet_new_worker.start"));
    }

    public void m_8037_() {
        if (!this.isIntroducing && !this.isMovingToTarget) {
            return;
        }
        LivingEntity target = this.worker.m_5448_();
        if (!(target instanceof AbstractWorkerEntity)) {
            return;
        }
        if (!this.worker.m_20182_().m_82509_((Position)target.m_20182_(), (double)CommonConfig.workerChatRadius)) {
            this.worker.m_21573_().m_5624_((Entity)target, 1.0);
            return;
        }
        if (!this.isIntroducing) {
            this.isIntroducing = true;
            this.isMovingToTarget = false;
            this.introductionStartTime = this.worker.m_9236_().m_46467_();
        }
    }

    public void m_8041_() {
        if (!this.isIntroducing) {
            this.isMovingToTarget = false;
            return;
        }
        LivingEntity target = this.worker.m_5448_();
        if (target == null || !(target instanceof AbstractWorkerEntity)) {
            return;
        }
        AbstractWorkerEntity targetWorker = (AbstractWorkerEntity)target;
        UUID targetUUID = targetWorker.m_20148_();
        Component name = targetWorker.m_7755_();
        BlockPos targetPos = targetWorker.m_20183_();
        WorkerInfo workerInfo = new WorkerInfo(targetUUID, name, targetPos);
        this.relationships.addKnown(targetUUID, workerInfo);
        Chat.send(this.worker, (Component)Component.m_237110_((String)"chat.workersplus.meet_new_worker.end", (Object[])new Object[]{name}));
        this.isIntroducing = false;
        this.isMovingToTarget = false;
    }

    private AbstractWorkerEntity findUnknownWorker() {
        List nearbyWorkers = this.worker.m_9236_().m_6443_(AbstractWorkerEntity.class, this.worker.m_20191_().m_82400_((double)CommonConfig.workerDetectionRadius), target -> target != this.worker && target.m_6084_() && target.m_269323_() != null && target.m_269323_().equals((Object)this.worker.m_269323_()) && !this.relationships.knows(target.m_20148_()));
        if (nearbyWorkers.isEmpty()) {
            return null;
        }
        return (AbstractWorkerEntity)nearbyWorkers.get(this.worker.m_217043_().m_188503_(nearbyWorkers.size()));
    }
}

