/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.workersplus.entities.ai;

import com.talhanation.workers.entities.AbstractWorkerEntity;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import org.sosly.workersplus.VillageWorkersPlus;
import org.sosly.workersplus.config.CommonConfig;
import org.sosly.workersplus.data.ItemPredicate;
import org.sosly.workersplus.entities.ai.AbstractTaskGoal;
import org.sosly.workersplus.tasks.AbstractTask;
import org.sosly.workersplus.utils.Containers;
import org.sosly.workersplus.utils.Worker;

public class GetItemsFromContainerGoal
extends AbstractTaskGoal {
    private AbstractWorkerEntity worker;
    private BlockPos pos;
    private List<?> items;
    private int lastTicked = 0;
    private int currentNeedIndex = 0;
    private boolean[] attemptedNeeds;

    public GetItemsFromContainerGoal(AbstractWorkerEntity worker, AbstractTask<?> task) {
        super(task);
        this.worker = worker;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
    }

    public GetItemsFromContainerGoal(AbstractWorkerEntity worker, List<ItemPredicate> items, BlockPos pos) {
        super(null);
        this.worker = worker;
        this.items = items;
        this.pos = pos;
    }

    public boolean m_8036_() {
        if (!Worker.canWork(this.worker)) {
            return false;
        }
        if (this.task != null && !this.canUseTask()) {
            return false;
        }
        if (this.pos == null || this.items == null) {
            return false;
        }
        return this.pos.m_203195_((Position)this.worker.m_20182_(), CommonConfig.containerReachDistance);
    }

    public boolean m_8045_() {
        if (this.allNeedsAttempted()) {
            return false;
        }
        return this.m_8036_();
    }

    public boolean m_6767_() {
        return false;
    }

    public void m_8056_() {
        this.currentNeedIndex = 0;
        this.attemptedNeeds = new boolean[this.items.size()];
        LivingEntity livingEntity = this.worker.m_269323_();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        BlockEntity be = this.worker.m_9236_().m_7702_(this.pos);
        if (be instanceof ChestBlockEntity) {
            ChestBlockEntity chest = (ChestBlockEntity)be;
            chest.m_5856_(player);
        }
    }

    public void m_8041_() {
        LivingEntity livingEntity = this.worker.m_269323_();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        BlockEntity be = this.worker.m_9236_().m_7702_(this.pos);
        if (be instanceof ChestBlockEntity) {
            ChestBlockEntity chest = (ChestBlockEntity)be;
            chest.m_5785_(player);
        }
        this.currentNeedIndex = 0;
        this.attemptedNeeds = null;
        this.items = null;
        this.pos = null;
        if (this.getTask() != null) {
            this.getTask().next();
        }
    }

    public void m_8037_() {
        ItemStack extracted;
        if (this.worker.m_9236_().m_46467_() - (long)this.lastTicked < 20L) {
            return;
        }
        this.lastTicked = (int)this.worker.m_9236_().m_46467_();
        if (!Worker.hasEmptyInventorySlot(this.worker)) {
            return;
        }
        Container chest = Containers.getFromBlockPos(this.pos, this.worker.m_9236_()).orElse(null);
        if (chest == null) {
            return;
        }
        if (this.currentNeedIndex >= this.items.size()) {
            return;
        }
        if (this.attemptedNeeds[this.currentNeedIndex]) {
            ++this.currentNeedIndex;
            return;
        }
        Object item = this.items.get(this.currentNeedIndex);
        if (!(item instanceof ItemPredicate)) {
            this.attemptedNeeds[this.currentNeedIndex] = true;
            ++this.currentNeedIndex;
            return;
        }
        ItemPredicate need = (ItemPredicate)item;
        int currentAmount = this.countItemsInInventory((Container)this.worker.getInventory(), need);
        int desiredAmount = need.getAmount();
        if (currentAmount >= desiredAmount) {
            this.attemptedNeeds[this.currentNeedIndex] = true;
            ++this.currentNeedIndex;
            return;
        }
        int amountToGet = Math.min(desiredAmount - currentAmount, desiredAmount);
        for (int totalCollected = 0; totalCollected < amountToGet && Worker.hasEmptyInventorySlot(this.worker) && !(extracted = Containers.removeItem(chest, need, amountToGet - totalCollected)).m_41619_(); totalCollected += extracted.m_41613_()) {
            ItemStack remainder = this.worker.getInventory().m_19173_(extracted);
            if (remainder.m_41619_()) continue;
            if ((remainder = Containers.putItem(chest, remainder)).m_41619_()) break;
            VillageWorkersPlus.LOGGER.error("Failed to put back remainder: {}", (Object)remainder);
            break;
        }
        this.attemptedNeeds[this.currentNeedIndex] = true;
        ++this.currentNeedIndex;
    }

    private boolean canUseTask() {
        if (!this.getTask().isCurrentStep(this)) {
            return false;
        }
        if (this.isStuckInCurrentStep()) {
            VillageWorkersPlus.LOGGER.warn("Worker {} is stuck in GetItemsFromContainerGoal, resetting task.", (Object)this.worker.m_20148_());
            this.getTask().reset();
            return false;
        }
        if (this.pos == null) {
            this.pos = this.getTask().currentData(BlockPos.class);
        }
        if (this.items == null && this.getTaskItems().isPresent()) {
            this.items = (List)this.getTaskItems().get();
        }
        return true;
    }

    private int countItemsInInventory(Container inventory, ItemPredicate predicate) {
        int count = 0;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (!predicate.matches(stack)) continue;
            count += stack.m_41613_();
        }
        return count;
    }

    private boolean allNeedsAttempted() {
        if (this.attemptedNeeds == null) {
            return true;
        }
        for (boolean attempted : this.attemptedNeeds) {
            if (attempted) continue;
            return false;
        }
        return true;
    }
}

