/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.workersplus.entities.ai;

import com.talhanation.workers.entities.AbstractWorkerEntity;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.ai.goal.Goal;
import org.sosly.workersplus.VillageWorkersPlus;
import org.sosly.workersplus.config.CommonConfig;
import org.sosly.workersplus.data.Need;
import org.sosly.workersplus.entities.ai.AbstractTaskGoal;
import org.sosly.workersplus.tasks.AbstractTask;
import org.sosly.workersplus.utils.Chat;
import org.sosly.workersplus.utils.Worker;

public class AssessWorkerNeedsGoal
extends AbstractTaskGoal {
    private final AbstractWorkerEntity worker;

    public AssessWorkerNeedsGoal(AbstractWorkerEntity worker, AbstractTask<?> task) {
        super(task);
        this.worker = worker;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!Worker.canWork(this.worker) || !this.getTask().isCurrentStep(this)) {
            return false;
        }
        if (this.isStuckInCurrentStep()) {
            VillageWorkersPlus.LOGGER.warn("Worker {} is stuck in AssessWorkerNeedsGoal, resetting task.", (Object)this.worker.m_20148_());
            this.getTask().reset();
            return false;
        }
        return this.getTaskTarget().filter(abstractWorkerEntity -> this.worker.m_20182_().m_82509_((Position)abstractWorkerEntity.m_20182_(), (double)CommonConfig.workerAssessmentDistance)).isPresent();
    }

    public boolean m_8045_() {
        if (!this.m_8036_()) {
            return false;
        }
        return this.getTask().getTimeInState() < 3000L;
    }

    public void m_8041_() {
        if (!this.getTask().isCurrentStep(this)) {
            return;
        }
        Optional taskTarget = this.getTaskTarget();
        if (taskTarget.isEmpty()) {
            this.getTask().reset();
            return;
        }
        AbstractWorkerEntity target = (AbstractWorkerEntity)taskTarget.get();
        List<Need> needs = Worker.getNeeds(target);
        if (needs.isEmpty()) {
            this.getTask().reset();
            return;
        }
        this.getTask().setData("items", needs);
        Chat.send(this.worker, (Component)Component.m_237110_((String)"chat.workersplus.assess_worker_needs.success", (Object[])new Object[]{target.m_7755_()}));
        this.getTask().next();
    }

    public boolean m_6767_() {
        return false;
    }
}

