/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.workersplus.entities.ai;

import com.talhanation.workers.entities.AbstractWorkerEntity;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import org.sosly.workersplus.VillageWorkersPlus;
import org.sosly.workersplus.config.CommonConfig;
import org.sosly.workersplus.data.Want;
import org.sosly.workersplus.entities.ai.AbstractTaskGoal;
import org.sosly.workersplus.tasks.AbstractTask;
import org.sosly.workersplus.utils.Chat;
import org.sosly.workersplus.utils.Containers;
import org.sosly.workersplus.utils.Worker;

public class AssessWorkerExcessGoal
extends AbstractTaskGoal {
    private final AbstractWorkerEntity collector;

    public AssessWorkerExcessGoal(AbstractWorkerEntity collector, AbstractTask<?> task) {
        super(task);
        this.collector = collector;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!Worker.canWork(this.collector) || !this.getTask().isCurrentStep(this)) {
            return false;
        }
        if (this.isStuckInCurrentStep()) {
            VillageWorkersPlus.LOGGER.warn("Worker {} is stuck in AssessWorkerExcessGoal, resetting task.", (Object)this.collector.m_20148_());
            this.getTask().reset();
            return false;
        }
        return this.getTaskTarget().filter(target -> {
            BlockPos chestPos = target.getChestPos();
            return chestPos != null && this.collector.m_20182_().m_82509_((Position)chestPos.m_252807_(), CommonConfig.containerReachDistance);
        }).isPresent();
    }

    public boolean m_8045_() {
        if (!this.m_8036_()) {
            return false;
        }
        return this.getTask().getTimeInState() < 3000L;
    }

    public void m_8041_() {
        if (!this.getTask().isCurrentStep(this)) {
            return;
        }
        Optional taskTarget = this.getTaskTarget();
        if (taskTarget.isEmpty()) {
            this.getTask().reset();
            return;
        }
        AbstractWorkerEntity target = (AbstractWorkerEntity)taskTarget.get();
        BlockPos chestPos = target.getChestPos();
        if (chestPos == null) {
            this.getTask().reset();
            return;
        }
        Container chest = Containers.getFromBlockPos(chestPos, this.collector.m_9236_()).orElse(null);
        if (chest == null) {
            this.getTask().reset();
            return;
        }
        List<Want> itemsToCollect = this.identifyExcessItems(target, chest);
        if (itemsToCollect.isEmpty()) {
            this.getTask().reset();
            return;
        }
        this.getTask().setData("items", itemsToCollect);
        Chat.send(this.collector, (Component)Component.m_237110_((String)"chat.workersplus.assess_worker_excess.success", (Object[])new Object[]{target.m_7755_(), itemsToCollect.size()}));
        this.getTask().next();
    }

    private List<Want> identifyExcessItems(AbstractWorkerEntity target, Container chest) {
        ArrayList<Want> itemsToCollect = new ArrayList<Want>();
        HashMap<String, Integer> wantedItemCounts = new HashMap<String, Integer>();
        for (int i = 0; i < chest.m_6643_(); ++i) {
            ItemStack stack = chest.m_8020_(i).m_41777_();
            if (stack.m_41619_()) continue;
            boolean wantsIt = target.wantsToKeep(stack);
            VillageWorkersPlus.LOGGER.info("Slot {}: {} x{}, worker wants: {}", (Object)i, (Object)stack.m_41720_(), (Object)stack.m_41613_(), (Object)wantsIt);
            if (!wantsIt) {
                itemsToCollect.add(new Want(stack));
                VillageWorkersPlus.LOGGER.info("  -> Marked as excess (unwanted)");
                continue;
            }
            if (!stack.m_41753_()) continue;
            String itemKey = stack.m_41720_().toString();
            int currentCount = wantedItemCounts.getOrDefault(itemKey, 0);
            int totalCount = currentCount + stack.m_41613_();
            if (currentCount >= stack.m_41741_()) {
                itemsToCollect.add(new Want(stack));
                continue;
            }
            if (totalCount > stack.m_41741_()) {
                int excess = totalCount - stack.m_41741_();
                ItemStack excessStack = stack.m_41777_();
                excessStack.m_41764_(excess);
                itemsToCollect.add(new Want(excessStack));
                wantedItemCounts.put(itemKey, stack.m_41741_());
                continue;
            }
            wantedItemCounts.put(itemKey, totalCount);
        }
        VillageWorkersPlus.LOGGER.info("Total excess items identified: {}", (Object)itemsToCollect.size());
        return itemsToCollect;
    }

    public boolean m_6767_() {
        return false;
    }
}

