/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.workersplus.entities;

import com.talhanation.workers.entities.AbstractWorkerEntity;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.sosly.workersplus.entities.Professions;
import org.sosly.workersplus.entities.workers.Porter;

@Mod.EventBusSubscriber(modid="workersplus", bus=Mod.EventBusSubscriber.Bus.MOD)
public class EntityTypes {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"workersplus");
    public static final RegistryObject<EntityType<Porter>> PORTER = ENTITY_TYPES.register("porter", () -> EntityType.Builder.m_20704_(Porter::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.6f, 1.95f).m_20720_().setTrackingRange(32).setShouldReceiveVelocityUpdates(true).m_20712_(new ResourceLocation("workersplus", "porter").toString()));
    private static final Map<VillagerProfession, EntityType<? extends AbstractWorkerEntity>> PROFESSION_TO_WORKER = new HashMap<VillagerProfession, EntityType<? extends AbstractWorkerEntity>>();

    @SubscribeEvent
    public static void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> PROFESSION_TO_WORKER.put((VillagerProfession)Professions.PORTER.get(), (EntityType<? extends AbstractWorkerEntity>)((EntityType)PORTER.get())));
    }

    public static EntityType<? extends AbstractWorkerEntity> getWorkerForProfession(VillagerProfession profession) {
        return PROFESSION_TO_WORKER.get(profession);
    }
}

