/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.workersplus.data;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.sosly.workersplus.data.WorkerInfo;

public class WorkerRelationships {
    private final Map<UUID, WorkerInfo> knownWorkers = new HashMap<UUID, WorkerInfo>();

    public Map<UUID, WorkerInfo> getRelationships() {
        return this.knownWorkers;
    }

    public void addKnown(UUID workerId, WorkerInfo info) {
        this.knownWorkers.put(workerId, info);
    }

    public void removeKnown(UUID workerId) {
        this.knownWorkers.remove(workerId);
    }

    public boolean knows(UUID workerId) {
        return this.knownWorkers.containsKey(workerId);
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        for (Map.Entry<UUID, WorkerInfo> entry : this.knownWorkers.entrySet()) {
            tag.m_128365_(entry.getKey().toString(), (Tag)entry.getValue().save());
        }
        return tag;
    }

    public void load(CompoundTag tag) {
        this.knownWorkers.clear();
        for (String key : tag.m_128431_()) {
            UUID id = UUID.fromString(key);
            CompoundTag workerTag = tag.m_128469_(key);
            WorkerInfo info = WorkerInfo.load(workerTag);
            this.knownWorkers.put(id, info);
        }
    }
}

