/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.workersplus.data;

import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.ItemLike;
import org.sosly.workersplus.config.CommonConfig;
import org.sosly.workersplus.data.ItemPredicate;

public class Need
implements ItemPredicate {
    public static final Predicate<ItemStack> FOOD_MATCHER = stack -> stack.m_41614_() && !stack.m_150930_(Items.f_42529_) && stack.getFoodProperties(null) != null && stack.getFoodProperties(null).m_38744_() > 4;
    private static final Map<Item, Predicate<ItemStack>> TOOL_MATCHERS = Map.of(Items.f_42411_, stack -> stack.m_41720_() instanceof BowItem, Items.f_42717_, stack -> stack.m_41720_() instanceof CrossbowItem, Items.f_42523_, stack -> stack.m_41720_() instanceof FishingRodItem, Items.f_42386_, stack -> stack.m_41720_() instanceof AxeItem, Items.f_42387_, stack -> stack.m_41720_() instanceof HoeItem, Items.f_42385_, stack -> stack.m_41720_() instanceof PickaxeItem, Items.f_42383_, stack -> stack.m_41720_() instanceof SwordItem, Items.f_42384_, stack -> stack.m_41720_() instanceof ShovelItem, Items.f_42574_, stack -> stack.m_41720_() instanceof ShearsItem, Items.f_42740_, stack -> stack.m_41720_() instanceof ShieldItem);
    private final int amount;
    private final Predicate<ItemStack> matcher;
    private final Component name;

    public Need(Predicate<ItemStack> matcher, int amount, Component name) {
        this.matcher = matcher;
        this.name = name;
        this.amount = amount;
    }

    @Override
    public int getAmount() {
        return this.amount;
    }

    @Override
    public boolean isSatisfied(ItemStack stack) {
        return this.matches(stack) && stack.m_41613_() >= this.amount;
    }

    @Override
    public boolean matches(ItemStack stack) {
        return this.matcher.test(stack);
    }

    @Override
    public Component getName() {
        return this.name;
    }

    public static Need food() {
        return new Need(FOOD_MATCHER, CommonConfig.workerFoodAmount, (Component)Component.m_237115_((String)"need.vwp.food"));
    }

    public static Need item(Item item) {
        Predicate<ItemStack> matcher = TOOL_MATCHERS.get(item);
        if (matcher == null) {
            matcher = stack -> stack.m_150930_(item);
        }
        return new Need(matcher, 1, item.m_7626_(new ItemStack((ItemLike)item)));
    }
}

