/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.workersplus.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="workersplus", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CommonConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.BooleanValue WORKERS_ARE_CHATTY;
    private static final ForgeConfigSpec.IntValue WORKER_MEETING_DURATION;
    private static final ForgeConfigSpec.IntValue WORKER_CHAT_RADIUS;
    private static final ForgeConfigSpec.IntValue WORKER_DETECTION_RADIUS;
    private static final ForgeConfigSpec.IntValue WORKER_CHAT_BROADCAST_RANGE;
    private static final ForgeConfigSpec.IntValue WORKER_FOOD_THRESHOLD;
    private static final ForgeConfigSpec.IntValue WORKER_FOOD_AMOUNT;
    private static final ForgeConfigSpec.DoubleValue CONTAINER_REACH_DISTANCE;
    private static final ForgeConfigSpec.IntValue WORKER_ASSESSMENT_DISTANCE;
    private static final ForgeConfigSpec.BooleanValue ENABLE_PORTERS;
    private static final ForgeConfigSpec.IntValue PORTER_COST;
    public static final ForgeConfigSpec SPEC;
    public static boolean workersAreChatty;
    public static int workerMeetingDuration;
    public static int workerChatRadius;
    public static int workerDetectionRadius;
    public static int workerChatBroadcastRange;
    public static int workerFoodThreshold;
    public static int workerFoodAmount;
    public static double containerReachDistance;
    public static int workerAssessmentDistance;
    public static boolean enablePorters;
    public static int porterCost;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        workersAreChatty = (Boolean)WORKERS_ARE_CHATTY.get();
        workerMeetingDuration = (Integer)WORKER_MEETING_DURATION.get();
        workerChatRadius = (Integer)WORKER_CHAT_RADIUS.get();
        workerDetectionRadius = (Integer)WORKER_DETECTION_RADIUS.get();
        workerChatBroadcastRange = (Integer)WORKER_CHAT_BROADCAST_RANGE.get();
        workerFoodThreshold = (Integer)WORKER_FOOD_THRESHOLD.get();
        workerFoodAmount = (Integer)WORKER_FOOD_AMOUNT.get();
        containerReachDistance = (Double)CONTAINER_REACH_DISTANCE.get();
        workerAssessmentDistance = (Integer)WORKER_ASSESSMENT_DISTANCE.get();
        enablePorters = (Boolean)ENABLE_PORTERS.get();
        porterCost = (Integer)PORTER_COST.get();
    }

    static {
        BUILDER.push("general");
        BUILDER.comment("General settings for all workers");
        WORKERS_ARE_CHATTY = BUILDER.comment("Whether workers announce what they're doing").define("workersAreChatty", true);
        WORKER_MEETING_DURATION = BUILDER.comment("Time in seconds for workers to meet each other").defineInRange("workerMeetingDuration", 5, 2, 30);
        WORKER_CHAT_RADIUS = BUILDER.comment("How close a worker must be to another to chat (in blocks)").defineInRange("workerChatRadius", 5, 2, 10);
        WORKER_DETECTION_RADIUS = BUILDER.comment("Radius in blocks that workers will scan for other workers").defineInRange("workerDetectionRadius", 80, 16, 512);
        WORKER_CHAT_BROADCAST_RANGE = BUILDER.comment("Range in blocks that worker chat messages are visible to players").defineInRange("workerChatBroadcastRange", 30, 10, 100);
        WORKER_FOOD_THRESHOLD = BUILDER.comment("Minimum food items before a worker needs more").defineInRange("workerFoodThreshold", 3, 1, 20);
        WORKER_FOOD_AMOUNT = BUILDER.comment("Amount of food items supplied to a worker when they need food").defineInRange("workerFoodAmount", 16, 1, 64);
        CONTAINER_REACH_DISTANCE = BUILDER.comment("Distance in blocks that workers can interact with containers").defineInRange("containerReachDistance", 2.5, 1.0, 5.0);
        WORKER_ASSESSMENT_DISTANCE = BUILDER.comment("Distance in blocks to assess worker needs").defineInRange("workerAssessmentDistance", 5, 2, 20);
        BUILDER.pop();
        BUILDER.push("porter");
        BUILDER.comment("Porter-specific settings");
        ENABLE_PORTERS = BUILDER.comment("Enable Porter workers (logistics/delivery)").define("enablePorters", true);
        PORTER_COST = BUILDER.comment("The amount of currency required to hire a porter.").defineInRange("PorterCost", 20, 1, 64);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

