/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.network;

import com.talhanation.workers.entities.AbstractWorkerEntity;
import de.maxhenkel.workers.corelib.net.Message;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.network.NetworkEvent;

public class MessageFollow
implements Message<MessageFollow> {
    private UUID player;
    private UUID worker;

    public MessageFollow() {
    }

    public MessageFollow(UUID player, UUID worker) {
        this.player = player;
        this.worker = worker;
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.DEDICATED_SERVER;
    }

    @Override
    public void executeServerSide(NetworkEvent.Context context) {
        List workers = Objects.requireNonNull(context.getSender()).m_20193_().m_45976_(AbstractWorkerEntity.class, context.getSender().m_20191_().m_82400_(64.0));
        for (AbstractWorkerEntity worker : workers) {
            if (!Objects.equals(worker.m_20148_(), this.worker)) continue;
            if (worker.getStatus() == AbstractWorkerEntity.Status.FOLLOW) {
                worker.setStatus(worker.prevStatus);
                continue;
            }
            worker.setStatus(AbstractWorkerEntity.Status.FOLLOW, true);
        }
    }

    @Override
    public MessageFollow fromBytes(FriendlyByteBuf buf) {
        this.player = buf.m_130259_();
        this.worker = buf.m_130259_();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.player);
        buf.m_130077_(this.worker);
    }
}

