/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.entities.ai;

import com.talhanation.workers.entities.AbstractWorkerEntity;
import java.util.Objects;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class EatGoal
extends Goal {
    public AbstractWorkerEntity worker;
    public ItemStack foodStack;
    public ItemStack beforeItem;
    public int slotID;
    private long lastCanUseCheck;

    public EatGoal(AbstractWorkerEntity worker) {
        this.worker = worker;
    }

    public boolean m_8036_() {
        long i = this.worker.m_20193_().m_46467_();
        if (i - this.lastCanUseCheck < 1200L) {
            return false;
        }
        this.lastCanUseCheck = i;
        this.worker.updateHunger();
        return this.hasFoodInInv() && this.worker.needsToEat() && !this.worker.m_6117_();
    }

    public boolean m_8045_() {
        return this.worker.m_6117_();
    }

    public boolean m_6767_() {
        return false;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8056_() {
        this.slotID = 0;
        this.beforeItem = this.worker.m_21206_().m_41777_();
        this.foodStack = this.getAndRemoveFoodInInv().m_41777_();
        this.worker.m_5634_(Objects.requireNonNull(this.foodStack.m_41720_().getFoodProperties(this.foodStack, (LivingEntity)this.worker)).m_38745_() * 1.0f);
        if (!this.worker.isSaturated()) {
            float saturation = Objects.requireNonNull(this.foodStack.m_41720_().getFoodProperties(this.foodStack, (LivingEntity)this.worker)).m_38745_();
            float nutrition = Objects.requireNonNull(this.foodStack.m_41720_().getFoodProperties(this.foodStack, (LivingEntity)this.worker)).m_38744_() * 5;
            int currentHunger = this.worker.getHunger();
            int newHunger = Math.round((float)currentHunger + saturation + nutrition);
            if (newHunger >= 100) {
                newHunger = 100;
            }
            this.worker.setHunger(newHunger);
        }
        this.worker.m_21008_(InteractionHand.OFF_HAND, this.foodStack);
        this.worker.m_6672_(InteractionHand.OFF_HAND);
    }

    public void m_8041_() {
        this.worker.m_5810_();
        this.resetItemInHand();
    }

    public void resetItemInHand() {
        this.worker.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_);
        this.worker.m_21008_(InteractionHand.OFF_HAND, this.beforeItem.m_41777_());
        if (this.worker.getInventory().m_8020_(this.slotID).m_41619_()) {
            this.worker.getInventory().m_6836_(this.slotID, this.foodStack.m_41777_());
        } else {
            for (int i = 0; i < this.worker.getInventory().m_6643_(); ++i) {
                if (!this.worker.getInventory().m_8020_(i).m_41619_()) continue;
                this.worker.getInventory().m_6836_(i, this.foodStack.m_41777_());
                return;
            }
            this.worker.m_19983_(this.foodStack.m_41777_());
        }
    }

    private boolean hasFoodInInv() {
        return this.worker.getInventory().f_19147_.stream().filter(itemStack -> !itemStack.m_150930_(Items.f_42529_)).filter(itemStack -> itemStack.m_41614_() && itemStack.getFoodProperties((LivingEntity)this.worker).m_38744_() > 4).anyMatch(ItemStack::m_41614_);
    }

    private ItemStack getAndRemoveFoodInInv() {
        ItemStack itemStack = null;
        for (int i = 0; i < this.worker.getInventory().m_6643_(); ++i) {
            ItemStack stackInSlot = this.worker.getInventory().m_8020_(i).m_41777_();
            if (!stackInSlot.m_41614_() || stackInSlot.m_150930_(Items.f_42529_) || stackInSlot.getFoodProperties((LivingEntity)this.worker).m_38744_() <= 4) continue;
            itemStack = stackInSlot.m_41777_();
            this.slotID = i;
            this.worker.getInventory().m_8016_(i);
            break;
        }
        return itemStack;
    }
}

