/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.witherreincarnated.rendering.models.entities;

import com.alexander.witherreincarnated.config.WRClientConfig;
import com.alexander.witherreincarnated.events.HandleAnimationsEvent;
import com.alexander.witherreincarnated.rendering.models.entities.animations.BetterWitherAnimations;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.boss.wither.WitherBoss;

public class BetterWitherModel<T extends WitherBoss>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("witherreincarnated", "wither"), "main");
    public static final ModelLayerLocation ARMOUR_LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("witherreincarnated", "wither"), "armour");
    private final ModelPart root;
    private final ModelPart everything;
    private final ModelPart body;
    private final ModelPart heads;
    private final ModelPart mHead;
    private final ModelPart lHead;
    private final ModelPart rHead;
    private final ModelPart tail;
    private final ModelPart wings;
    private final ModelPart leftWing;
    private final ModelPart rightWing;
    private final ModelPart netherStar;

    public BetterWitherModel(ModelPart root) {
        this.root = root;
        this.everything = root.m_171324_("everything");
        this.body = this.everything.m_171324_("body");
        this.heads = this.body.m_171324_("heads");
        this.mHead = this.heads.m_171324_("mHead");
        this.lHead = this.heads.m_171324_("lHead");
        this.rHead = this.heads.m_171324_("rHead");
        this.tail = this.body.m_171324_("tail");
        this.wings = this.body.m_171324_("wings");
        this.leftWing = this.wings.m_171324_("leftWing");
        this.rightWing = this.wings.m_171324_("rightWing");
        this.netherStar = this.body.m_171324_("netherStar");
    }

    public static LayerDefinition createBodyLayer() {
        return BetterWitherModel.createLayer(new CubeDeformation(0.0f), true);
    }

    public static LayerDefinition createArmourLayer() {
        return BetterWitherModel.createLayer(new CubeDeformation(0.5f), false);
    }

    public static LayerDefinition createLayer(CubeDeformation deformation, boolean includeWingModels) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition everything = partdefinition.m_171599_("everything", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)0.0f));
        PartDefinition body = everything.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 24).m_171488_(-2.0f, -3.0f, -2.0f, 4.0f, 18.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 16).m_171488_(-12.0f, -7.0f, -2.0f, 24.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(16, 24).m_171488_(-8.0f, -7.0f, -10.0f, 16.0f, 10.0f, 12.0f, new CubeDeformation(0.0f)).m_171514_(0, 50).m_171488_(-6.0f, 3.0f, -10.0f, 12.0f, 4.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)0.0f));
        PartDefinition heads = body.m_171599_("heads", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-7.0f, (float)0.0f));
        PartDefinition mHead = heads.m_171599_("mHead", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(32, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(-0.5f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition lHead = heads.m_171599_("lHead", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -3.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(32, 0).m_171488_(-4.0f, -3.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(-0.5f)), PartPose.m_171419_((float)16.0f, (float)1.0f, (float)-1.0f));
        PartDefinition rHead = heads.m_171599_("rHead", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -5.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(32, 0).m_171488_(-4.0f, -5.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(-0.5f)), PartPose.m_171419_((float)-16.0f, (float)2.0f, (float)1.0f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(0, 46).m_171488_(-1.0f, 0.0f, -2.0f, 2.0f, 12.0f, 3.0f, deformation), PartPose.m_171419_((float)0.0f, (float)14.0f, (float)1.0f));
        PartDefinition wings = body.m_171599_("wings", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)2.0f));
        CubeListBuilder leftWingCubeListBuilder = CubeListBuilder.m_171558_().m_171514_(0, 97);
        CubeListBuilder rightWingCubeListBuilder = CubeListBuilder.m_171558_().m_171514_(0, 97).m_171480_();
        if (includeWingModels) {
            leftWingCubeListBuilder.m_171488_(0.0f, -18.0f, 0.0f, 40.0f, 30.0f, 1.0f, deformation);
            rightWingCubeListBuilder.m_171488_(-40.0f, -18.0f, 0.0f, 40.0f, 30.0f, 1.0f, deformation);
        }
        PartDefinition leftWing = wings.m_171599_("leftWing", leftWingCubeListBuilder, PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightWing = wings.m_171599_("rightWing", rightWingCubeListBuilder, PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition netherStar = body.m_171599_("netherStar", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-6.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void translateNetherStar(PoseStack stack) {
        this.m_142109_().m_104299_(stack);
        this.everything.m_104299_(stack);
        this.body.m_104299_(stack);
        this.netherStar.m_104299_(stack);
    }

    public void setupAnim(T entity, float p_104101_, float p_104102_, float p_104103_, float p_104104_, float p_104105_) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        if (HandleAnimationsEvent.witherAnimations.containsKey(entity)) {
            HandleAnimationsEvent.WitherAnimations anims = HandleAnimationsEvent.witherAnimations.get(entity);
            AnimationState constantAnimationState = anims.constantAnimationState;
            if (entity.m_31502_() > 0) {
                this.m_233381_(constantAnimationState, BetterWitherAnimations.spawning, p_104103_);
            } else if (anims.stunTick > 0) {
                this.m_233381_(constantAnimationState, BetterWitherAnimations.stunned, p_104103_);
            } else {
                this.m_233381_(constantAnimationState, BetterWitherAnimations.idle, p_104103_);
            }
            this.m_233381_(constantAnimationState, BetterWitherAnimations.constant, p_104103_);
            this.m_233381_(anims.chargeAnimationState, BetterWitherAnimations.charge, p_104103_);
            this.m_233381_(anims.barrageAnimationState, BetterWitherAnimations.barrage, p_104103_);
            this.m_233381_(anims.deathAnimationState, BetterWitherAnimations.death, p_104103_);
            if (!anims.deathAnimationState.m_216984_() && anims.barrageTick <= 0) {
                this.body.f_104203_ = (float)((double)this.body.f_104203_ + Math.toRadians(Mth.m_14179_((float)Minecraft.m_91087_().getPartialTick(), (float)anims.forwardLeanO, (float)anims.forwardLean)));
                this.wings.f_104203_ = (float)((double)this.wings.f_104203_ - Math.toRadians(Mth.m_14179_((float)Minecraft.m_91087_().getPartialTick(), (float)anims.forwardLeanO, (float)anims.forwardLean)));
            }
            if (anims.laserAngle != null && (anims.laserAngle.f_82470_ != 0.0f || anims.laserAngle.f_82471_ != 0.0f)) {
                this.body.f_104203_ = (float)((double)this.body.f_104203_ + Math.toRadians(Mth.m_14179_((float)Minecraft.m_91087_().getPartialTick(), (float)anims.laserAngleO.f_82470_, (float)anims.laserAngle.f_82470_)));
                this.mHead.f_104203_ += this.body.f_104203_;
            } else {
                this.mHead.f_104204_ += p_104104_ * ((float)Math.PI / 180);
                this.mHead.f_104203_ += p_104105_ * ((float)Math.PI / 180);
            }
            this.wings.f_104207_ = (Boolean)WRClientConfig.remove_wither_wings.get() == false;
            BetterWitherModel.setupHeadRotation(entity, this.rHead, 0);
            BetterWitherModel.setupHeadRotation(entity, this.lHead, 1);
            if (anims.barrageTick > 0) {
                this.mHead.f_104203_ = 0.0f;
                this.lHead.f_104203_ = 0.0f;
                this.rHead.f_104203_ = 0.0f;
                this.mHead.f_104204_ = 0.0f;
                this.lHead.f_104204_ = 0.0f;
                this.rHead.f_104204_ = 0.0f;
            } else {
                this.heads.f_104203_ -= this.body.f_104203_;
            }
        }
    }

    private static <T extends WitherBoss> void setupHeadRotation(T entity, ModelPart p_171073_, int head) {
        float partialTick = Minecraft.m_91087_().getPartialTick();
        p_171073_.f_104204_ += (Mth.m_14179_((float)partialTick, (float)entity.f_31426_[head], (float)entity.m_31446_(head)) - entity.f_20883_) * ((float)Math.PI / 180);
        p_171073_.f_104203_ += Mth.m_14179_((float)partialTick, (float)entity.f_31425_[head], (float)entity.m_31480_(head)) * ((float)Math.PI / 180);
    }
}

