/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.witherreincarnated.rendering;

import com.alexander.witherreincarnated.config.WRClientConfig;
import com.alexander.witherreincarnated.events.HandleAnimationsEvent;
import com.alexander.witherreincarnated.rendering.layers.BetterWitherArmorLayer;
import com.alexander.witherreincarnated.rendering.layers.BetterWitherExplodingLayer;
import com.alexander.witherreincarnated.rendering.layers.BetterWitherGlowLayer;
import com.alexander.witherreincarnated.rendering.layers.BetterWitherNetherStarLayer;
import com.alexander.witherreincarnated.rendering.models.entities.BetterWitherModel;
import com.alexander.witherreincarnated.utils.PositionUtils;
import com.alexander.witherreincarnated.utils.RenderingUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BeaconRenderer;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class BetterWitherRenderer
extends MobRenderer<WitherBoss, BetterWitherModel<WitherBoss>> {
    public static final ResourceLocation WITHER_INVULNERABLE_LOCATION = new ResourceLocation("witherreincarnated", "textures/entities/wither_invulnerable.png");
    public static final ResourceLocation WITHER_LOCATION = new ResourceLocation("witherreincarnated", "textures/entities/wither.png");
    public static final ResourceLocation LASER_LOCATION = new ResourceLocation("witherreincarnated", "textures/entities/wither_laser.png");

    public BetterWitherRenderer(EntityRendererProvider.Context context) {
        super(context, new BetterWitherModel(context.m_174023_(BetterWitherModel.LAYER_LOCATION)), 1.0f);
        this.m_115326_(new BetterWitherExplodingLayer(this));
        this.m_115326_((RenderLayer)new BetterWitherArmorLayer((RenderLayerParent<WitherBoss, BetterWitherModel<WitherBoss>>)this, context.m_174027_()));
        this.m_115326_(new BetterWitherGlowLayer(this));
        this.m_115326_(new BetterWitherNetherStarLayer(this, context.m_174025_()));
    }

    public void render(WitherBoss entity, float p_115456_, float partialTick, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        super.m_7392_((Mob)entity, p_115456_, partialTick, stack, buffer, packedLight);
        if (entity.f_20919_ <= 0 && HandleAnimationsEvent.witherAnimations.containsKey(entity)) {
            HandleAnimationsEvent.WitherAnimations anims = HandleAnimationsEvent.witherAnimations.get(entity);
            if (anims.laserAngle != null && (anims.laserAngle.f_82470_ != 0.0f || anims.laserAngle.f_82471_ != 0.0f)) {
                stack.m_85836_();
                Vec2 facingAngle = new Vec2(Mth.m_14179_((float)partialTick, (float)anims.laserAngleO.f_82470_, (float)anims.laserAngle.f_82470_), Mth.m_14179_((float)partialTick, (float)anims.laserAngleO.f_82471_, (float)anims.laserAngle.f_82471_));
                Vec3 entityPos = PositionUtils.getOffsetPos(entity.m_20182_().m_82520_(0.0, (double)entity.m_20206_() * 0.5, 0.0), 0.0, 0.0, (double)entity.m_20205_() * 0.5, facingAngle.f_82470_, facingAngle.f_82471_);
                long j = entity.m_9236_().m_46467_();
                stack.m_85837_(entityPos.f_82479_ - entity.m_20185_(), entityPos.f_82480_ - entity.m_20186_(), entityPos.f_82481_ - entity.m_20189_());
                stack.m_252781_(Axis.f_252436_.m_252977_(-facingAngle.f_82471_));
                stack.m_252781_(Axis.f_252529_.m_252977_(facingAngle.f_82470_ + 90.0f));
                stack.m_85837_(-0.5, -0.5, -0.5);
                BeaconRenderer.m_112184_((PoseStack)stack, (MultiBufferSource)buffer, (ResourceLocation)LASER_LOCATION, (float)partialTick, (float)1.0f, (long)(j * 5L), (int)0, (int)Mth.m_14143_((float)(anims.laserLength + 0.5f)), (float[])DyeColor.WHITE.m_41068_(), (float)0.2f, (float)0.3f);
                stack.m_85849_();
            }
        }
        if (entity.f_20919_ >= 90) {
            stack.m_85836_();
            Vec3 entityPos = entity.m_20182_().m_82520_(-0.5, (double)entity.m_20206_() * 0.5, -0.5);
            long j = entity.m_9236_().m_46467_();
            stack.m_85837_(entityPos.f_82479_ - entity.m_20185_(), entityPos.f_82480_ - entity.m_20186_(), entityPos.f_82481_ - entity.m_20189_());
            BeaconRenderer.m_112184_((PoseStack)stack, (MultiBufferSource)buffer, (ResourceLocation)LASER_LOCATION, (float)partialTick, (float)1.0f, (long)(j * 5L), (int)0, (int)500, (float[])DyeColor.WHITE.m_41068_(), (float)0.3f, (float)0.5f);
            stack.m_85849_();
        }
        if (entity.m_31502_() < 0 && entity.m_31502_() > -20) {
            RenderingUtils.renderLightning(stack, buffer, entity.m_19879_() * entity.f_19797_, -entity.f_20883_, new Vec3(0.0, (double)entity.m_20206_(), 0.0), new Vector3f(1.0f, 1.0f, 1.0f));
        }
    }

    public static void tryRenderDeathGlow(WitherBoss entity, PoseStack stack, MultiBufferSource buffer) {
        if (entity.f_20919_ >= 90) {
            Vec3 cameraPos = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
            Vec3 negativeCameraPos = new Vec3(-cameraPos.f_82479_, -cameraPos.f_82480_, -cameraPos.f_82481_);
            Color flareColour = new Color((Integer)WRClientConfig.wither_death_flare_colour.get());
            stack.m_85836_();
            Vec3 pos = negativeCameraPos.m_82549_(entity.m_20182_().m_82520_(0.0, (double)(entity.m_20206_() / 2.0f), 0.0));
            stack.m_85837_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
            VertexConsumer builder = buffer.m_6299_(RenderType.m_110502_());
            stack.m_252781_(Minecraft.m_91087_().m_91290_().m_253208_());
            stack.m_252880_(0.0f, 0.0f, entity.m_20206_());
            stack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            Matrix4f matrix = stack.m_85850_().m_252922_();
            float amount = (float)(entity.f_20919_ - 90) / 110.0f;
            float size = 100.0f * amount;
            float resolution = ((Double)WRClientConfig.wither_death_flare_detail.get()).floatValue();
            int i = 0;
            while ((float)i < 360.0f * resolution) {
                Vec3 pos1 = PositionUtils.getOffsetPos(Vec3.f_82478_, (double)size, 0.0, 0.0, 0.0f, (float)i / resolution);
                Vec3 pos2 = PositionUtils.getOffsetPos(Vec3.f_82478_, (double)size, 0.0, 0.0, 0.0f, (float)(i + 1) / resolution);
                Vec3 pos3 = PositionUtils.getOffsetPos(Vec3.f_82478_, (double)size, 0.0, 0.0, 0.0f, (float)(i + 2) / resolution);
                builder.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, Mth.m_14179_((float)amount, (float)0.75f, (float)0.0f)).m_5752_();
                builder.m_252986_(matrix, (float)pos1.f_82479_, (float)pos1.f_82480_, (float)pos1.f_82481_).m_85950_((float)flareColour.getRed() / 255.0f, (float)flareColour.getGreen() / 255.0f, (float)flareColour.getBlue() / 255.0f, 0.0f).m_5752_();
                builder.m_252986_(matrix, (float)pos2.f_82479_, (float)pos2.f_82480_, (float)pos2.f_82481_).m_85950_((float)flareColour.getRed() / 255.0f, (float)flareColour.getGreen() / 255.0f, (float)flareColour.getBlue() / 255.0f, 0.0f).m_5752_();
                builder.m_252986_(matrix, (float)pos3.f_82479_, (float)pos3.f_82480_, (float)pos3.f_82481_).m_85950_((float)flareColour.getRed() / 255.0f, (float)flareColour.getGreen() / 255.0f, (float)flareColour.getBlue() / 255.0f, 0.0f).m_5752_();
                ++i;
            }
            stack.m_85849_();
        }
    }

    public static void tryRenderShine(WitherBoss entity, PoseStack stack, MultiBufferSource buffer) {
        if ((Double)WRClientConfig.wither_shine_opacity.get() > 0.0 && entity.f_20919_ < 90) {
            Vec3 cameraPos = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
            Vec3 negativeCameraPos = new Vec3(-cameraPos.f_82479_, -cameraPos.f_82480_, -cameraPos.f_82481_);
            Color shineColour = new Color((Integer)WRClientConfig.wither_shine_colour.get());
            stack.m_85836_();
            Vec3 pos = negativeCameraPos.m_82549_(entity.m_20182_().m_82520_(0.0, (double)(entity.m_20206_() / 2.0f), 0.0));
            stack.m_85837_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
            VertexConsumer builder = buffer.m_6299_(RenderType.m_110502_());
            stack.m_252781_(Minecraft.m_91087_().m_91290_().m_253208_());
            stack.m_252880_(0.0f, 0.0f, entity.m_20205_());
            stack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            Matrix4f matrix = stack.m_85850_().m_252922_();
            float size = 5.0f;
            float resolution = ((Double)WRClientConfig.wither_shine_detail.get()).floatValue();
            int i = 0;
            while ((float)i < 360.0f * resolution) {
                Vec3 pos1 = PositionUtils.getOffsetPos(Vec3.f_82478_, (double)size, 0.0, 0.0, 0.0f, (float)i / resolution);
                Vec3 pos2 = PositionUtils.getOffsetPos(Vec3.f_82478_, (double)size, 0.0, 0.0, 0.0f, (float)(i + 1) / resolution);
                Vec3 pos3 = PositionUtils.getOffsetPos(Vec3.f_82478_, (double)size, 0.0, 0.0, 0.0f, (float)(i + 2) / resolution);
                builder.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, ((Double)WRClientConfig.wither_shine_opacity.get()).floatValue()).m_5752_();
                builder.m_252986_(matrix, (float)pos1.f_82479_, (float)pos1.f_82480_, (float)pos1.f_82481_).m_85950_((float)shineColour.getRed() / 255.0f, (float)shineColour.getGreen() / 255.0f, (float)shineColour.getBlue() / 255.0f, 0.0f).m_5752_();
                builder.m_252986_(matrix, (float)pos2.f_82479_, (float)pos2.f_82480_, (float)pos2.f_82481_).m_85950_((float)shineColour.getRed() / 255.0f, (float)shineColour.getGreen() / 255.0f, (float)shineColour.getBlue() / 255.0f, 0.0f).m_5752_();
                builder.m_252986_(matrix, (float)pos3.f_82479_, (float)pos3.f_82480_, (float)pos3.f_82481_).m_85950_((float)shineColour.getRed() / 255.0f, (float)shineColour.getGreen() / 255.0f, (float)shineColour.getBlue() / 255.0f, 0.0f).m_5752_();
                ++i;
            }
            stack.m_85849_();
        }
    }

    protected RenderType getRenderType(WitherBoss wither, boolean p_115323_, boolean p_115324_, boolean p_115325_) {
        return wither.m_31502_() > 60 || wither.f_20919_ >= 90 ? null : super.m_7225_((LivingEntity)wither, p_115323_, p_115324_, p_115325_);
    }

    public Vec3 getRenderOffset(WitherBoss wither, float p_114337_) {
        if (wither.m_7090_() && wither.m_31502_() <= 0) {
            double d0 = 0.05;
            return new Vec3(wither.m_217043_().m_188583_() * d0, wither.m_217043_().m_188583_() * d0, wither.m_217043_().m_188583_() * d0);
        }
        return super.m_7860_((Entity)wither, p_114337_);
    }

    protected void setupRotations(WitherBoss entity, PoseStack stack, float p_115319_, float p_115320_, float partialTick) {
        super.m_7523_((LivingEntity)entity, stack, p_115319_, p_115320_, partialTick);
        if (entity.f_20919_ <= 0 && HandleAnimationsEvent.witherAnimations.containsKey(entity)) {
            HandleAnimationsEvent.WitherAnimations anims = HandleAnimationsEvent.witherAnimations.get(entity);
            if (anims.laserAngle != null && (anims.laserAngle.f_82470_ != 0.0f || anims.laserAngle.f_82471_ != 0.0f)) {
                float y = Mth.m_14179_((float)partialTick, (float)anims.laserAngleO.f_82471_, (float)anims.laserAngle.f_82471_) - Mth.m_14179_((float)partialTick, (float)entity.f_20884_, (float)entity.f_20883_);
                stack.m_252781_(Axis.f_252436_.m_252977_(-y));
            }
            stack.m_252880_(0.0f, entity.m_20206_() / 2.0f, 0.0f);
            stack.m_252781_(Axis.f_252403_.m_252977_(Mth.m_14179_((float)Minecraft.m_91087_().getPartialTick(), (float)anims.leanO, (float)anims.lean)));
            stack.m_252880_(0.0f, -entity.m_20206_() / 2.0f, 0.0f);
        }
    }

    protected float getFlipDegrees(WitherBoss p_115337_) {
        return 0.0f;
    }

    public boolean shouldRender(WitherBoss p_115468_, Frustum p_115469_, double p_115470_, double p_115471_, double p_115472_) {
        return true;
    }

    protected int getBlockLightLevel(WitherBoss p_114496_, BlockPos p_114497_) {
        return this.getTextureLocation(p_114496_) == WITHER_INVULNERABLE_LOCATION ? 15 : super.m_6086_((Entity)p_114496_, p_114497_);
    }

    public ResourceLocation getTextureLocation(WitherBoss p_116437_) {
        int i = p_116437_.m_31502_();
        return i > 0 && (i > 80 || i / 5 % 2 != 1) ? WITHER_INVULNERABLE_LOCATION : WITHER_LOCATION;
    }

    protected void scale(WitherBoss p_116439_, PoseStack p_116440_, float p_116441_) {
        float f = 1.75f;
        int i = p_116439_.m_31502_();
        if (i > 0) {
            f -= ((float)i - p_116441_) / 220.0f * 0.75f;
        }
        p_116440_.m_85841_(f, f, f);
    }
}

