/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.witherreincarnated.events;

import com.alexander.witherreincarnated.init.ParticleTypeInit;
import com.alexander.witherreincarnated.particles.AbsorbParticle;
import com.alexander.witherreincarnated.particles.HugeSmokeParticle;
import com.alexander.witherreincarnated.rendering.BetterWitherRenderer;
import com.alexander.witherreincarnated.rendering.BetterWitherSkullRenderer;
import com.alexander.witherreincarnated.rendering.layers.PossessedLayer;
import com.alexander.witherreincarnated.rendering.models.entities.BetterWitherModel;
import com.alexander.witherreincarnated.rendering.models.entities.BetterWitherSkullModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="witherreincarnated", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientEvents {
    @SubscribeEvent
    public static void onRegisterLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(BetterWitherModel.LAYER_LOCATION, BetterWitherModel::createBodyLayer);
        event.registerLayerDefinition(BetterWitherModel.ARMOUR_LAYER_LOCATION, BetterWitherModel::createArmourLayer);
        event.registerLayerDefinition(BetterWitherSkullModel.LAYER_LOCATION, BetterWitherSkullModel::createBodyLayer);
        event.registerLayerDefinition(BetterWitherSkullModel.DANGEROUS_LAYER_LOCATION, BetterWitherSkullModel::createBodyLayerDangerous);
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(EntityType.f_20496_, BetterWitherRenderer::new);
        event.registerEntityRenderer(EntityType.f_20498_, BetterWitherSkullRenderer::new);
    }

    @SubscribeEvent
    public static void registerParticleFactories(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)ParticleTypeInit.ABSORB.get(), AbsorbParticle.Provider::new);
        event.registerSpriteSet((ParticleType)ParticleTypeInit.HUGE_SMOKE.get(), HugeSmokeParticle.Provider::new);
    }

    @SubscribeEvent
    public static void addLayers(EntityRenderersEvent.AddLayers event) {
        Minecraft.m_91087_().m_91290_().f_114362_.values().forEach(renderer -> {
            if (renderer instanceof LivingEntityRenderer) {
                LivingEntityRenderer livingRenderer = (LivingEntityRenderer)renderer;
                livingRenderer.m_115326_(new PossessedLayer(livingRenderer));
            }
        });
    }
}

