/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.witherreincarnated.capabilities.possessed;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;

public class PossessedCapability {
    public int possessionTime = 0;
    public int possessedFor = 0;
    public int possessionCooldown;
    public LivingEntity possessedBy;
    public UUID possessedByUUID;
    public boolean wasPossessed;
    public boolean worldLoaded;

    public boolean isPossessed() {
        return this.possessionTime > 0;
    }

    public boolean canBePossessed() {
        return !this.isPossessed() && this.possessionCooldown <= 0;
    }

    public void tick() {
        this.possessionCooldown = this.wasPossessed && !this.isPossessed() || this.possessionCooldown > 0 && this.possessionCooldown < 1200 ? ++this.possessionCooldown : 0;
        this.wasPossessed = this.isPossessed();
        if (this.isPossessed()) {
            ++this.possessedFor;
            --this.possessionTime;
        } else {
            this.possessedFor = 0;
        }
        if (!this.isPossessed() || this.possessedBy == null || this.possessedBy.m_21224_()) {
            this.possessedBy = null;
            this.possessedByUUID = null;
        }
    }

    public void copyFrom(PossessedCapability source) {
        this.possessionTime = source.possessionTime;
        this.possessedFor = source.possessedFor;
        this.possessionCooldown = source.possessionCooldown;
        this.possessedByUUID = source.possessedByUUID;
    }

    public void save(CompoundTag tag) {
        tag.m_128405_("PossessionTime", this.possessionTime);
        tag.m_128405_("PossessedFor", this.possessedFor);
        tag.m_128405_("PossessionCooldown", this.possessionCooldown);
        if (this.possessedByUUID != null) {
            tag.m_128362_("PossessedByUUID", this.possessedByUUID);
        }
    }

    public void load(CompoundTag tag) {
        this.possessionTime = tag.m_128451_("PossessionTime");
        this.possessedFor = tag.m_128451_("PossessedFor");
        this.possessionCooldown = tag.m_128451_("PossessionCooldown");
        this.possessedByUUID = tag.m_128441_("PossessedByUUID") ? tag.m_128342_("PossessedByUUID") : null;
    }
}

