/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watervision.common.network;

import java.util.function.Function;
import me.srrapero720.watervision.common.network.Packet;
import me.srrapero720.watervision.common.network.PlayVideoOverlayPacket;
import me.srrapero720.watervision.common.network.PlayVideoPacket;
import me.srrapero720.watervision.common.network.StopVideoOverlayPacket;
import me.srrapero720.watervision.common.network.StopVideoPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class VisionNetwork {
    public static final String PROTOCOL_VERSION = "1";
    private static SimpleChannel INSTANCE;
    private static int nextId;

    public static void init() {
        INSTANCE = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("watervision", "network")).networkProtocolVersion(() -> PROTOCOL_VERSION).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).simpleChannel();
        VisionNetwork.register(PlayVideoPacket.class, PlayVideoPacket::decode);
        VisionNetwork.register(PlayVideoOverlayPacket.class, PlayVideoOverlayPacket::decode);
        VisionNetwork.register(StopVideoPacket.class, StopVideoPacket::decode);
        VisionNetwork.register(StopVideoOverlayPacket.class, StopVideoOverlayPacket::decode);
    }

    private static <T extends Packet> void register(Class<T> type, Function<FriendlyByteBuf, T> factory) {
        INSTANCE.registerMessage(nextId++, type, Packet::encode, factory, Packet::exec);
    }

    public static <MSG> void sendTo(MSG msg, ServerPlayer player) {
        INSTANCE.sendTo(msg, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static <MSG> void sendToClient(MSG message, Level level, BlockPos pos) {
        VisionNetwork.sendToClient(message, level.m_46745_(pos));
    }

    public static <MSG> void sendToClient(MSG msg, LevelChunk chunk) {
        INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> chunk), msg);
    }

    public static <MSG> void sendToAllTracking(MSG msg, LivingEntity entityToTrack) {
        INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> entityToTrack), msg);
    }

    public static <MSG> void sendToAll(MSG msg) {
        INSTANCE.send(PacketDistributor.ALL.noArg(), msg);
    }

    public static <MSG> void sendToServer(MSG msg) {
        INSTANCE.sendToServer(msg);
    }

    static {
        nextId = 0;
    }
}

