/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watervision;

import java.net.URI;
import java.util.concurrent.Executor;
import me.srrapero720.watervision.WaterVisionClient;
import me.srrapero720.watervision.client.render.TextureWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.watermedia.api.player.PlayerAPI;
import org.watermedia.api.player.videolan.VideoPlayer;

@Mod.EventBusSubscriber(modid="watervision", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class VisionOverlay {
    private static final int PADDING = 8;
    private static VideoPlayer player;
    private static final ResourceLocation TEXTURE;
    static URI uri;
    static URI activeUri;

    public static void onClientPause(boolean pause) {
        if (player != null && player.isPaused() != pause) {
            player.setPauseMode(pause);
        }
    }

    @SubscribeEvent
    public static void onRenderOverlayPost(RenderGuiOverlayEvent.Pre e) {
        if (uri != null && player == null) {
            player = new VideoPlayer(PlayerAPI.getFactory(), (Executor)Minecraft.m_91087_());
            Minecraft.m_91087_().m_91097_().m_118495_(TEXTURE, (AbstractTexture)new TextureWrapper(player.texture()));
            player.start(uri);
            activeUri = uri;
        }
        if (player == null) {
            return;
        }
        if (player.isBroken()) {
            Minecraft.m_91087_().m_240442_().m_240494_((Component)Component.m_237113_((String)"Failed to open a video overlay"), true);
            player.release();
            player = null;
            return;
        }
        if (uri == null && activeUri != null) {
            player.release();
            player = null;
            activeUri = null;
        }
        if (activeUri != uri) {
            player.start(uri);
            activeUri = uri;
        }
        if (player.isSafeUse() && player.isPlaying()) {
            player.preRender();
            GuiGraphics graphics = e.getGuiGraphics();
            int screenWidth = graphics.m_280182_();
            int screenHeight = graphics.m_280206_();
            int x = (int)((float)screenWidth / 1.6f) - 8;
            int y = (int)((float)screenHeight / 1.6f) - 8;
            int width = screenWidth - x;
            int height = screenHeight - y;
            WaterVisionClient.internal$blit(graphics, TEXTURE, 1.0f, x, y, 0, 0, width -= 8, height -= 8);
        } else if (player.isSafeUse() && player.isEnded()) {
            uri = null;
            activeUri = null;
            player.release();
            player = null;
        }
    }

    public static void onClientDisconnect() {
        if (player != null) {
            player.release();
        }
        player = null;
        uri = null;
    }

    static {
        TEXTURE = ResourceLocation.m_214293_((String)"watervision", (String)"overlay_texture");
    }
}

