/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.videolan4j.player.embedded.videosurface.callback;

import java.util.Arrays;
import org.watermedia.videolan4j.tools.Chroma;

public class BufferFormat {
    private final Chroma chroma;
    private final int width;
    private final int height;
    private final int[] pitches;
    private final int[] lines;

    public BufferFormat(Chroma chroma, int width, int height) {
        this.validate(width, height);
        this.chroma = chroma;
        this.width = width;
        this.height = height;
        this.pitches = chroma.getPitches(width);
        this.lines = chroma.getLines(height);
    }

    public final Chroma getChroma() {
        return this.chroma;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int[] getPitches() {
        return this.pitches;
    }

    public final int[] getLines() {
        return this.lines;
    }

    public final int getPlaneCount() {
        return this.pitches.length;
    }

    public final String toString() {
        return this.getClass().getSimpleName() + '[' + "chroma=" + (Object)((Object)this.chroma) + ',' + "width=" + this.width + ',' + "height=" + this.height + ',' + "pitches=" + Arrays.toString(this.pitches) + ',' + "lines=" + Arrays.toString(this.lines) + ']';
    }

    private void validate(int width, int height) {
        if (width <= 0) {
            throw new IllegalArgumentException("width must be greater than zero");
        }
        if (height <= 0) {
            throw new IllegalArgumentException("height must be greater than zero");
        }
    }
}

