/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.videolan4j.media;

import java.net.URI;
import org.watermedia.videolan4j.VideoLan4J;
import org.watermedia.videolan4j.binding.internal.libvlc_instance_t;
import org.watermedia.videolan4j.binding.internal.libvlc_media_t;
import org.watermedia.videolan4j.binding.lib.LibVlc;
import org.watermedia.videolan4j.media.Media;
import org.watermedia.videolan4j.media.MediaOptions;
import org.watermedia.videolan4j.media.MediaRef;
import org.watermedia.videolan4j.media.callback.CallbackMedia;

public final class MediaFactory {
    private MediaFactory() {
    }

    public static MediaRef newMediaRef(libvlc_instance_t libvlcInstance, libvlc_media_t mediaInstance, String ... options) {
        MediaRef result = MediaFactory.createMediaRef(libvlcInstance, mediaInstance, options);
        if (result != null) {
            LibVlc.libvlc_media_retain(mediaInstance);
        }
        return result;
    }

    public static MediaRef newMediaRef(libvlc_instance_t libvlcInstance, URI mrl, String ... options) {
        return MediaFactory.createMediaRef(libvlcInstance, VideoLan4J.createMediaInstance(libvlcInstance, mrl), options);
    }

    public static MediaRef newMediaRef(libvlc_instance_t libvlcInstance, CallbackMedia callbackMedia, String ... options) {
        return MediaFactory.createMediaRef(libvlcInstance, MediaFactory.newInstance(libvlcInstance, callbackMedia), options);
    }

    public static MediaRef newMediaRef(libvlc_instance_t libvlcInstance, Media media, String ... options) {
        return MediaFactory.createMediaRef(libvlcInstance, MediaFactory.retain(media.mediaInstance()), options);
    }

    public static MediaRef newMediaRef(libvlc_instance_t libvlcInstance, MediaRef mediaRef, String ... options) {
        return MediaFactory.createMediaRef(libvlcInstance, MediaFactory.retain(mediaRef.mediaInstance()), options);
    }

    public static MediaRef duplicateMediaRef(libvlc_instance_t libvlcInstance, MediaRef mediaRef, String ... options) {
        return MediaFactory.createMediaRef(libvlcInstance, LibVlc.libvlc_media_duplicate(mediaRef.mediaInstance()), options);
    }

    public static Media newMedia(libvlc_instance_t libvlcInstance, libvlc_media_t mediaInstance, String ... options) {
        Media result = MediaFactory.createMedia(libvlcInstance, mediaInstance, options);
        if (result != null) {
            LibVlc.libvlc_media_retain(mediaInstance);
        }
        return result;
    }

    public static Media newMedia(libvlc_instance_t libvlcInstance, URI mrl, String ... options) {
        return MediaFactory.createMedia(libvlcInstance, VideoLan4J.createMediaInstance(libvlcInstance, mrl), options);
    }

    public static Media newMedia(libvlc_instance_t libvlcInstance, CallbackMedia callbackMedia, String ... options) {
        return MediaFactory.createMedia(libvlcInstance, MediaFactory.newInstance(libvlcInstance, callbackMedia), options);
    }

    public static Media newMedia(libvlc_instance_t libvlcInstance, MediaRef mediaRef, String ... options) {
        return MediaFactory.createMedia(libvlcInstance, MediaFactory.retain(mediaRef.mediaInstance()), options);
    }

    public static Media newMedia(libvlc_instance_t libvlcInstance, Media media, String ... options) {
        return MediaFactory.createMedia(libvlcInstance, MediaFactory.retain(media.mediaInstance()), options);
    }

    public static Media duplicate(libvlc_instance_t libvlcInstance, Media media, String ... options) {
        return MediaFactory.createMedia(libvlcInstance, LibVlc.libvlc_media_duplicate(media.mediaInstance()), options);
    }

    private static libvlc_media_t newInstance(libvlc_instance_t libvlcInstance, CallbackMedia callbackMedia) {
        return LibVlc.libvlc_media_new_callbacks(libvlcInstance, callbackMedia.getOpen(), callbackMedia.getRead(), callbackMedia.getSeek(), callbackMedia.getClose(), callbackMedia.getOpaque());
    }

    private static libvlc_media_t retain(libvlc_media_t mediaInstance) {
        LibVlc.libvlc_media_retain(mediaInstance);
        return mediaInstance;
    }

    private static MediaRef createMediaRef(libvlc_instance_t libvlcInstance, libvlc_media_t mediaInstance, String[] options) {
        if (mediaInstance != null) {
            MediaOptions.addMediaOptions(mediaInstance, options);
            return new MediaRef(libvlcInstance, mediaInstance);
        }
        return null;
    }

    private static Media createMedia(libvlc_instance_t libvlcInstance, libvlc_media_t mediaInstance, String ... options) {
        if (mediaInstance != null) {
            Media media = new Media(libvlcInstance, mediaInstance);
            media.options().add(options);
            return media;
        }
        return null;
    }
}

