/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.videolan4j.discovery;

import com.sun.jna.Platform;
import java.util.regex.Pattern;
import org.watermedia.videolan4j.binding.lib.LibC;
import org.watermedia.videolan4j.tools.Tools;

public enum Environment {
    WINDOWS(Tools.patterns("libvlc\\.dll", "libvlccore\\.dll"), "plugins/", "vlc/plugins/"),
    MACOS(Tools.patterns("libvlc\\.dylib", "libvlccore\\.dylib"), "../plugins/"),
    LINUX(Tools.patterns("libvlc\\.so(?:\\.\\d)*", "libvlccore\\.so(?:\\.\\d)*"), "plugins/", "vlc/plugins/");

    final Pattern[] filePatterns;
    final String[] pluginPaths;

    public static String osName() {
        return System.getProperty("os.name");
    }

    public static Environment get() {
        switch (Platform.getOSType()) {
            case 2: {
                return WINDOWS;
            }
            case 0: {
                return MACOS;
            }
            case 1: {
                return LINUX;
            }
        }
        return null;
    }

    private Environment(Pattern[] filePatterns, String ... pluginPaths) {
        this.filePatterns = filePatterns;
        this.pluginPaths = pluginPaths;
    }

    public Pattern[] getFilePatterns() {
        return this.filePatterns;
    }

    public String[] getPluginPaths() {
        return this.pluginPaths;
    }

    public boolean setVar(String k, String v) {
        return LibC.setEnv(k, v, 1) == 0;
    }
}

