/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.videolan4j.binding.lib;

import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.win32.StdCallLibrary;
import com.sun.jna.win32.W32APIOptions;
import java.util.Map;
import org.watermedia.videolan4j.binding.lib.LibC;
import org.watermedia.videolan4j.binding.lib.size_t;

public interface Kernel32
extends StdCallLibrary {
    public static final Kernel32 INSTANCE = (Kernel32)Native.loadLibrary((String)"kernel32", Kernel32.class, (Map)W32APIOptions.DEFAULT_OPTIONS);

    public static int memoryLock(Pointer addr, long length) {
        if (!Platform.isWindows()) {
            return LibC.memoryLock(addr, length);
        }
        return INSTANCE.VirtualLock(addr, new size_t(length));
    }

    public static int memoryUnlock(Pointer addr, long length) {
        if (!Platform.isWindows()) {
            return LibC.memoryUnlock(addr, length);
        }
        return INSTANCE.VirtualUnlock(addr, new size_t(length));
    }

    public static Pointer heapAlloc(Pointer heap, int flags, size_t length) {
        return INSTANCE.HeapAlloc(heap, flags, length);
    }

    public static Pointer heapCreate(int options, size_t length, size_t maxLength) {
        return INSTANCE.HeapCreate(options, length, maxLength);
    }

    public static Pointer heapReAlloc(Pointer heap, int flags, Pointer pointer, size_t length) {
        return INSTANCE.HeapReAlloc(heap, flags, pointer, length);
    }

    public static boolean heapFree(Pointer heap, int flags, Pointer pointer) {
        return INSTANCE.HeapFree(heap, flags, pointer);
    }

    public int VirtualLock(Pointer var1, size_t var2);

    public int VirtualUnlock(Pointer var1, size_t var2);

    public Pointer HeapAlloc(Pointer var1, int var2, size_t var3);

    public Pointer HeapCreate(int var1, size_t var2, size_t var3);

    public Pointer HeapReAlloc(Pointer var1, int var2, Pointer var3, size_t var4);

    public boolean HeapFree(Pointer var1, int var2, Pointer var3);
}

