/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.kiulian.downloader.downloader.client;

import org.watermedia.shaded.fastjson.JSON;
import org.watermedia.shaded.fastjson.JSONObject;
import org.watermedia.shaded.kiulian.downloader.downloader.client.Client;

public enum DefaultClients implements Client
{
    WEB_PARENT_TOOLS("1.20220918", Client.baseJson()),
    ANDROID_VR("1.37", Client.baseJson(), Client.queryParam("context/client", "androidSdkVersion", "30")),
    WEB_HEROES("0.1", Client.baseJson()),
    TVHTML5_VR("0.1", Client.baseJson()),
    WEB_MUSIC_ANALYTICS("0.2", Client.baseJson()),
    WEB_MUSIC("1.0", Client.baseJson()),
    WEB("2.20220918", Client.baseJson()),
    TVHTML5_SIMPLY("1.0", Client.baseJson()),
    MWEB("2.20220918", Client.baseJson()),
    WEB_REMIX("1.20220918", Client.baseJson()),
    TVHTML5("7.20220918", Client.baseJson()),
    TVHTML5_CAST("1.1", Client.baseJson()),
    GOOGLE_LIST_RECS("0.1", Client.baseJson()),
    IOS_EMBEDDED_PLAYER("2.4", Client.baseJson()),
    ANDROID_TV("2.19.1.303051424", Client.baseJson(), Client.queryParam("context/client", "androidSdkVersion", "30")),
    IOS_MESSAGES_EXTENSION("17.36.4", Client.baseJson()),
    ANDROID_EMBEDDED_PLAYER("17.36.4", Client.baseJson(), Client.queryParam("context/client", "androidSdkVersion", "30")),
    IOS_LIVE_CREATION_EXTENSION("17.36.4", Client.baseJson()),
    WEB_PHONE_VERIFICATION("1.0.0", Client.baseJson()),
    IOS_PRODUCER("0.1", Client.baseJson()),
    WEB_EXPERIMENTS("1", Client.baseJson()),
    TVANDROID("1.0", Client.baseJson(), Client.queryParam("context/client", "androidSdkVersion", "30")),
    MWEB_TIER_2("9.20220918", Client.baseJson()),
    MUSIC_INTEGRATIONS("0.1", Client.baseJson()),
    MEDIA_CONNECT_FRONTEND("0.1", Client.baseJson()),
    IOS("17.36.4", Client.baseJson()),
    TVHTML5_YONGLE("0.1", Client.baseJson()),
    GOOGLE_ASSISTANT("0.1", Client.baseJson()),
    XBOXONEGUIDE("1.0", Client.baseJson()),
    WEB_INTERNAL_ANALYTICS("0.1", Client.baseJson()),
    GOOGLE_MEDIA_ACTIONS("0.1", Client.baseJson()),
    IOS_MUSIC("5.26.1", Client.baseJson()),
    ANDROID_MUSIC("5.26.1", Client.baseJson(), Client.queryParam("context/client", "androidSdkVersion", "30")),
    WEB_CREATOR("1.20220918", Client.baseJson()),
    IOS_CREATOR("22.36.102", Client.baseJson()),
    ANDROID_CREATOR("22.36.102", Client.baseJson(), Client.queryParam("context/client", "androidSdkVersion", "30")),
    ANDROID_LITE("3.26.1", Client.baseJson(), Client.queryParam("context/client", "androidSdkVersion", "30")),
    TVAPPLE("1.0", Client.baseJson()),
    TVLITE("2", Client.baseJson()),
    WEB_EMBEDDED_PLAYER("9.20220918", Client.baseJson()),
    TVHTML5_SIMPLY_EMBEDDED_PLAYER("2.0", Client.baseJson()),
    WEB_UNPLUGGED_OPS("0.1", Client.baseJson()),
    WEB_UNPLUGGED("1.20220918", Client.baseJson()),
    WEB_UNPLUGGED_ONBOARDING("0.1", Client.baseJson()),
    TV_UNPLUGGED_CAST("0.1", Client.baseJson()),
    TVHTML5_UNPLUGGED("6.36", Client.baseJson()),
    ANDROID_UNPLUGGED("6.36", Client.baseJson(), Client.queryParam("context/client", "androidSdkVersion", "30")),
    TV_UNPLUGGED_ANDROID("1.37", Client.baseJson(), Client.queryParam("context/client", "androidSdkVersion", "30")),
    WEB_UNPLUGGED_PUBLIC("0.1", Client.baseJson()),
    IOS_UNPLUGGED("6.36", Client.baseJson()),
    IOS_UPTIME("1.0", Client.baseJson()),
    IOS_KIDS("7.36.1", Client.baseJson()),
    ANDROID_TV_KIDS("1.19.1", Client.baseJson(), Client.queryParam("context/client", "androidSdkVersion", "30")),
    TVHTML5_AUDIO("2.0", Client.baseJson()),
    TVHTML5_FOR_KIDS("7.20220918", Client.baseJson()),
    ANDROID_KIDS("7.36.1", Client.baseJson(), Client.queryParam("context/client", "androidSdkVersion", "30")),
    TVHTML5_KIDS("3.20220918", Client.baseJson()),
    WEB_KIDS("2.20220918", Client.baseJson()),
    ANDROID("17.36.4", Client.baseJson(), Client.queryParam("context/client", "androidSdkVersion", "30")),
    ANDROID_TESTSUITE("1.9", Client.baseJson(), Client.queryParam("context/client", "androidSdkVersion", "30"));

    public static final Client[] VALUES;
    private static Client DEFAULT;
    private final String body;
    private final String version;

    public static void setDefaultClient(Client client) {
        DEFAULT = client;
    }

    public static Client defaultClient() {
        return DEFAULT;
    }

    private DefaultClients(String version, JSONObject body) {
        this(version, body, new Client.QueryParameter[0]);
    }

    private DefaultClients(String version, JSONObject body, Client.QueryParameter ... parameters) {
        this.version = version;
        JSONObject client = body.getJSONObject("context").getJSONObject("client");
        client.fluentPut("clientName", this.name());
        client.fluentPut("clientVersion", version);
        JSONObject cur = body;
        for (Client.QueryParameter param : parameters) {
            for (String p : param.path) {
                cur = cur.getJSONObject(p);
            }
            cur.fluentPut(param.key, param.value);
        }
        this.body = body.toJSONString();
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public String getBodyString() {
        return this.body;
    }

    @Override
    public JSONObject getBody() {
        return JSON.parseObject(this.body);
    }

    static {
        VALUES = DefaultClients.values();
        DEFAULT = VALUES[0];
    }
}

